/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.account.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.helper.TaxcCustomSourceDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.account.service.YhsTaxAccountDataService;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;

public class DimensionYhsTaxAccountDataServiceImpl
implements YhsTaxAccountDataService {
    private static final String TCRET_YSH_TAX_SOURCE_DE = "tcret_ysh_tax_source_de";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";

    @Override
    public void calculateTaxAccount(Map<String, Map<String, Object>> errorMap, Map<String, String> dataMap, List<DynamicObject> summaryList, List<DynamicObject> accountDetailList, EngineModel engineModel, DynamicObject rule, String sourceDetailEntity, DynamicObject yhsCardItem, Long baseTaxId) {
        String serialNo = UUID.randomUUID();
        String orgId = engineModel.getOrgId();
        Date skssqq = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)engineModel.getEndDate());
        DynamicObjectCollection ruleSettingList = rule.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> templist = new ArrayList<DynamicObject>();
        for (DynamicObject ruleSetting : ruleSettingList) {
            long dataSourceId = ruleSetting.getLong("table.id");
            String conditionJson = ruleSetting.getString("conditionjson");
            String advancedConfJson = ruleSetting.getString("advancedconfjson");
            String amountFieldEntity = ruleSetting.getDynamicObject("amountfield").getString("fieldsubname");
            String amountFieldNum = ruleSetting.getDynamicObject("amountfield").getString("fieldname");
            List list = TaxcCustomSourceDataServiceHelper.queryGroupBizData((Long)Long.parseLong(orgId), (Date)skssqq, (Date)skssqz, (Long)dataSourceId, (String)amountFieldNum, (String)amountFieldEntity, (String)conditionJson, (String)advancedConfJson, (Long)DeclareTaxType.YHS.getBaseTaxId());
            if (!EmptyCheckUtils.isNotEmpty((Object)list)) continue;
            for (Map amountMap : list) {
                DynamicObject accountDetail = YhsAccountServiceHelper.createAccountDetailDynamicObject(TCRET_YSH_TAX_SOURCE_DE, amountMap, serialNo, engineModel, skssqq, skssqz, rule, ruleSetting);
                accountDetailList.add(accountDetail);
                templist.add(accountDetail);
            }
        }
        Map<String, List<DynamicObject>> groupedAccountDetail = templist.stream().collect(Collectors.groupingBy(d -> d.getLong("accountorg") + "_" + d.get("bizdimensionid")));
        for (Map.Entry<String, List<DynamicObject>> entry : groupedAccountDetail.entrySet()) {
            List<DynamicObject> accountDetails = entry.getValue();
            BigDecimal calctaxamount = BigDecimalUtil.sumDynamicObjectAmount(accountDetails, (String)"amount");
            DynamicObject summary = YhsAccountServiceHelper.createTaxAccountDynamicObject(engineModel, rule, yhsCardItem, serialNo, calctaxamount);
            if (EmptyCheckUtils.isNotEmpty(accountDetails)) {
                DynamicObject accountDetail = accountDetails.get(0);
                summary.set("accountorg", accountDetail.get("accountorg"));
                summary.set("bizdimensiontype", accountDetail.get("bizdimensiontype"));
                summary.set("bizdimensionname", accountDetail.get("bizdimensionname"));
                summary.set("bizdimensionid", accountDetail.get("bizdimensionid"));
            }
            summaryList.add(summary);
        }
    }
}

