/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.account.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.account.service.YhsTaxAccountDataService;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.business.taxsource.task.AccountDetailTask;

public class GenericYhsTaxAccountDataServiceImpl
implements YhsTaxAccountDataService {
    private static final String TCRET_YSH_TAX_SOURCE_DE = "tcret_ysh_tax_source_de";

    @Override
    public void calculateTaxAccount(Map<String, Map<String, Object>> errorMap, Map<String, String> dataMap, List<DynamicObject> summaryList, List<DynamicObject> accountDetailList, EngineModel engineModel, DynamicObject rule, String sourceDetailEntity, DynamicObject yhsCardItem, Long baseTaxId) throws Exception {
        String serialNo = UUID.randomUUID();
        String ruleEntityName = rule.getDataEntityType().getName();
        DynamicObjectCollection ruleSettingList = rule.getDynamicObjectCollection("entryentity");
        AccountDetailTask ruleSettingTask = new AccountDetailTask(dataMap, errorMap, rule, engineModel, ruleSettingList, serialNo, TCRET_YSH_TAX_SOURCE_DE, "", ruleEntityName, yhsCardItem, DeclareTaxType.YHS.getBaseTaxId(), null);
        List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
        List accountingList = EngineTask.getFutureList((List)futures);
        accountDetailList.addAll(accountingList);
        BigDecimal calctaxamount = BigDecimalUtil.sumDynamicObjectAmount((List)accountingList, (String)"amount");
        if (calctaxamount.compareTo(BigDecimal.ZERO) <= 0 && "acsb".equals(yhsCardItem.get("declaretype"))) {
            return;
        }
        DynamicObject summary = YhsAccountServiceHelper.createTaxAccountDynamicObject(engineModel, rule, yhsCardItem, serialNo, calctaxamount);
        summaryList.add(summary);
    }
}

