/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.accrual.AccrualServiceHelper;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public class AccrualRequestValidator {
    public static void validateAndSetDefault(AccrualCalcDto accrualCalcDto) {
        if (EmptyCheckUtils.isEmpty((Object)accrualCalcDto.getOrgId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0corgId\u4e3a\u7a7a", (String)"AccrualRequestValidator_0", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isEmpty((Object)accrualCalcDto.getAccrualDate())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0caccrualDate\u4e3a\u7a7a", (String)"AccrualRequestValidator_1", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        AccrualListEnum accrualListEnum = AccrualListEnum.valueOfCateGory((String)accrualCalcDto.getCategory());
        if (EmptyCheckUtils.isEmpty((Object)accrualListEnum)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0ccategory\u4e3a\u7a7a\u6216\u4e0d\u652f\u6301\uff1a\u3010%s\u3011", (String)"AccrualRequestValidator_2", (String)"taxc-tcret", (Object[])new Object[0]), accrualCalcDto.getCategory()));
        }
        Long taxType = accrualListEnum.getBaseTaxId();
        accrualCalcDto.setTaxType(taxType);
        accrualCalcDto.setTemplateType(accrualCalcDto.getCategory());
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{accrualCalcDto.getOrgId()}), (Long)taxType, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)accrualCalcDto.getSkssqq(), (Date)accrualCalcDto.getSkssqz()).getData();
        if (dynamicObjectCollection.size() == 0 || ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.enable").equals("0")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AccrualRequestValidator_3", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        accrualCalcDto.setAccrualPlan(((DynamicObject)dynamicObjectCollection.get(0)).getLong("ruleentity.rule"));
        String cycle = ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.cycle");
        Boolean parameter = TcretSystemParamUtil.getInTaxPeriodJT(accrualCalcDto.getOrgId());
        Map skssqzMap = DateUtils.getSkssqzMap((Date)accrualCalcDto.getAccrualDate(), (String)cycle, (Boolean)parameter);
        if (EmptyCheckUtils.isEmpty((Object)skssqzMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6708\u4efd\u4e0d\u80fd\u751f\u6210\u5bf9\u5e94\u8ba1\u63d0\u65b9\u6848\u6570\u636e", (String)"AccrualRequestValidator_4", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (!Objects.equals(DateUtils.format((Date)accrualCalcDto.getSkssqq()), DateUtils.format((Date)((Date)skssqzMap.get("skssqq")))) || !Objects.equals(DateUtils.format((Date)accrualCalcDto.getSkssqz()), DateUtils.format((Date)((Date)skssqzMap.get("skssqz"))))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u5bf9\u5e94\u7684\u8ba1\u63d0\u5468\u671f\u4e0e\u8ba1\u63d0\u5c5e\u671f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5e95\u7a3f", (String)"AccrualRequestValidator_5", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(accrualCalcDto.getOrgId()), (Date)accrualCalcDto.getSkssqq(), (Date)accrualCalcDto.getSkssqz());
        accrualCalcDto.setAccountOrgId(EmptyCheckUtils.isNotEmpty((Object)orgRelations) ? (Long)orgRelations.get(0) : accrualCalcDto.getOrgId());
        DynamicObject accrual = AccrualServiceHelper.queryAccrual(accrualCalcDto.getOrgId(), accrualCalcDto.getTemplateType(), accrualCalcDto.getSkssqq(), accrualCalcDto.getSkssqz());
        if (accrual != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u6570\u636e\u5df2\u5b58\u5728", (String)"AccrualRequestValidator_6", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }
}

