/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.business.accrual.AccrualCalcServiceFactory;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.common.enums.TcretAccrualEnum;

public class AccrualServiceHelper {
    private static final Map<String, MultiLangEnumBridge> map = new HashMap<String, MultiLangEnumBridge>();

    public static void generate(AccrualCalcDto accrualCalcDto) {
        AccrualCalcService service = AccrualCalcServiceFactory.getService(accrualCalcDto.getCategory());
        DynamicObject accrualDraftObj = service.doCalAccrualInfo(accrualCalcDto);
        service.doCalcAccrualDetails(accrualDraftObj);
        if (EmptyCheckUtils.isEmpty((Object)accrualDraftObj) || EmptyCheckUtils.isEmpty((Object)accrualDraftObj.getDynamicObjectCollection("entryentity"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8ba1\u63d0\u660e\u7ec6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5e95\u7a3f", (String)"AccrualServiceHelper_6", (String)"taxc-tcret", (Object[])new Object[0]), map.getOrDefault(accrualCalcDto.getCategory(), new MultiLangEnumBridge(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"AccrualServiceHelper_0", (String)"taxc-tcret", (Object[])new Object[0]), "AccrualServiceHelper_0", "taxc-tcret")).loadKDString());
            throw new KDBizException(errorMsg);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{accrualDraftObj});
        AccrualMQSender.sendMQ((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)accrualDraftObj.getPkValue(), (String)accrualDraftObj.getDataEntityType().getName()));
    }

    public static AccrualCalcDto buildAccrualCalcDto(AccrualRequest accrualRequest) {
        AccrualCalcDto accrualCalcDto = new AccrualCalcDto();
        accrualCalcDto.setCategory(accrualRequest.getCategory());
        if (EmptyCheckUtils.isNotEmpty((Object)accrualRequest.getOrgId())) {
            accrualCalcDto.setOrgId(Long.valueOf(accrualRequest.getOrgId()));
        }
        accrualCalcDto.setSkssqq(accrualRequest.getSkssqq());
        accrualCalcDto.setSkssqz(accrualRequest.getSkssqz());
        accrualCalcDto.setAccrualDate(accrualRequest.getAccrualDate());
        accrualCalcDto.setBillNo(DeclareServiceHelper.generateSBBNo((String)AccrualServiceHelper.getEntryEntity(accrualRequest.getCategory())));
        return accrualCalcDto;
    }

    private static String getEntryEntity(String category) {
        return TcretAccrualEnum.getEntityByDraftType(category);
    }

    public static DynamicObject queryAccrual(Long orgId, String templateType, Date skssqq, Date skssqz) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("templatetype", "=", (Object)templateType));
        qFilters.add(new QFilter("skssqq", "=", (Object)skssqq));
        qFilters.add(new QFilter("skssqz", "=", (Object)skssqz));
        qFilters.add(new QFilter("pzhc", "=", (Object)"0"));
        DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (object != null) {
            return BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"tpo_declare_main_tsd");
        }
        return null;
    }

    public static DynamicObject queryAccrualById(Long id) {
        return QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"id,billstatus,generatebusinessdoc", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    static {
        map.put("fcs", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e", "AccrualServiceHelper_0", "taxc-tcret"));
        map.put("cztdsys", new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", "AccrualServiceHelper_1", "taxc-tcret"));
        map.put("yhs", new MultiLangEnumBridge("\u5370\u82b1\u7a0e", "AccrualServiceHelper_2", "taxc-tcret"));
        map.put("ccs", new MultiLangEnumBridge("\u8f66\u8239\u7a0e", "AccrualServiceHelper_3", "taxc-tcret"));
        map.put("hjbhs", new MultiLangEnumBridge("\u73af\u4fdd\u7a0e", "AccrualServiceHelper_4", "taxc-tcret"));
        map.put("szys", new MultiLangEnumBridge("\u6c34\u8d44\u6e90\u7a0e", "AccrualServiceHelper_5", "taxc-tcret"));
    }
}

