/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcret.business.accrual.AccrualCalcDtoBuilder;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.business.dimension.ProvisionDimensionHelper;
import kd.taxc.tcret.common.entity.AccrualCalcDto;
import kd.taxc.tcret.common.utils.DynamicUtils;
import kd.taxc.tcret.common.utils.HbsUtils;

public class HbsAccrualServiceImpl
implements AccrualCalcService {
    private static final String SELECT_FIELDS_AIR_WATER = "id,number,name as projectname,month,wrwmc,wrwzszm,wrwdls,dwse,jmse,ynse,wrwlb.number,swrzl.number,wrwmc.id,number1.accountorg as accountorg,number1.bizdimensiontype as bizdimensiontype,number1.bizdimensionname as bizdimensionname,number1.bizdimensionid as bizdimensionid";
    private static final String SELECT_FIELDS_SOLID_WASTE = "id,number,pfkname as projectname,month,wrwmc,wrwzszm,wrwpfl,dwse,jmse,ynse,pollutiondataid.accountorg as accountorg,pollutiondataid.bizdimensiontype as bizdimensiontype,pollutiondataid.bizdimensionname as bizdimensionname,pollutiondataid.bizdimensionid as bizdimensionid";
    private static final String SELECT_FIELDS_NOISE = "id,sourcenumber.number as number,sourcenumber.name as projectname,month,entryentity.sm as sm,entryentity.jsyj as jsyj,entryentity.dwse as sl,entryentity.ynse as ynse,sourcenumber.accountorg as accountorg,sourcenumber.bizdimensiontype as bizdimensiontype,sourcenumber.bizdimensionname as bizdimensionname,sourcenumber.bizdimensionid as bizdimensionid";

    @Override
    public DynamicObject doCalAccrualInfo(AccrualCalcDto accrualCalcDto) {
        return AccrualCalcDtoBuilder.doInitAccrualObj(accrualCalcDto, "tcret_hbs_accrual_draft");
    }

    @Override
    public DynamicObjectCollection doCalcAccrualDetails(DynamicObject accrualDraftObj) {
        DynamicObjectCollection detailList = accrualDraftObj.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = detailList.getDynamicObjectType().getProperties();
        long orgId = accrualDraftObj.getDynamicObject("org").getLong("id");
        String type = ProvisionDimensionHelper.getDimensionType(String.valueOf(orgId), DeclareTaxType.HBS.getBaseTaxId(), accrualDraftObj.getDate("skssqq"), accrualDraftObj.getDate("skssqz"));
        DynamicObjectCollection provisionPlans = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)DeclareTaxType.HBS.getBaseTaxId(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)accrualDraftObj.getDate("skssqq"), (Date)accrualDraftObj.getDate("skssqz")).getData();
        DynamicObject provisionPlan = provisionPlans.stream().findFirst().orElse(null);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter dateFilter = new QFilter("month", ">=", (Object)accrualDraftObj.getDate("skssqq")).and(new QFilter("month", "<=", (Object)accrualDraftObj.getDate("skssqz")));
        DynamicObjectCollection tdmPollutionAirWater = QueryServiceHelper.query((String)"tdm_pollution_air_water", (String)SELECT_FIELDS_AIR_WATER, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"month");
        List<Long> filterIds = HbsUtils.filterPollutionAirWater(tdmPollutionAirWater);
        tdmPollutionAirWater.stream().filter(source -> filterIds.contains(source.getLong("id"))).forEach(source -> {
            DynamicObject detail = detailList.addNew();
            detail.set("taxmonth", source.get("month"));
            detail.set("taxitem", (Object)HbsUtils.doQueryTaxItem(source.getLong("wrwzszm"), source.getLong("wrwmc")));
            detail.set("calsource", (Object)source.getBigDecimal("wrwdls").setScale(2, 4));
            detail.set("hbssl", (Object)source.getBigDecimal("dwse").setScale(2, 4));
            detail.set("ynse", source.get("ynse"));
            detail.set("jmse", source.get("jmse"));
            detail.set("jtynse", (Object)detail.getBigDecimal("ynse").subtract(detail.getBigDecimal("jmse")).setScale(2, 4));
            if ("dimension".equals(type)) {
                this.addDimensionData(accrualDraftObj, properties, provisionPlan, detail, (DynamicObject)source);
            }
        });
        DynamicObjectCollection tdmSolidWasteInfo = QueryServiceHelper.query((String)"tdm_solid_waste_info", (String)SELECT_FIELDS_SOLID_WASTE, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"month");
        tdmSolidWasteInfo.forEach(source -> {
            DynamicObject detail = detailList.addNew();
            detail.set("taxmonth", source.get("month"));
            detail.set("taxitem", (Object)HbsUtils.doQueryTaxItem(source.getLong("wrwzszm"), source.getLong("wrwmc")));
            detail.set("calsource", (Object)source.getBigDecimal("wrwpfl").setScale(2, 4));
            detail.set("hbssl", (Object)source.getBigDecimal("dwse").setScale(2, 4));
            detail.set("ynse", source.get("ynse"));
            detail.set("jmse", source.get("jmse"));
            detail.set("jtynse", (Object)detail.getBigDecimal("ynse").subtract(detail.getBigDecimal("jmse")).setScale(2, 4));
            if ("dimension".equals(type)) {
                this.addDimensionData(accrualDraftObj, properties, provisionPlan, detail, (DynamicObject)source);
            }
        });
        DynamicObjectCollection noiseInfoList = QueryServiceHelper.query((String)"tdm_noise_info", (String)SELECT_FIELDS_NOISE, (QFilter[])new QFilter[]{orgFilter, dateFilter}, (String)"month");
        noiseInfoList.forEach(noise -> {
            DynamicObject detail = detailList.addNew();
            detail.set("taxmonth", noise.get("month"));
            detail.set("taxitem", noise.get("sm"));
            detail.set("calsource", (Object)noise.getBigDecimal("jsyj").setScale(2, 4));
            detail.set("hbssl", (Object)noise.getBigDecimal("sl").setScale(2, 4));
            detail.set("ynse", noise.get("ynse"));
            detail.set("jtynse", (Object)detail.getBigDecimal("ynse").subtract(detail.getBigDecimal("jmse")).setScale(2, 4));
            if ("dimension".equals(type)) {
                this.addDimensionData(accrualDraftObj, properties, provisionPlan, detail, (DynamicObject)noise);
            }
        });
        accrualDraftObj.set("jtynsesum", (Object)this.doSumJtynse(detailList));
        return detailList;
    }

    private void addDimensionData(DynamicObject accrualDraftObj, DataEntityPropertyCollection properties, DynamicObject provisionPlan, DynamicObject detail, DynamicObject source) {
        if (EmptyCheckUtils.isNotEmpty((Object)provisionPlan)) {
            detail.set("itemno", source.get("number"));
            detail.set("projectname", source.get("projectname"));
            boolean isdimprovision = provisionPlan.getBoolean("ruleentity.rule.isdimprovision");
            String provisiondimension = provisionPlan.getString("ruleentity.rule.provisiondimension");
            if (isdimprovision && provisiondimension.contains("accountorg") && source.getLong("accountorg") != 0L) {
                detail.set("accorg", (Object)DynamicUtils.setDynamicObject(properties, "accorg", source.get("accountorg")));
            } else {
                detail.set("accorg", accrualDraftObj.get("accountorg"));
            }
            if (isdimprovision && provisiondimension.contains("businessdimension")) {
                detail.set("bizdimensiontype", (Object)DynamicUtils.setDynamicObject(properties, "bizdimensiontype", source.get("bizdimensiontype")));
                detail.set("bizdimensionname", source.get("bizdimensionname"));
                detail.set("bizdimensionid", source.get("bizdimensionid"));
            }
        } else {
            detail.set("accorg", accrualDraftObj.get("accountorg"));
        }
    }
}

