/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.accrual.AccrualCalcDtoBuilder;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.business.taxsource.TcwatSourceServiceHelper;
import kd.taxc.tcret.common.entity.AccrualCalcDto;

public class SzysAccrualServiceImpl
implements AccrualCalcService {
    @Override
    public DynamicObject doCalAccrualInfo(AccrualCalcDto accrualCalcDto) {
        return AccrualCalcDtoBuilder.doInitAccrualObj(accrualCalcDto, "tcret_szys_accrual_draft");
    }

    @Override
    public DynamicObjectCollection doCalcAccrualDetails(DynamicObject accrualDraftObj) {
        DynamicObjectCollection detailList = accrualDraftObj.getDynamicObjectCollection("entryentity");
        DynamicObject org = accrualDraftObj.getDynamicObject("org");
        Date skssqq = accrualDraftObj.getDate("skssqq");
        Date skssqz = accrualDraftObj.getDate("skssqz");
        QFilter q1 = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter q3 = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection tdm_water_resource = QueryServiceHelper.query((String)"tdm_water_resource", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        Object[] ids = tdm_water_resource.stream().map(d -> d.getLong("id")).toArray();
        DynamicObject[] waterResources = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tdm_water_resource"));
        Map<String, List<DynamicObject>> map = Arrays.stream(waterResources).collect(Collectors.groupingBy(d -> d.getDynamicObject("taxsource").getString("sysbb")));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"tcret_szys_accrual_draft");
        BasedataProp property = (BasedataProp)dataEntityType.findProperty("taxsource");
        DynamicObjectType dynamicObjectType = (DynamicObjectType)property.getComplexType((Object)accrualDraftObj);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> waterResourceList = entry.getValue();
            if ("A".equals(key)) {
                this.buildSzysTaxDetailsA(dynamicObjectType, detailList, waterResourceList);
                continue;
            }
            if (!"B".equals(key)) continue;
            this.buildSzysTaxDetailsB(dynamicObjectType, detailList, waterResourceList);
        }
        accrualDraftObj.set("jtynsesum", (Object)this.doSumJtynse(detailList));
        return detailList;
    }

    private void buildSzysTaxDetailsA(DynamicObjectType dynamicObjectType, DynamicObjectCollection detailList, List<DynamicObject> waterResourceList) {
        for (DynamicObject waterResource : waterResourceList) {
            DynamicObject object = detailList.addNew();
            DynamicObject taxsource = BusinessDataServiceHelper.loadSingleFromCache((Object)waterResource.getLong("taxsource.id"), (DynamicObjectType)dynamicObjectType);
            object.set("taxsource", (Object)taxsource);
            BigDecimal sqljqsl = waterResource.getBigDecimal("sqljqsl");
            object.set("sqljqsl", (Object)sqljqsl);
            BigDecimal bqqsl = waterResource.getBigDecimal("bqqsl");
            object.set("calsource", (Object)bqqsl);
            object.set("syse", (Object)taxsource.getBigDecimal("sysl"));
            BigDecimal ynse = TcwatSourceServiceHelper.calculateYnseForA(taxsource, sqljqsl, bqqsl);
            object.set("ynse", (Object)ynse);
            BigDecimal jmse = BigDecimal.ZERO;
            object.set("jmse", (Object)jmse);
            BigDecimal jtynse = BigDecimalUtil.subtractObject((Object)ynse, (Object)jmse);
            object.set("jtynse", (Object)BigDecimalUtil.max((Object)jtynse, (Object)BigDecimal.ZERO));
            object.set("createtype", (Object)"system");
        }
    }

    private void buildSzysTaxDetailsB(DynamicObjectType dynamicObjectType, DynamicObjectCollection detailList, List<DynamicObject> waterResourceList) {
        for (DynamicObject waterResource : waterResourceList) {
            DynamicObject taxsource = BusinessDataServiceHelper.loadSingleFromCache((Object)waterResource.getLong("taxsource.id"), (DynamicObjectType)dynamicObjectType);
            DynamicObjectCollection entryentity = waterResource.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                DynamicObject object = detailList.addNew();
                object.set("taxsource", (Object)taxsource);
                object.set("zszm", (Object)entry.getDynamicObject("zszm"));
                object.set("sqljqsl", entry.get("sqljqslb"));
                BigDecimal bqqslb = entry.getBigDecimal("bqqslb");
                object.set("calsource", (Object)bqqslb);
                DynamicObject zszmConfig = TcwatSourceServiceHelper.getZszmConfig(entry.getDynamicObject("zszm"), taxsource);
                BigDecimal syse = zszmConfig != null ? zszmConfig.getBigDecimal("taxamount") : BigDecimal.ZERO;
                object.set("syse", (Object)syse);
                BigDecimal ynse = TcwatSourceServiceHelper.calculateYnseForB(zszmConfig, bqqslb);
                object.set("ynse", (Object)ynse);
                BigDecimal jmse = BigDecimal.ZERO;
                object.set("jmse", (Object)jmse);
                BigDecimal jtynse = BigDecimalUtil.subtractObject((Object)ynse, (Object)jmse);
                object.set("jtynse", (Object)BigDecimalUtil.max((Object)jtynse, (Object)BigDecimal.ZERO));
                object.set("createtype", (Object)"system");
            }
        }
    }
}

