/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.impl;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.accrual.AccrualCalcDtoBuilder;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.business.accrual.yhs.YhsAccrualDataService;
import kd.taxc.tcret.business.accrual.yhs.YhsAccrualDataServiceFactory;
import kd.taxc.tcret.business.dimension.ProvisionDimensionHelper;
import kd.taxc.tcret.common.entity.AccrualCalcDto;

public class YhsAccrualServiceImpl
implements AccrualCalcService {
    private static Log logger = LogFactory.getLog(YhsAccrualServiceImpl.class);

    @Override
    public DynamicObject doCalAccrualInfo(AccrualCalcDto accrualCalcDto) {
        DynamicObject accrualDraftObj = AccrualCalcDtoBuilder.doInitAccrualObj(accrualCalcDto, "tcret_yhs_acccrual");
        String isxxwlqy = TaxBaseDataUtils.isXxwlqy((String)accrualCalcDto.getOrgId().toString(), (Date)accrualCalcDto.getSkssqq(), (Date)accrualCalcDto.getSkssqz());
        accrualDraftObj.set("isxxwlqy", (Object)isxxwlqy);
        return accrualDraftObj;
    }

    @Override
    public DynamicObjectCollection doCalcAccrualDetails(DynamicObject accrualDraftObj) {
        String orgId = accrualDraftObj.getDynamicObject("org").getString("id");
        Date startdate = accrualDraftObj.getDate("skssqq");
        Date enddate = accrualDraftObj.getDate("skssqz");
        EngineModel engineModel = new EngineModel(orgId, DateUtils.format((Date)startdate), DateUtils.format((Date)enddate));
        engineModel.getCustom().put("FromClass", "YhsAccrualDraftFormPlugin");
        engineModel.getCustom().put("org", orgId);
        engineModel.getCustom().put("isxxwlqy", accrualDraftObj.getString("isxxwlqy"));
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(Collections.singletonList(Long.parseLong(orgId)), (Date)startdate, (Date)enddate);
        engineModel.addCustom("OrgRelationMap", (Object)orgRelationMap);
        DynamicObjectCollection detailList = accrualDraftObj.getDynamicObjectCollection("entryentity");
        try {
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(engineModel.getOrgId()));
            QFilter startFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)engineModel.getStartDate()));
            QFilter endFilter = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)engineModel.getEndDate()));
            DeleteServiceHelper.delete((String)"tcret_yhs_sjjt_detail", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
            DeleteServiceHelper.delete((String)"tcret_yhsjt_adjust", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
            logger.info("\u5f00\u59cb\u6267\u884c\u5370\u82b1\u7a0e\u7a0e\u91d1\u8ba1\u63d0\u5f15\u64ce");
            long start = System.currentTimeMillis();
            String type = ProvisionDimensionHelper.getDimensionType(engineModel.getOrgId(), DeclareTaxType.YHS.getBaseTaxId(), startdate, enddate);
            YhsAccrualDataService yhsAccrualDataService = YhsAccrualDataServiceFactory.getService(type);
            yhsAccrualDataService.execute(detailList, engineModel);
            accrualDraftObj.set("jtynsesum", (Object)this.doSumJtynse(detailList));
            logger.info("\u7ed3\u675f\u6267\u884c\u5370\u82b1\u7a0e\u7a0e\u91d1\u8ba1\u63d0\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return detailList;
    }
}

