/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.accrual.yhs.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.DiscountHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.accrual.yhs.impl.AbstractYhsAccrualDataServiceImpl;
import kd.taxc.tcret.business.taxsource.task.AccountDetailTask;
import kd.taxc.tcret.common.utils.DynamicUtils;
import kd.taxc.tcret.common.utils.YhsAccrualUtils;
import kd.taxc.tcret.common.utils.YhsUtils;

public class GenericYhsAccrualDataServiceImpl
extends AbstractYhsAccrualDataServiceImpl {
    private static final String SPLIT = "#";

    @Override
    protected void setAccrualDetailList(DynamicObjectCollection detailList, EngineModel engineModel, List<DynamicObject> rules, List<Long> fitTaxItem) throws Exception {
        Map custom = engineModel.getCustom();
        String orgId = engineModel.getOrgId();
        Long defaultAccountOrg = (Long)OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)Long.parseLong(orgId)).getData();
        String isXxwlqy = (String)custom.get("isxxwlqy");
        HashMap<String, Map<String, List<String>>> allCollectMap = new HashMap<String, Map<String, List<String>>>();
        if (EmptyCheckUtils.isNotEmpty(rules)) {
            List<DynamicObject> accountingSaveList = this.getYhsRules(fitTaxItem, rules, engineModel, allCollectMap, isXxwlqy);
            this.setDetail(allCollectMap, detailList, accountingSaveList, isXxwlqy, defaultAccountOrg);
        }
    }

    private List<DynamicObject> getYhsRules(List<Long> fitTaxItem, List<DynamicObject> rules, EngineModel engineModel, Map<String, Map<String, List<String>>> allCollectMap, String isXxwlqy) throws Exception {
        Date date = DateUtils.stringToDate2((String)"2022-06-30");
        Date skssqq = DateUtils.stringToDate2((String)engineModel.getStartDate());
        Date skssqz = DateUtils.stringToDate2((String)engineModel.getEndDate());
        List<DynamicObject> yhsEntityList = YhsUtils.queryYhsEntityList(Long.parseLong(engineModel.getOrgId()));
        ConcurrentHashMap<String, Map<String, Object>> errorMap = new ConcurrentHashMap<String, Map<String, Object>>();
        ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
        ArrayList<DynamicObject> accountingSaveList = new ArrayList<DynamicObject>();
        for (DynamicObject rule : rules) {
            DynamicObject subtaxitem;
            String taxitem = rule.getDynamicObject("taxitem").getString("name");
            DynamicObject deductioncode = rule.getDynamicObject("deductioncode");
            String deductiontype = deductioncode != null ? deductioncode.getString("deductiontype") : "";
            String declaretype = rule.getString("declaretype");
            String taxlimit = YhsAccrualUtils.findPeriodInYhsEntitys(yhsEntityList, taxitem, skssqq, skssqz, declaretype);
            String rate = rule.getDynamicObject("taxitem").getString("taxrate");
            String entityName = rule.getDynamicObjectType().getName();
            String allCollectMapKey = taxlimit + SPLIT + deductiontype + SPLIT + taxitem;
            if (!"tcsd_rule_zjzb".equals(entityName) && null != (subtaxitem = rule.getDynamicObject("subtaxitem")) && skssqz.after(DateUtils.getDayLast((Date)date))) {
                String value = subtaxitem.getString("value");
                if (!StringUtils.isEmpty((Object)value)) {
                    rate = value;
                }
                allCollectMapKey = allCollectMapKey + SPLIT + subtaxitem.get("id");
            }
            if (allCollectMapKey.split(SPLIT).length == 3) {
                allCollectMapKey = allCollectMapKey + SPLIT + "0";
            }
            String taxrate = rate.replace("\u2030", "");
            BigDecimal jmrate = DiscountHelper.calculateDiscountRate((DynamicObject)deductioncode, (String)isXxwlqy);
            String serialno = UUID.randomUUID();
            DynamicObjectCollection entryentity = rule.getDynamicObjectCollection("entryentity");
            if (!fitTaxItem.contains(rule.getLong("taxitem.id"))) {
                entryentity.removeIf(d -> !"tcret_yhs_tax_source_info".equals(d.getDynamicObject("table").getString("entityname")));
            }
            if (EmptyCheckUtils.isEmpty((Object)entryentity)) continue;
            AccountDetailTask ruleSettingTask = new AccountDetailTask(dataMap, errorMap, rule, engineModel, entryentity, serialno, "tcret_yhs_sjjt_detail", taxrate, rule.getDataEntityType().getName(), null, DeclareTaxType.YHS.getBaseTaxId(), jmrate);
            List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
            List accountingList = EngineTask.getFutureList((List)futures);
            accountingSaveList.addAll(accountingList);
            for (DynamicObject dynamicObject : accountingList) {
                String map = (String)dynamicObject.get("businessmap");
                Map businessmap = (Map)SerializationUtils.fromJsonString((String)map, Map.class);
                if (!CollectionUtils.isEmpty((Map)businessmap)) {
                    businessmap.entrySet().removeIf(entry -> entry.getValue() == null);
                }
                String key = allCollectMapKey;
                if ("tcret_yhs_tax_source_info".equals(dynamicObject.getDynamicObject("table").getString("entityname"))) {
                    dynamicObject.set("datasource", (Object)"tcret_yhs_tax_source_info");
                    key = allCollectMapKey + SPLIT + "tcret_yhs_tax_source_info";
                }
                if (allCollectMap.containsKey(key)) {
                    allCollectMap.put(key, this.addTaxitemList(allCollectMap.get(key), businessmap));
                    continue;
                }
                allCollectMap.put(key, businessmap);
            }
        }
        SaveServiceHelper.save((DynamicObject[])accountingSaveList.toArray(new DynamicObject[0]));
        return accountingSaveList;
    }

    private void setDetail(Map<String, Map<String, List<String>>> allCollectMap, DynamicObjectCollection detailList, List<DynamicObject> accountingSaveList, String isXxwlqy, Long defaultAccountOrg) {
        DataEntityPropertyCollection properties = detailList.getDynamicObjectType().getProperties();
        for (Map.Entry<String, Map<String, List<String>>> entry : allCollectMap.entrySet()) {
            String[] keys = entry.getKey().split(SPLIT);
            String deductiontype = keys[1];
            String taxitem = keys[2];
            String subtaxitem = keys[3];
            Map<String, List<String>> map = entry.getValue();
            for (Map.Entry<String, List<String>> entrydetail : map.entrySet()) {
                String bosorgid = entrydetail.getKey();
                List<String> amountList = entrydetail.getValue();
                DynamicObject rententryentity = detailList.addNew();
                rententryentity.set("accorg", (Object)DynamicUtils.setDynamicObject(properties, "accorg", defaultAccountOrg));
                try {
                    rententryentity.set("bosorg", (Object)DynamicUtils.setDynamicObject(properties, "bosorg", Long.valueOf(bosorgid)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                rententryentity.set("taxitem", (Object)taxitem);
                rententryentity.set("subtaxitem", (Object)DynamicUtils.setDynamicObject(properties, "subtaxitem", Long.valueOf(subtaxitem)));
                rententryentity.set("deductiontype", (Object)keys[1]);
                rententryentity.set("taxlimit", (Object)keys[0]);
                BigDecimal jsje = BigDecimalUtil.setScale((Object)amountList.get(0), (int)2);
                rententryentity.set("jsje", (Object)jsje);
                String hdbl = amountList.get(1);
                if (BigDecimalUtil.toBigDecimal((Object)hdbl).compareTo(BigDecimal.ZERO) > 0) {
                    rententryentity.set("hdbl", (Object)BigDecimalUtil.setScale((Object)hdbl, (int)2));
                }
                BigDecimal calsource = YhsAccrualUtils.calculateCalSource(jsje, BigDecimalUtil.toBigDecimal((Object)hdbl));
                rententryentity.set("calsource", (Object)calsource);
                rententryentity.set("taxrate", (Object)amountList.get(3));
                BigDecimal ynse = YhsAccrualUtils.calculateYnse(calsource, BigDecimalUtil.toBigDecimal((Object)amountList.get(3)));
                rententryentity.set("ynse", (Object)ynse);
                BigDecimal jmrate = DiscountHelper.calculateDiscountRate((String)deductiontype, (String)isXxwlqy);
                BigDecimal jmse = YhsAccrualUtils.calculateJmse(ynse, jmrate);
                rententryentity.set("jmse", (Object)jmse);
                BigDecimal jtynse = YhsAccrualUtils.calculateJtynse(ynse, jmse, BigDecimal.ZERO);
                rententryentity.set("jtynse", (Object)jtynse);
                if (!entry.getKey().endsWith("#tcret_yhs_tax_source_info")) continue;
                rententryentity.set("datasource", (Object)"tcret_yhs_tax_source_info");
            }
        }
    }
}

