/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declareitem.service.DeclareItemListService;
import kd.taxc.tcret.business.declare.declaretaxable.service.DeclareTaxableListService;
import kd.taxc.tcret.business.declare.provider.ServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.CcsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.FcsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.HbsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.QsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.TdzzsQsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.TdzzsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.TdzzsYjServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.YhsServiceProvider;
import kd.taxc.tcret.business.declare.provider.impl.ZysServiceProvider;
import kd.taxc.tcret.common.enums.TcretTaxTypeEnum;

public class DeclareItemServiceHelper {
    private static List<ServiceProvider> providerList = new ArrayList<ServiceProvider>(10);

    public static DynamicObjectCollection queryList(Map<String, Object> customParams) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
        DynamicObjectCollection resultCollection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        String zerodeclare = (String)customParams.get("zerodeclare");
        String haslicense = (String)customParams.get("haslicense");
        if ("true".equals(zerodeclare) && "false".equals(haslicense)) {
            DeclareItemListService service = new YhsServiceProvider().createDeclareItemListService();
            resultCollection.addAll((Collection)service.queryList(customParams));
        } else {
            for (ServiceProvider serviceProvider : providerList) {
                DeclareItemListService service = serviceProvider.createDeclareItemListService();
                resultCollection.addAll((Collection)service.queryList(customParams));
            }
        }
        return resultCollection;
    }

    public static List<Map<String, Object>> queryDeclareTaxableList(List<Long> orgList, Date declareDate) {
        ArrayList<Map<String, Object>> taxableListDtos = new ArrayList<Map<String, Object>>();
        TaxResult result = TaxcLicenseCheckDataServiceHelper.checkBatch(orgList, (String)"tcret");
        HashMap<Long, Boolean> licenseMap = result == null ? new HashMap() : (Map)result.getData();
        for (ServiceProvider serviceProvider : providerList) {
            DeclareTaxableListService service = serviceProvider.createDeclareTaxableListService();
            taxableListDtos.addAll(service.queryDeclareTaxableList(licenseMap, declareDate));
        }
        Date startDate = DateUtils.getFirstDateOfMonth((Date)declareDate);
        Date endDate = DateUtils.getLastDateOfMonth((Date)declareDate);
        QFilter filter1 = new QFilter("org", "in", orgList);
        QFilter filter2 = new QFilter("declaredate", ">=", (Object)DateUtils.getDayFirst((Date)startDate)).and(new QFilter("declaredate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        filter1.and(new QFilter("entryentity.taxtype", "not like", (Object)"zys%"));
        DynamicObjectCollection declareEntryList = QueryServiceHelper.query((String)"tcret_declare_main", (String)"org,taxauthority,sbbid,entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz", (QFilter[])new QFilter[]{filter1, filter2});
        Map<String, DynamicObject> declareEntryMap = declareEntryList.stream().collect(Collectors.toMap(DeclareItemServiceHelper.getDynamicObjectKeyFunction(), Function.identity(), (oldValue, newValue) -> newValue));
        List sbbid = declareEntryList.stream().map(d -> d.getLong("sbbid")).collect(Collectors.toList());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,billno,type,declarestatus,paystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", sbbid)});
        Map<Long, DynamicObject> nsrxxMap = collection.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        List<Map<String, Object>> maps = DeclareItemServiceHelper.combineCollection(declareDate, taxableListDtos, declareEntryMap, nsrxxMap);
        maps.forEach(map -> {
            map.put("taxationsys", RuleFetchConstant.DEFALUT_TAXSYSTEM);
            map.put("taxareagroup", RuleFetchConstant.DEFALUT_TAXAREAGROUP);
        });
        return maps;
    }

    private static List<Map<String, Object>> combineCollection(Date declareDate, List<Map<String, Object>> taxableListDtos, Map<String, DynamicObject> declareEntryMap, Map<Long, DynamicObject> nsrxxMap) {
        taxableListDtos.forEach(map -> {
            map.put("templatetype", "ccxws");
            map.put("sbbcategory", DeclareCateGory.CCXWS.getCategory());
            map.put("declarestatus", TaxableListDto.DECLARESTATUS_WBZ);
            map.put("paystatus", TaxableListDto.PAYSTATUS_WJK);
            map.put("draftstatus", TaxableListDto.DRAFTSTATUS_WXBZ);
            map.put("taxationsys", RuleFetchConstant.DEFALUT_TAXSYSTEM);
            map.put("taxareagroup", RuleFetchConstant.DEFALUT_TAXAREAGROUP);
        });
        Map map2 = taxableListDtos.stream().collect(Collectors.toMap(dto -> String.format("%d_%d_%d_%s_%s", dto.get("org"), dto.get("taxauthority"), dto.get("taxcatetory"), DateUtils.format((Date)((Date)dto.get("skssqq"))), DateUtils.format((Date)((Date)dto.get("skssqz")))), Function.identity(), (oldvaule, newvalue) -> newvalue));
        for (Map.Entry<String, DynamicObject> entry : declareEntryMap.entrySet()) {
            String key = entry.getKey();
            DynamicObject declareEntry = entry.getValue();
            Map taxableListDto = (Map)map2.get(key);
            map2.put(key, DeclareItemServiceHelper.populateDto(taxableListDto, declareDate, nsrxxMap, declareEntry));
        }
        return new ArrayList<Map<String, Object>>(map2.values());
    }

    private static Map<String, Object> populateDto(Map<String, Object> taxableListDto, Date declareDate, Map<Long, DynamicObject> nsrxxMap, DynamicObject declareEntry) {
        if (taxableListDto == null) {
            taxableListDto = new HashMap<String, Object>();
            Long baseTaxId = TcretTaxTypeEnum.getBaseTaxIdByTaxtype(declareEntry.getString("taxtype"));
            taxableListDto.put("taxcatetory", baseTaxId);
            taxableListDto.put("org", declareEntry.getLong("org"));
            taxableListDto.put("taxauthority", declareEntry.getLong("taxauthority"));
            if ("yhsac".equals(declareEntry.getString("taxtype"))) {
                taxableListDto.put("skssqq", declareDate);
                taxableListDto.put("skssqz", declareDate);
            } else {
                taxableListDto.put("skssqq", declareEntry.getDate("skssqq"));
                taxableListDto.put("skssqz", declareEntry.getDate("skssqz"));
            }
            taxableListDto.put("month", declareDate);
        }
        taxableListDto.put("templatetype", "ccxws");
        taxableListDto.put("sbbcategory", DeclareCateGory.CCXWS.getCategory());
        taxableListDto.put("draftstatus", TaxableListDto.DRAFTSTATUS_WXBZ);
        taxableListDto.put("declarestatus", TaxableListDto.DECLARESTATUS_WBZ);
        taxableListDto.put("paystatus", TaxableListDto.PAYSTATUS_WJK);
        DynamicObject nsrxx = nsrxxMap.get(declareEntry.getLong("sbbid"));
        if (nsrxx != null) {
            taxableListDto.put("sbbno", nsrxx.getString("billno"));
            taxableListDto.put("declarestatus", nsrxx.getString("declarestatus"));
            taxableListDto.put("paystatus", nsrxx.getString("paystatus"));
        }
        return taxableListDto;
    }

    private static Function<DynamicObject, String> getDynamicObjectKeyFunction() {
        return d -> {
            Long baseTaxId = TcretTaxTypeEnum.getBaseTaxIdByTaxtype(d.getString("taxtype"));
            return String.format("%d_%d_%d_%s_%s", d.getLong("org"), d.getLong("taxauthority"), baseTaxId, DateUtils.format((Date)d.getDate("skssqq")), DateUtils.format((Date)d.getDate("skssqz")));
        };
    }

    static {
        providerList.add(new YhsServiceProvider());
        providerList.add(new HbsServiceProvider());
        providerList.add(new FcsServiceProvider());
        providerList.add(new CcsServiceProvider());
        providerList.add(new QsServiceProvider());
        providerList.add(new TdzzsServiceProvider());
        providerList.add(new TdzzsYjServiceProvider());
        providerList.add(new TdzzsQsServiceProvider());
        providerList.add(new ZysServiceProvider());
    }
}

