/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.tcret.business.declare.TcretDeclareMainHelper;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class RequestValidator {
    private static final Log LOGGER = LogFactory.getLog(RequestValidator.class);

    public static void validateDeclareRequest(DeclareRequest requestVo) {
        if (EmptyCheckUtils.isEmpty((Object)requestVo.getOrgId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0corgId\u4e3a\u7a7a", (String)"RequestValidator_0", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (EmptyCheckUtils.isEmpty((Object)requestVo.getExecuteTime())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0cexecuteTime\u4e3a\u7a7a", (String)"RequestValidator_1", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        try {
            boolean hasLicense;
            long orgId = Long.parseLong(requestVo.getOrgId());
            boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)Long.parseLong(requestVo.getOrgId()));
            if (zeroDeclare) {
                hasLicense = LicenseCheckServiceHelper.checkOrgIsLogout((Long)orgId, null);
                if (hasLicense) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u6ce8\u9500\uff0c\u65e0\u6cd5\u8fdb\u884c\u7533\u62a5", (String)"RequestValidator_2", (String)"taxc-tcret", (Object[])new Object[0]));
                }
            } else {
                hasLicense = LicenseCheckServiceHelper.check((Object)requestVo.getOrgId(), null, (String)"tcret");
                if (hasLicense) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u8bb8\u53ef\u6821\u9a8c\u4e0d\u901a\u8fc7", (String)"RequestValidator_3", (String)"taxc-tcret", (Object[])new Object[0]));
                }
            }
            RequestValidator.orgEnable(orgId);
            RequestValidator.isTaxPayerAuth(requestVo.getOrgId());
            boolean verifyRegisterTimeSuccess = PbtDeclareUtil.verifyRegistertime(requestVo.getOrgId(), DateUtils.format((Date)requestVo.getExecuteTime()));
            if (!verifyRegisterTimeSuccess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u786e\u8ba4\u7533\u62a5\u7684\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4", (String)"RequestValidator_4", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
        catch (NumberFormatException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u7ec4\u7ec7ID\u5305\u542b\u975e\u6570\u5b57\u5b57\u7b26", (String)"RequestValidator_5", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    private static void orgEnable(Long orgId) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"orgEnable", (Object[])new Object[]{orgId, true});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)map.get("code")), (CharSequence)"true")) {
            throw new KDBizException((String)map.get("failInfo"));
        }
    }

    private static void isTaxPayerAuth(String orgId) {
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgCheckService", (String)"isTaxPayerAuth", (Object[])new Object[]{orgId, TemplateEnum.CCXWS.getDeclarePage(), true});
        if (StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)map.get("code")), (CharSequence)"true")) {
            throw new KDBizException((String)map.get("failInfo"));
        }
    }

    public static boolean checkDeclareItemsExists(boolean combineDeclare, EngineModel engineModel, List<DynamicObject> declareItemList) {
        if (combineDeclare) {
            List<Long> sbbIds = TcretDeclareMainHelper.querySbbIds(engineModel.getOrgId(), (String)engineModel.getValue("taxoffice"), (String)engineModel.getValue("declaremonth"));
            if (EmptyCheckUtils.isNotEmpty(sbbIds)) {
                LOGGER.info("\u5df2\u7ecf\u5b58\u5728\u7533\u62a5\u8bb0\u5f55\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u7533\u62a5\u8868\u3002orgId\uff1a%s\uff0c\u7a0e\u52a1\u673a\u5173\uff1a%s\uff0c\u7533\u62a5\u65e5\u671f\uff1a%s", new Object[]{engineModel.getOrgId(), engineModel.getValue("taxoffice"), engineModel.getValue("declaremonth")});
                throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u7533\u62a5\u8bb0\u5f55\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"RequestValidator_6", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            return false;
        }
        String declareMonth = (String)engineModel.getValue("declaremonth");
        String taxoffice = (String)engineModel.getValue("taxoffice");
        DynamicObjectCollection collection = PbtDeclareUtil.queryAllRecord(OperationStatus.VIEW, engineModel.getOrgId(), declareMonth, taxoffice);
        return collection.stream().anyMatch(d -> {
            for (DynamicObject dynamicObject : declareItemList) {
                if (!dynamicObject.getString("taxtype").equals(d.getString("taxtype"))) continue;
                return true;
            }
            return false;
        });
    }
}

