/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declareitem.service.impl;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declareitem.service.DeclareItemListService;

public class TdzzsDeclareItemListServiceImpl
implements DeclareItemListService {
    private static final List<Integer> SEASON_MONTH = Lists.newArrayList((Object[])new Integer[]{1, 4, 7, 10});

    @Override
    public DynamicObjectCollection queryList(Map<String, Object> customParams) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
        Date declaremonth = DateUtils.stringToDate((String)((String)customParams.get("declaremonth")));
        Long orgid = Long.parseLong((String)customParams.get("orgid"));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        String taxoffice = (String)customParams.get("taxoffice");
        QFilter swjgFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)taxoffice)) {
            swjgFilter = new QFilter("taxsourceid.taxauthority", "=", (Object)Long.valueOf(taxoffice));
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)0L);
        if (customParams.get("sbbid") != null) {
            long sbbid = Long.parseLong(String.valueOf(customParams.get("sbbid")));
            sbbIdFilter = sbbIdFilter.or(new QFilter("sbbid", "=", (Object)sbbid));
        }
        QFilter typeFilter = new QFilter("type", "=", (Object)"latwp");
        int month = DateUtils.getMonthOfDate((Date)declaremonth);
        Date date = DateUtils.addMonth((Date)declaremonth, (int)-1);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)date);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)date);
        QFilter monthDateFilter = new QFilter("skssqq", "=", (Object)firstDateOfMonth).and("skssqz", "<=", (Object)lastDateOfMonth);
        boolean monthExists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgFilter, swjgFilter, statusFilter, monthDateFilter, sbbIdFilter, typeFilter});
        if (monthExists) {
            DynamicObject aqobject = new DynamicObject((DynamicObjectType)entityType);
            aqobject.set("taxtype", (Object)"tdzzs");
            aqobject.set("skssqq", (Object)firstDateOfMonth);
            aqobject.set("skssqz", (Object)lastDateOfMonth);
            aqobject.set("taxlimit", (Object)"month");
            collection.add((Object)aqobject);
        }
        if (SEASON_MONTH.contains(month)) {
            Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)date);
            QFilter taxlimitFilter = new QFilter("taxlimit", "=", (Object)"season");
            monthDateFilter = new QFilter("skssqq", "=", (Object)firstDateOfSeason);
            boolean seasonExists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgFilter, swjgFilter, statusFilter, monthDateFilter, sbbIdFilter, taxlimitFilter});
            if (seasonExists) {
                DynamicObject aqobject = new DynamicObject((DynamicObjectType)entityType);
                aqobject.set("taxtype", (Object)"tdzzs");
                aqobject.set("skssqq", (Object)firstDateOfSeason);
                aqobject.set("skssqz", (Object)lastDateOfMonth);
                aqobject.set("taxlimit", (Object)"season");
                collection.add((Object)aqobject);
            }
        }
        return collection;
    }
}

