/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declareitem.service.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declareitem.service.DeclareItemListService;

public class ZysDeclareItemListServiceImpl
implements DeclareItemListService {
    @Override
    public DynamicObjectCollection queryList(Map<String, Object> customParams) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        Long orgid = customParams.get("orgid") != null ? Long.parseLong(String.valueOf(customParams.get("orgid"))) : 0L;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        Long taxofficeId = customParams.get("taxoffice") != null ? Long.parseLong(String.valueOf(customParams.get("taxoffice"))) : 0L;
        QFilter taxofficeFilter = new QFilter("taxoffice", "=", (Object)taxofficeId);
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)0L);
        if (customParams.get("sbbid") != null) {
            long sbbid = Long.parseLong(String.valueOf(customParams.get("sbbid")));
            sbbIdFilter = sbbIdFilter.or(new QFilter("sbbid", "=", (Object)sbbid));
        }
        QFilter isxgmFilter = new QFilter("isxgm", "=", (Object)"0");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(orgFilter);
        list.add(taxofficeFilter);
        list.add(sbbIdFilter);
        list.add(isxgmFilter);
        Date declaremonth = DateUtils.stringToDate2((String)((String)customParams.get("declaremonth")));
        DynamicObjectCollection taxsourceCollection = QueryServiceHelper.query((String)"tcret_zys_collect", (String)"id,skssqq,skssqz,taxsource.taxperiod", (QFilter[])list.toArray(new QFilter[0]));
        Map<String, List<DynamicObject>> groupByMap = taxsourceCollection.stream().collect(Collectors.groupingBy(o -> o.getString("taxsource.taxperiod")));
        for (Map.Entry<String, List<DynamicObject>> map : groupByMap.entrySet()) {
            String taxperiod = map.getKey();
            List<DynamicObject> zysCollection = map.getValue();
            switch (taxperiod) {
                case "season": {
                    this.buildZysAjDeclareItem(collection, zysCollection, declaremonth, taxperiod);
                    break;
                }
                case "month": {
                    this.buildZysAyDeclareItem(collection, zysCollection, declaremonth, taxperiod);
                    break;
                }
                case "count": {
                    this.buildZysAcDeclareItem(collection, zysCollection, declaremonth, taxperiod);
                    break;
                }
            }
        }
        return collection;
    }

    private void buildZysAjDeclareItem(DynamicObjectCollection collection, List<DynamicObject> zysCollection, Date declaremonth, String taxLimit) {
        Map skssqzMap = DateUtils.getSkssqzMap((Date)declaremonth, (String)taxLimit);
        if (skssqzMap != null) {
            Date skssqq = (Date)skssqzMap.get("skssqq");
            Date skssqz = (Date)skssqzMap.get("skssqz");
            Optional<DynamicObject> result = zysCollection.stream().filter(a -> skssqq.equals(a.getDate("skssqq")) && skssqz.equals(a.getDate("skssqz"))).findFirst();
            if (result.isPresent()) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
                DynamicObject yearObjects = new DynamicObject((DynamicObjectType)entityType);
                yearObjects.set("taxtype", (Object)"zysaj");
                yearObjects.set("skssqq", (Object)skssqq);
                yearObjects.set("skssqz", (Object)DateUtils.trunc((Date)skssqz));
                yearObjects.set("taxlimit", (Object)taxLimit);
                collection.add((Object)yearObjects);
            }
        }
    }

    private void buildZysAyDeclareItem(DynamicObjectCollection collection, List<DynamicObject> zysCollection, Date declaremonth, String taxLimit) {
        Map skssqzMap = DateUtils.getSkssqzMap((Date)declaremonth, (String)taxLimit);
        if (skssqzMap != null) {
            Date skssqq = (Date)skssqzMap.get("skssqq");
            Date skssqz = (Date)skssqzMap.get("skssqz");
            Optional<DynamicObject> result = zysCollection.stream().filter(a -> skssqq.equals(a.getDate("skssqq")) && skssqz.equals(a.getDate("skssqz"))).findFirst();
            if (result.isPresent()) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
                DynamicObject yearObjects = new DynamicObject((DynamicObjectType)entityType);
                yearObjects.set("taxtype", (Object)"zysay");
                yearObjects.set("skssqq", (Object)skssqq);
                yearObjects.set("skssqz", (Object)DateUtils.trunc((Date)skssqz));
                yearObjects.set("taxlimit", (Object)taxLimit);
                collection.add((Object)yearObjects);
            }
        }
    }

    private void buildZysAcDeclareItem(DynamicObjectCollection collection, List<DynamicObject> zysCollection, Date declaremonth, String taxLimit) {
        List result = zysCollection.stream().filter(a -> a.getDate("skssqz") != null && a.getDate("skssqz").compareTo(declaremonth) <= 0).collect(Collectors.toList());
        if (result.size() > 0) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
            DynamicObject acObjects = new DynamicObject((DynamicObjectType)entityType);
            DynamicObjectCollection collect = result.stream().sorted(Comparator.comparing(o -> o.getDate("skssqq"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            DynamicObjectCollection reversedCollect = result.stream().sorted(Comparator.comparing(o -> o.getDate("skssqz")).reversed()).collect(Collectors.toCollection(DynamicObjectCollection::new));
            acObjects.set("taxtype", (Object)"zysac");
            acObjects.set("skssqq", ((DynamicObject)collect.get(0)).get("skssqq"));
            acObjects.set("skssqz", ((DynamicObject)reversedCollect.get(0)).get("skssqz"));
            acObjects.set("taxlimit", (Object)taxLimit);
            collection.add((Object)acObjects);
        }
    }
}

