/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declaretaxable.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declareitem.service.impl.QsDeclareItemListServiceImpl;
import kd.taxc.tcret.business.declare.declaretaxable.service.DeclareTaxableListService;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class CcsDeclareTaxableListServiceImpl
implements DeclareTaxableListService {
    @Override
    public List<Map<String, Object>> queryDeclareTaxableList(Map<Long, Boolean> licenseMap, Date declareDate) {
        List<Long> orgList = PbtDeclareUtil.getLicenseCheckSuccessOrgList(licenseMap);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter sfdkdjFilter = new QFilter("withheld", "=", (Object)"0");
        QFilter orgFilter = new QFilter("org", "in", orgList);
        int month = DateUtils.getMonthOfDate((Date)declareDate);
        QFilter sbqxQfilter = new QFilter("sbqx", "=", (Object)String.valueOf(month));
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)declareDate);
        QFilter zcrqFilter = new QFilter("vehicleregdate", "<=", (Object)lastDateOfYear);
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)declareDate);
        QFilter zzrqFilter = new QFilter("closedate", "is null", null).or(new QFilter("closedate", ">=", (Object)firstDateOfYear));
        DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)QsDeclareItemListServiceImpl.class.getName(), (String)"tdm_car_tax_fund_info", (String)"org,taxauthority", (QFilter[])new QFilter[]{enableFilter, sfdkdjFilter, orgFilter, sbqxQfilter, zcrqFilter, zzrqFilter}, null);
        QFilter orgfieldFilter = new QFilter("orgfield", "in", orgList);
        QFilter qdsyqFilter = new QFilter("ownershipdate", "<=", (Object)lastDateOfYear);
        QFilter sbyfQfilter = new QFilter("sbyf", "=", (Object)String.valueOf(month));
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)QsDeclareItemListServiceImpl.class.getName(), (String)"tdm_ship_tax_fund_info", (String)"orgfield as org,taxauthority", (QFilter[])new QFilter[]{enableFilter, sfdkdjFilter, orgfieldFilter, sbyfQfilter, qdsyqFilter, zzrqFilter}, null);
        DataSet dataSet = dataSet1.union(dataSet2).distinct();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Row row : dataSet) {
            TaxableListDto taxableListDto = new TaxableListDto();
            taxableListDto.setTaxcatetory(TaxableListEnum.CCS.getBaseTaxId());
            taxableListDto.setOrg(row.getLong("org"));
            taxableListDto.setTaxauthority(row.getLong("taxauthority"));
            taxableListDto.setSkssqq(firstDateOfYear);
            taxableListDto.setSkssqz(lastDateOfYear);
            taxableListDto.setMonth(declareDate);
            result.add(taxableListDto.transformToMap());
        }
        return result;
    }
}

