/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declaretaxable.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.declaretaxable.service.DeclareTaxableListService;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class HbsDeclareTaxableListServiceImpl
implements DeclareTaxableListService {
    @Override
    public List<Map<String, Object>> queryDeclareTaxableList(Map<Long, Boolean> licenseMap, Date declareDate) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int month = DateUtils.getMonthOfDate((Date)declareDate);
        if (month != 1 && month != 4 && month != 7 && month != 10) {
            return result;
        }
        List<Long> orgList = PbtDeclareUtil.getLicenseCheckSuccessOrgList(licenseMap);
        QFilter q1 = new QFilter("org", "in", orgList);
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        Date lastSeasonDate = DateUtils.addMonth((Date)declareDate, (int)-3);
        Date skssqq = DateUtils.getFirstDateOfSeason((Date)lastSeasonDate);
        Date skssqzWithSecond = DateUtils.getLastDateOfSeason((Date)lastSeasonDate);
        Date skssqz = DateUtils.trunc((Date)skssqzWithSecond);
        QFilter q4 = new QFilter("startdate", "<=", (Object)skssqzWithSecond).and("enddate", ">=", (Object)skssqq);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)HbsDeclareTaxableListServiceImpl.class.getName(), (String)"tcret_pollution_basedata", (String)"org,pfksszgswjg as taxauthority", (QFilter[])new QFilter[]{q1, q2, q4}, null).distinct();
        for (Row row : dataSet) {
            TaxableListDto taxableListDto = new TaxableListDto();
            taxableListDto.setTaxcatetory(TaxableListEnum.HBS.getBaseTaxId());
            taxableListDto.setOrg(row.getLong("org"));
            taxableListDto.setTaxauthority(row.getLong("taxauthority"));
            taxableListDto.setSkssqq(skssqq);
            taxableListDto.setSkssqz(skssqz);
            taxableListDto.setMonth(declareDate);
            result.add(taxableListDto.transformToMap());
        }
        return result;
    }
}

