/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.declaretaxable.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tcret.business.declare.declaretaxable.service.DeclareTaxableListService;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;
import kd.taxc.tcret.common.enums.TcretTaxSource;
import kd.taxc.tcret.common.enums.YhsPrepayTypeEnum;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsDeclareTaxableListServiceImpl
implements DeclareTaxableListService {
    private static final String TCRET_YHS_TAX_SOURCE_INFO = TcretTaxSource.YHSAQ.getEntryEntity();

    @Override
    public List<Map<String, Object>> queryDeclareTaxableList(Map<Long, Boolean> licenseMap, Date declareDate) {
        List enableOrgList = TaxBaseDataUtils.filterEnableOrgsByTaxType(new ArrayList<Long>(licenseMap.keySet()), (String)"yhs");
        HashMap<Long, Long> taxauthorityMap = new HashMap<Long, Long>();
        TaxResult mainByOrgIds = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds((List)enableOrgList);
        if (mainByOrgIds.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)mainByOrgIds.getData())) {
            List mainByOrgIdsData = (List)mainByOrgIds.getData();
            for (DynamicObject taxmain : mainByOrgIdsData) {
                taxauthorityMap.put(taxmain.getLong("taxorg.id"), taxmain.getLong("taxoffice.id"));
            }
        }
        Map zeroDeclareMap = SystemParamUtil.getAppParameterBatch((String)"tcret", (String)"zerodeclare", (List)enableOrgList);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        this.buildYhsACDeclareItem(result, declareDate, taxauthorityMap, enableOrgList, licenseMap, zeroDeclareMap);
        for (String taxLimit : TaxConstant.TAX_LIMITS) {
            this.buildYhsAQDeclareItem(result, declareDate, taxauthorityMap, enableOrgList, taxLimit, licenseMap, zeroDeclareMap);
        }
        return result;
    }

    private void buildYhsACDeclareItem(List<Map<String, Object>> result, Date declareDate, Map<Long, Long> taxauthorityMap, List<Long> enableOrgList, Map<Long, Boolean> licenseMap, Map<Long, Object> zeroDeclareMap) {
        QFilter q1 = new QFilter("declaretype", "=", (Object)"acsb");
        QFilter q2 = new QFilter("sbbid", "=", (Object)0L);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)declareDate));
        QFilter q4 = new QFilter("isxgm", "=", (Object)"0");
        QFilter enableOrgFilter = new QFilter("org", "in", enableOrgList);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)YhsDeclareTaxableListServiceImpl.class.getName(), (String)TCRET_YHS_TAX_SOURCE_INFO, (String)"org,taxoffice", (QFilter[])new QFilter[]{enableOrgFilter, q1, q2, q3, q4}, null).distinct();
        for (Row row : dataSet) {
            Long orgId = row.getLong("org");
            if (!Boolean.FALSE.equals(licenseMap.get(orgId)) || Boolean.TRUE.equals(zeroDeclareMap.get(orgId))) continue;
            TaxableListDto taxableListDto = new TaxableListDto();
            taxableListDto.setTaxcatetory(TaxableListEnum.YHS.getBaseTaxId());
            taxableListDto.setOrg(row.getLong("org"));
            taxableListDto.setTaxauthority(row.getLong("taxoffice"));
            taxableListDto.setSkssqq(declareDate);
            taxableListDto.setSkssqz(declareDate);
            taxableListDto.setMonth(declareDate);
            result.add(taxableListDto.transformToMap());
        }
    }

    private void buildYhsAQDeclareItem(List<Map<String, Object>> result, Date declareDate, Map<Long, Long> taxauthorityMap, List<Long> enableOrgList, String taxLimit, Map<Long, Boolean> licenseMap, Map<Long, Object> zeroDeclareMap) {
        Map skssqzMap = DateUtils.getSkssqzMap((Date)declareDate, (String)taxLimit);
        Map<Long, Map<String, Boolean>> orgprepaymap = YhsAccountServiceHelper.createOrgPrepayMap(enableOrgList);
        DynamicObjectCollection taxitemMappingCollection = QueryServiceHelper.query((String)"tcret_taxitem_mapping", (String)"entryentity.precollectitem,entryentity.taxitem.number,entryentity.subitem,orgentryentity.orgid", (QFilter[])new QFilter[]{new QFilter("orgentryentity.orgid", "in", enableOrgList), new QFilter("enable", "=", (Object)"1")});
        if (skssqzMap != null) {
            Date skssqq = (Date)skssqzMap.get("skssqq");
            Date skssqz = (Date)skssqzMap.get("skssqz");
            TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(enableOrgList);
            if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                for (DynamicObject taxMain : (List)taxResult.getData()) {
                    List yhsEntitys = taxMain.getDynamicObjectCollection("yhsentity").stream().filter(d -> YhsUtils.isValidate(d, skssqq, skssqz, "aqsb", taxLimit)).collect(Collectors.toList());
                    Long orgId = taxMain.getLong("taxorg.id");
                    for (DynamicObject yhsEntity : yhsEntitys) {
                        String tnumber = yhsEntity.getString("taxrate.number");
                        Set<Long> taxoffices = YhsDeclareTaxableListServiceImpl.queryPrepay(orgId, skssqq, skssqz, taxauthorityMap, orgprepaymap, taxitemMappingCollection, tnumber);
                        for (Long taxoffice : taxoffices) {
                            if (taxoffice == null || taxoffice == 0L || !Boolean.FALSE.equals(licenseMap.get(orgId)) && !Boolean.TRUE.equals(zeroDeclareMap.get(orgId))) continue;
                            TaxableListDto taxableListDto = new TaxableListDto();
                            taxableListDto.setTaxcatetory(TaxableListEnum.YHS.getBaseTaxId());
                            taxableListDto.setOrg(orgId);
                            taxableListDto.setTaxauthority(taxoffice);
                            taxableListDto.setSkssqq(skssqq);
                            taxableListDto.setSkssqz(skssqz);
                            taxableListDto.setMonth(declareDate);
                            result.add(taxableListDto.transformToMap());
                        }
                    }
                }
            }
        }
    }

    private static Set<Long> queryPrepay(Long orgid, Date skssqq, Date skssqz, Map<Long, Long> taxauthorityMap, Map<Long, Map<String, Boolean>> orgprepaymap, DynamicObjectCollection taxitemMappingCollection, String tnumber) {
        Optional<DynamicObject> generalOption;
        HashSet<Long> taxoffice = new HashSet<Long>();
        taxoffice.add(taxauthorityMap.get(orgid));
        if (!SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"prepay", (long)orgid)) {
            return taxoffice;
        }
        if (orgprepaymap.get(orgid).containsKey(tnumber) && orgprepaymap.get(orgid).get(tnumber).booleanValue() && (generalOption = taxitemMappingCollection.stream().filter(a -> a.getLong("orgentryentity.orgid") == orgid.longValue() && a.get("entryentity.taxitem.number").equals(tnumber)).findFirst()).isPresent()) {
            String precollectitem = generalOption.get().getString("entryentity.precollectitem");
            List<String> prepaytype = YhsPrepayTypeEnum.getTypeByItem(precollectitem);
            YhsDeclareTaxableListServiceImpl.queryPrepayTaxoffice(orgid, skssqq, skssqz, prepaytype, taxoffice);
        }
        return taxoffice;
    }

    private static void queryPrepayTaxoffice(Long orgid, Date skssqq, Date skssqz, List<String> prepaytype, Set<Long> taxoffice) {
        List declareserialnoList;
        QFilter accountFilter;
        DynamicObjectCollection prepayAccount;
        List monthBetween = DateUtils.getMonthBetween((Date)skssqq, (Date)skssqz, (String)"yyyy-MM-dd");
        List<Date> monthList = monthBetween.stream().map(m -> DateUtils.stringToDate((String)m)).collect(Collectors.toList());
        QFilter filter = new QFilter("org", "=", (Object)orgid).and(new QFilter("billstatus", "=", (Object)"C"));
        QFilter timefilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
        monthList.forEach(s -> timefilter.or(new QFilter("skssqq", "=", s).and(new QFilter("skssqz", "=", (Object)DateUtils.getLastDateOfMonth2((Date)s)))));
        DynamicObjectCollection prepayDeclareQuery = QueryServiceHelper.query((String)"tcvat_prepay_declare_bill", (String)"sbbid,declareserialno", (QFilter[])new QFilter[]{filter, timefilter});
        if (prepayDeclareQuery != null && prepayDeclareQuery.size() > 0 && (prepayAccount = QueryServiceHelper.query((String)"tcvat_project_account", (String)"orgid,taxoffice,prepaytype,declareserialno", (QFilter[])new QFilter[]{accountFilter = new QFilter("orgid", "=", (Object)orgid).and(new QFilter("declareserialno", "in", declareserialnoList = prepayDeclareQuery.stream().map(p -> p.getString("declareserialno")).collect(Collectors.toList()))).and(new QFilter("prepaytype", "in", prepaytype)).and(new QFilter("entryentity.taxtype", "=", (Object)ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"YhsDeclareTaxableListServiceImpl_0", (String)"taxc-tcret", (Object[])new Object[0])))})) != null && prepayAccount.size() > 0) {
            Set prepaytaxoffice = prepayAccount.stream().filter(d -> d.getLong("taxoffice") > 0L).map(s -> s.getLong("taxoffice")).collect(Collectors.toSet());
            taxoffice.addAll(prepaytaxoffice);
        }
    }
}

