/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.utils.CalUtils;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractEngine {
    private static final String SZSSWJ = "SZSSWJ";
    private static Log logger = LogFactory.getLog(AbstractEngine.class);
    private static final String TPO_TAX_ITEM_RATE_ENTITY = "tpo_tcret_taxrate";
    protected static final String TDM_HOUSE_RENTAL_EDIT = "tdm_house_rental_edit";
    protected static final String ORG = "org";
    protected static final String TAX_PAY_LIMIT = "taxpaylimit";
    protected static final String TDS_TAX_LIMIT = "taxtimelimit";
    protected static final String MONTH = "month";
    protected static final String SEASON = "season";
    protected static final String YEAR = "year";
    protected static final String HALF_YEAR = "halfyear";
    private static final String ENABLE = "enable";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String DEFAULT_TAX_LIMIT = "false";
    private static final String ENTRY_ENTITY = "entryentity";
    protected static final String TAX_RATIO = "taxratio";
    private static final String CURRENT_PAYABLE = "currentpayable";
    protected static final String CURRENT_JMAMOUNT = "currentjmamount";
    protected static final String FCS_BY_HIRE_LIMIT = "fcsbyhirelimit";
    protected static final String TAX_BASIS = "taxbasis";
    private static final String SOURCE_ID = "sourceid";
    protected static final String TAX_LIMIT = "taxlimit";
    protected static final String TAX_RATE = "taxrate";
    protected static final String RENTAL_VALUE = "rentalvalue";
    protected static final String ASSERT_VALUE = "assertvalue";
    protected static final String CHANGE_DATE = "changedate";
    protected static final String CHANGE_TYPE = "changetype";
    protected static final String LAND_LEVEL = "landlevel";
    protected static final String CURRENTAL = "currental";
    protected static final String LAND_AREA = "occupylandarea";
    protected static final String TAX_STANDARD = "taxstandard";
    protected static final String FCS_BASIC_INFO = "fcsbasicinfo";
    protected static final String NUMBER = "number";
    protected static final String HIRE_ASSERT_VALUE = "hireassertvalue";
    protected static final String LAND_AREA_INFO = "landarea";
    private static final String ENTITY_TAX_RATE = "entryentity.mergecode,entryentity.taxrate,startdate,enddate";
    private static final String MERGE_CODE = "mergecode";
    private static final String PERCENT = "%";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String FCS_PRICE_MERGE_CODE = "01";
    private static final String FCS_HIRE_MERGE_CODE = "02";
    private static final String FCS_CODE = "007";
    protected static final String REGIST_ALL = "1";
    protected static final String REGIST_RATIO = "2";
    protected static final String DEDUCTIONTYPE_MS = "1";
    protected static final String DEDUCTIONTYPE_JZ = "2";
    protected static final String DEDUCTIONTYPE_OTHER = "6";
    private static final BigDecimal MAX_EPSILON = new BigDecimal("0.001");
    private static final BigDecimal MIN_EPSILON = new BigDecimal("-0.001");
    protected static final int HALF_YEAR_VALUE = 6;
    private static final BigDecimal RATE = BigDecimal.valueOf(0.5);

    protected abstract BigDecimal getCurrentPayable(BigDecimal var1, Date var2, Date var3, DynamicObject var4, DynamicObject var5, DynamicObject var6, String var7);

    protected abstract void setOtherValue(DynamicObject var1, DynamicObject var2, DynamicObject var3, Long var4, String var5);

    public DynamicObject[] queryData(EngineModel model, FcsTypeEnum fcsTypeEnum) {
        String entityName;
        DynamicObjectCollection ids;
        Long orgId = Long.valueOf(model.getOrgId());
        String taxoffice = (String)model.getCustom().get("taxoffice");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter(ORG, "=", (Object)orgId));
        qFilters.add(new QFilter(ENABLE, "=", (Object)"1"));
        qFilters.add(new QFilter(fcsTypeEnum.getTaxtimelimitKey(), "!=", (Object)DEFAULT_TAX_LIMIT));
        qFilters.add(new QFilter("taxauthority", "=", (Object)Long.parseLong(taxoffice)));
        Object accountorg = model.getCustom().get("accountorg");
        if (accountorg != null) {
            Long accountOrgId = (Long)accountorg;
            qFilters.add(new QFilter(fcsTypeEnum.getAccountOrg(), "=", (Object)accountOrgId));
        }
        if (FcsTypeEnum.FCS_BY_HIRE == fcsTypeEnum) {
            qFilters.add(new QFilter("fcsapanage.number", "!=", (Object)SZSSWJ));
        }
        if (CollectionUtils.isNotEmpty((Collection)(ids = QueryServiceHelper.query((String)(entityName = fcsTypeEnum.getSourceEntity()), (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))))) {
            return BusinessDataServiceHelper.load((Object[])ids.stream().map(e -> e.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        }
        return new DynamicObject[0];
    }

    public List<DynamicObject> initialObj(DynamicObject taxorg, DynamicObject sourceObject, FcsTypeEnum fcsTypeEnum, EngineModel model) {
        Date date = (Date)model.getCustom().get("declaremonth");
        BigDecimal taxRate = this.getTaxRate(fcsTypeEnum, date);
        String taxLimit = sourceObject.getString(fcsTypeEnum.getTaxtimelimitKey());
        if (taxLimit == null) {
            logger.warn("taxLimit is null.do not set skssq.");
            return null;
        }
        Map<String, Date> dateMap = PbtDeclareUtil.getDateMap(date, taxLimit, sourceObject.getString("taxtimepoint"), sourceObject.getInt("endmonth"));
        Date skssqq = dateMap.get(SKSSQQ);
        Date skssqz = dateMap.get(SKSSQZ);
        if (skssqq == null || skssqz == null) {
            return null;
        }
        if (!DateUtils.format((Date)skssqq).equals(model.getStartDate()) || !DateUtils.format((Date)skssqz).equals(model.getEndDate())) {
            return null;
        }
        List<Object> splitObjects = new ArrayList();
        if (fcsTypeEnum == FcsTypeEnum.FCS_BY_PRICE || fcsTypeEnum == FcsTypeEnum.TDS) {
            Date date2;
            Date acquiredate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)sourceObject.getDate(fcsTypeEnum.getAcquiredateKey()), (int)1));
            if (acquiredate.compareTo(skssqq) > 0) {
                skssqq = acquiredate;
            }
            if ((date2 = sourceObject.getDate(fcsTypeEnum.getChangedateKey())) != null && DateUtils.getLastDateOfMonth((Date)date2).compareTo(skssqz) < 0) {
                skssqz = DateUtils.getLastDateOfMonth((Date)date2);
            }
            if (skssqq.compareTo(skssqz) >= 0) {
                return null;
            }
            Boolean changeEffectCurrentMonth = (Boolean)model.getCustom().get("changeeffectcurrentmonth");
            splitObjects = this.splitByBgEntryEntity(taxRate, skssqq, skssqz, fcsTypeEnum, sourceObject, changeEffectCurrentMonth);
        } else {
            String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)fcsTypeEnum.getEntityName());
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dynamicObject.set(SKSSQQ, (Object)skssqq);
            dynamicObject.set(SKSSQZ, (Object)skssqz);
            BigDecimal currentPable = this.getCurrentPayable(taxRate, skssqq, skssqz, sourceObject, dynamicObject, null, fcsTypeEnum.getType());
            if (currentPable.compareTo(MAX_EPSILON) <= 0 && currentPable.compareTo(MIN_EPSILON) >= 0) {
                logger.info("\u672c\u671f\u5e94\u7eb3\u7a0e\u989d\u4e3a,currentPable:" + currentPable);
                return null;
            }
            dynamicObject.set(CURRENT_PAYABLE, (Object)currentPable);
            splitObjects.add(dynamicObject);
        }
        if (CollectionUtils.isEmpty(splitObjects)) {
            return null;
        }
        for (DynamicObject dynamicObject : splitObjects) {
            if (fcsTypeEnum == FcsTypeEnum.FCS_BY_PRICE || fcsTypeEnum == FcsTypeEnum.FCS_BY_HIRE) {
                dynamicObject.set(TAX_RATE, (Object)taxRate);
            }
            Long orgId = Long.parseLong(model.getOrgId());
            this.setOtherValue(taxorg, sourceObject, dynamicObject, orgId, fcsTypeEnum.getType());
            dynamicObject.set(SOURCE_ID, (Object)sourceObject);
            dynamicObject.set(ORG, (Object)orgId);
            dynamicObject.set("sbbid", model.getCustom().get("sbbid"));
        }
        return splitObjects;
    }

    public void addXgm(EngineModel model, List<DynamicObject> dynamicObjects, FcsTypeEnum type, Map<String, Long> taxitemMap) {
        Map<String, List<DynamicObject>> collect = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getString(NUMBER) + DateUtils.format((Date)e.getDate(SKSSQQ)) + DateUtils.format((Date)e.getDate(SKSSQZ))));
        Long orgId = Long.parseLong(model.getOrgId());
        Long sbbid = Long.valueOf(String.valueOf(model.getCustom().get("sbbid")));
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)type.getEntityName());
        ArrayList xgmList = new ArrayList();
        collect.forEach((k, v) -> {
            DynamicObject object1 = (DynamicObject)v.get(0);
            String reliefPolicyType = (String)model.getCustom().get("reliefPolicy");
            if (StringUtil.isNotBlank((CharSequence)reliefPolicyType)) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                object.set(ORG, (Object)orgId);
                object.set(NUMBER, (Object)object1.getString(NUMBER));
                Date skssqq = object1.getDate(SKSSQQ);
                Date skssqz = object1.getDate(SKSSQZ);
                object.set(SKSSQQ, (Object)skssqq);
                object.set(SKSSQZ, (Object)skssqz);
                object.set(SOURCE_ID, object1.get(SOURCE_ID));
                if (type == FcsTypeEnum.FCS_BY_HIRE || type == FcsTypeEnum.FCS_BY_PRICE) {
                    object.set(TAX_RATE, object1.get(TAX_RATE));
                } else {
                    object.set(TAX_STANDARD, object1.get(TAX_STANDARD));
                    object.set(LAND_LEVEL, object1.get(LAND_LEVEL));
                }
                String taxlimit = object1.getString(TAX_LIMIT);
                this.setSjssq(object, skssqq, skssqz, taxlimit);
                BigDecimal currentpayable = CalUtils.calcAmount(v, CURRENT_PAYABLE);
                BigDecimal currentjmamount = CalUtils.calcAmount(v, CURRENT_JMAMOUNT);
                BigDecimal jmhse = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)currentpayable, (Object)currentjmamount), (Object)RATE, (int)2, (int)4);
                DynamicObject changeRecord = OrgChangeRecordUtil.loadChangeRecord((String)object1.getString(ORG), (Date)skssqq, (Date)skssqz);
                if (changeRecord != null) {
                    jmhse = PbtDeclareUtil.ajustJmse(reliefPolicyType, changeRecord, skssqq, skssqz, jmhse);
                }
                object.set(CURRENT_PAYABLE, (Object)currentpayable);
                object.set(CURRENT_JMAMOUNT, (Object)jmhse);
                DynamicObjectCollection entryentity = object.getDynamicObjectCollection(ENTRY_ENTITY);
                DynamicObject entry = entryentity.addNew();
                entry.set("jmcode", (Object)taxitemMap.getOrDefault(model.getCustom().get("reliefPolicy"), 0L));
                entry.set("jmamount", (Object)jmhse);
                object.set("sbbid", (Object)sbbid);
                object.set("isxgm", (Object)"1");
                xgmList.add(object);
            }
        });
        dynamicObjects.addAll(xgmList);
    }

    private List<DynamicObject> splitByBgEntryEntity(BigDecimal taxRate, Date skssqq, Date skssqz, FcsTypeEnum fcsTypeEnum, DynamicObject sourceObject, Boolean changeEffectCurrentMonth) {
        DynamicObjectCollection bgentryentity = sourceObject.getDynamicObjectCollection("bgentryentity");
        bgentryentity.sort(Comparator.comparing(d -> d.getDate("bgdate")));
        LinkedHashMap<Date, DynamicObject> map = new LinkedHashMap<Date, DynamicObject>();
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(skssqq);
        for (DynamicObject object : bgentryentity) {
            Date start;
            Date end;
            Date bgdate = object.getDate("bgdate");
            if (changeEffectCurrentMonth.booleanValue()) {
                end = DateUtils.getLastDateOfMonth1((Date)DateUtils.addMonth((Date)bgdate, (int)-1));
                start = DateUtils.getFirstDateOfMonth((Date)bgdate);
            } else {
                end = DateUtils.getLastDateOfMonth1((Date)bgdate);
                start = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)bgdate, (int)1));
            }
            if (end.compareTo(skssqq) > 0 && start.compareTo(skssqz) < 0) {
                dates.add(end);
                dates.add(start);
            }
            map.put(start, object);
        }
        dates.add(skssqz);
        ArrayList<DynamicObject> splitObjects = new ArrayList<DynamicObject>(dates.size() / 2);
        for (int i = 0; i < dates.size(); i += 2) {
            Date startdate = (Date)dates.get(i);
            Date enddate = (Date)dates.get(i + 1);
            String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)fcsTypeEnum.getEntityName());
            DynamicObject targetObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            targetObject.set(SKSSQQ, (Object)startdate);
            targetObject.set(SKSSQZ, (Object)enddate);
            DynamicObject entryEntity = this.getEntryEntity(map, startdate);
            BigDecimal currentPable = this.getCurrentPayable(taxRate, startdate, enddate, sourceObject, targetObject, entryEntity, fcsTypeEnum.getType());
            if (currentPable.compareTo(MAX_EPSILON) <= 0 && currentPable.compareTo(MIN_EPSILON) >= 0) {
                logger.info("\u672c\u671f\u5e94\u7eb3\u7a0e\u989d\u4e3a,currentPable:" + currentPable);
                continue;
            }
            targetObject.set(CURRENT_PAYABLE, (Object)currentPable);
            splitObjects.add(targetObject);
        }
        return splitObjects;
    }

    private DynamicObject getEntryEntity(Map<Date, DynamicObject> map, Date startdate) {
        DynamicObject object = null;
        for (Map.Entry<Date, DynamicObject> entry : map.entrySet()) {
            Date date = entry.getKey();
            if (date.compareTo(startdate) > 0) continue;
            object = entry.getValue();
        }
        return object;
    }

    private BigDecimal getTaxRate(FcsTypeEnum fcsTypeEnum, Date date) {
        String taxRatioMergeCode = FcsTypeEnum.FCS_BY_PRICE == fcsTypeEnum ? FCS_PRICE_MERGE_CODE : FCS_HIRE_MERGE_CODE;
        QFilter q1 = new QFilter(NUMBER, "=", (Object)FCS_CODE);
        QFilter q2 = new QFilter(START_DATE, "<=", (Object)date);
        QFilter q3 = new QFilter(END_DATE, "is null", null).or(new QFilter(END_DATE, ">=", (Object)date));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TPO_TAX_ITEM_RATE_ENTITY, (String)ENTITY_TAX_RATE, (QFilter[])new QFilter[]{q1, q2, q3});
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return BigDecimal.ZERO;
        }
        String ratio = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String[] taxRates;
            DynamicObjectCollection sonItems = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject sonObj : sonItems) {
                if (!taxRatioMergeCode.equals(sonObj.getString(MERGE_CODE))) continue;
                ratio = sonObj.getString(TAX_RATE);
                break;
            }
            if (null == ratio || ratio.trim().length() == 0 || (taxRates = ratio.split(PERCENT)).length < 1) continue;
            return BigDecimalUtil.divideObject((Object)taxRates[0], (Object)100, (int)10);
        }
        return BigDecimal.ZERO;
    }

    public static int getMinusMonths(Date start, Date end, Date skssqq, Date skssqz) {
        if (end != null) {
            Date minDate = end.before(skssqz) ? end : skssqz;
            Date maxDate = start.after(skssqq) ? start : skssqq;
            int monthDiff = AbstractEngine.minusMonth(minDate, maxDate);
            return monthDiff < 0 ? 0 : monthDiff + 1;
        }
        Date minDate = skssqz;
        Date maxDate = start.after(skssqq) ? start : skssqq;
        int monthDiff = AbstractEngine.minusMonth(minDate, maxDate);
        return monthDiff < 0 ? 0 : monthDiff + 1;
    }

    public static Integer minusMonth(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int result = start.get(2) - end.get(2);
        int month = (start.get(1) - end.get(1)) * 12;
        return month + result;
    }

    public void setSjssq(DynamicObject targetObject, Date skssqq, Date skssqz, String taxpayLimit) {
        Date sjssqq = skssqq;
        Date sjssqz = skssqz;
        switch (taxpayLimit) {
            case "month": {
                sjssqq = DateUtils.getFirstDateOfMonth((Date)sjssqq);
                sjssqz = DateUtils.getLastDateOfMonth2((Date)sjssqz);
                break;
            }
            case "season": {
                sjssqq = DateUtils.getFirstDateOfSeason((Date)sjssqq);
                sjssqz = DateUtils.trunc((Date)DateUtils.getLastDateOfSeason((Date)sjssqz));
                break;
            }
            case "halfyear": {
                sjssqq = DateUtils.getFirstDateOfHalfYear((Date)sjssqq);
                sjssqz = DateUtils.trunc((Date)DateUtils.getLastDateOfHalfYear((Date)sjssqz));
                break;
            }
            case "year": {
                sjssqq = DateUtils.getFirstDateOfYear((Date)sjssqq);
                sjssqz = DateUtils.getLastDateOfYear((Date)sjssqz);
            }
        }
        targetObject.set("sjssqq", (Object)sjssqq);
        targetObject.set("sjssqz", (Object)sjssqz);
    }
}

