/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.common.enums.CcsTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class CcsEngineServiceImpl
implements EngineService {
    private static final Map<String, MultiLangEnumBridge> CcTypeMap = new HashMap<String, MultiLangEnumBridge>(){
        {
            this.put("ccscl1", new MultiLangEnumBridge("1.0\u5347\uff08\u542b\uff09\u4ee5\u4e0b\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_0", "taxc-tcret"));
            this.put("ccscl2", new MultiLangEnumBridge("1.0\u5347\u4ee5\u4e0a\u81f31.6\u5347\uff08\u542b\uff09\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_1", "taxc-tcret"));
            this.put("ccscl3", new MultiLangEnumBridge("1.6\u5347\u4ee5\u4e0a\u81f32.0\u5347\uff08\u542b\uff09\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_2", "taxc-tcret"));
            this.put("ccscl4", new MultiLangEnumBridge("2.0\u5347\u4ee5\u4e0a\u81f32.5\u5347\uff08\u542b\uff09\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_3", "taxc-tcret"));
            this.put("ccscl5", new MultiLangEnumBridge("2.5\u5347\u4ee5\u4e0a\u81f33.0\u5347\uff08\u542b\uff09\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_4", "taxc-tcret"));
            this.put("ccscl6", new MultiLangEnumBridge("3.0\u5347\u4ee5\u4e0a\u81f34.0\u5347\uff08\u542b\uff09\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_5", "taxc-tcret"));
            this.put("ccscl7", new MultiLangEnumBridge("4.0\u5347\u4ee5\u4e0a\u7684\u4e58\u7528\u8f66", "CcsEngineServiceImpl_6", "taxc-tcret"));
            this.put("ccscl8", new MultiLangEnumBridge("\u6838\u5b9a\u8f7d\u5ba2\u4eba\u657020\u4eba\u4ee5\u4e0b\u5ba2\u8f66", "CcsEngineServiceImpl_7", "taxc-tcret"));
            this.put("ccscl9", new MultiLangEnumBridge("\u6838\u5b9a\u8f7d\u5ba2\u4eba\u657020\u4eba\uff08\u542b\uff09\u4ee5\u4e0a\u5ba2\u8f66", "CcsEngineServiceImpl_8", "taxc-tcret"));
            this.put("ccscl10", new MultiLangEnumBridge("\u8d27\u8f66", "CcsEngineServiceImpl_9", "taxc-tcret"));
            this.put("ccscl11", new MultiLangEnumBridge("\u6302\u8f66", "CcsEngineServiceImpl_10", "taxc-tcret"));
            this.put("ccscl12", new MultiLangEnumBridge("\u4e13\u7528\u4f5c\u4e1a\u8f66", "CcsEngineServiceImpl_11", "taxc-tcret"));
            this.put("ccscl13", new MultiLangEnumBridge("\u8f6e\u5f0f\u4e13\u7528\u673a\u68b0\u8f66", "CcsEngineServiceImpl_12", "taxc-tcret"));
            this.put("ccscl14", new MultiLangEnumBridge("\u6469\u6258\u8f66", "CcsEngineServiceImpl_13", "taxc-tcret"));
            this.put("ccscb1", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u4e0d\u8d85\u8fc7200\u5428\u7684\u673a\u52a8\u8239\u8236", "CcsEngineServiceImpl_14", "taxc-tcret"));
            this.put("ccscb2", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u8d85\u8fc7200\u5428\u4f46\u4e0d\u8d85\u8fc72000\u5428\u7684\u673a\u52a8\u8239\u8236", "CcsEngineServiceImpl_15", "taxc-tcret"));
            this.put("ccscb3", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u8d85\u8fc72000\u5428\u4f46\u4e0d\u8d85\u8fc710000\u5428\u7684\u673a\u52a8\u8239\u8236", "CcsEngineServiceImpl_16", "taxc-tcret"));
            this.put("ccscb4", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u8d85\u8fc710000\u5428\u7684\u673a\u52a8\u8239\u8236", "CcsEngineServiceImpl_17", "taxc-tcret"));
            this.put("ccscb5", new MultiLangEnumBridge("\u8247\u8eab\u957f\u5ea6\u4e0d\u8d85\u8fc710\u7c73\u7684\u6e38\u8247", "CcsEngineServiceImpl_18", "taxc-tcret"));
            this.put("ccscb6", new MultiLangEnumBridge("\u8247\u8eab\u957f\u5ea6\u8d85\u8fc710\u7c73\u4f46\u4e0d\u8d85\u8fc718\u7c73\u7684\u6e38\u8247", "CcsEngineServiceImpl_19", "taxc-tcret"));
            this.put("ccscb7", new MultiLangEnumBridge("\u8247\u8eab\u957f\u5ea6\u8d85\u8fc718\u7c73\u4f46\u4e0d\u8d85\u8fc730\u7c73\u7684\u6e38\u8247", "CcsEngineServiceImpl_20", "taxc-tcret"));
            this.put("ccscb8", new MultiLangEnumBridge("\u8247\u8eab\u957f\u5ea6\u8d85\u8fc730\u7c73\u7684\u6e38\u8247", "CcsEngineServiceImpl_21", "taxc-tcret"));
            this.put("ccscb9", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u4e0d\u8d85\u8fc7200\u5428\u7684\u62d6\u8239\u3001\u975e\u673a\u52a8\u9a73\u8239", "CcsEngineServiceImpl_22", "taxc-tcret"));
            this.put("ccscb10", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u8d85\u8fc7200\u5428\u4f46\u4e0d\u8d85\u8fc72000\u5428\u7684\u62d6\u8239\u3001\u975e\u673a\u52a8\u9a73\u8239", "CcsEngineServiceImpl_23", "taxc-tcret"));
            this.put("ccscb11", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u8d85\u8fc72000\u5428\u4f46\u4e0d\u8d85\u8fc710000\u5428\u7684\u62d6\u8239\u3001\u975e\u673a\u52a8\u9a73\u8239", "CcsEngineServiceImpl_24", "taxc-tcret"));
            this.put("ccscb12", new MultiLangEnumBridge("\u51c0\u5428\u4f4d\u8d85\u8fc710000\u5428\u7684\u62d6\u8239\u3001\u975e\u673a\u52a8\u9a73\u8239", "CcsEngineServiceImpl_25", "taxc-tcret"));
            this.put("ccscb13", new MultiLangEnumBridge("\u8f85\u52a9\u52a8\u529b\u5e06\u8247", "CcsEngineServiceImpl_26", "taxc-tcret"));
        }
    };

    @Override
    public ApiResult runEngine(EngineModel model) {
        CcsTypeEnum taxtype = CcsTypeEnum.getByTaxType((String)model.getCustom().get("taxtype"));
        DynamicObject[] sourceObjects = this.queryData(model, taxtype);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (DynamicObject sourceObject : sourceObjects) {
            DynamicObject object = this.initialObj(sourceObject, taxtype, model);
            if (null == object) continue;
            dynamicObjects.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return ApiResult.success(dynamicObjects);
    }

    public DynamicObject[] queryData(EngineModel model, CcsTypeEnum type) {
        Long orgId = Long.valueOf(model.getOrgId());
        String taxoffice = (String)model.getCustom().get("taxoffice");
        Date declaremonth = (Date)model.getCustom().get("declaremonth");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("withheld", "=", (Object)"0"));
        qFilters.add(new QFilter(type.getOrg(), "=", (Object)orgId));
        qFilters.add(new QFilter("taxauthority", "=", (Object)Long.valueOf(taxoffice)));
        Object accountorg = model.getCustom().get("accountorg");
        if (accountorg != null) {
            Long accountOrgId = (Long)accountorg;
            qFilters.add(new QFilter("accountorg", "=", (Object)accountOrgId));
        }
        int month = DateUtils.getMonthOfDate((Date)declaremonth);
        qFilters.add(new QFilter(type.getSbqx(), "=", (Object)String.valueOf(month)));
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)declaremonth);
        qFilters.add(new QFilter(type.getStart(), "<=", (Object)lastDateOfYear));
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)declaremonth);
        qFilters.add(new QFilter("closedate", "is null", null).or(new QFilter("closedate", ">=", (Object)firstDateOfYear)));
        String entityName = type.getSourceEntity();
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            return BusinessDataServiceHelper.load((Object[])ids.stream().map(e -> e.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        }
        return new DynamicObject[0];
    }

    public DynamicObject initialObj(DynamicObject sourceObject, CcsTypeEnum ccsTypeEnum, EngineModel model) {
        Long sbbid = Long.valueOf(String.valueOf(model.getCustom().get("sbbid")));
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)ccsTypeEnum.getEntityName());
        DynamicObject targetObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        targetObject.set("taytype", (Object)ccsTypeEnum.getType());
        targetObject.set("ccsbdm", sourceObject.get(ccsTypeEnum.getCcsbdm()));
        targetObject.set("ccpzdm", sourceObject.get(ccsTypeEnum.getCcpzdm()));
        if (ccsTypeEnum == CcsTypeEnum.CCSCL) {
            targetObject.set("taxbasis", ccsTypeEnum.getJsyj().contains(sourceObject.get("itemcollection")) ? sourceObject.get("zbzl") : BigDecimal.ONE);
        } else {
            targetObject.set("taxbasis", ccsTypeEnum.getJsyj().contains(sourceObject.get("itemcollection")) ? sourceObject.get("hulllength") : sourceObject.get("jdw"));
        }
        targetObject.set("cczcrq", sourceObject.get(ccsTypeEnum.getStart()));
        targetObject.set("cclx", (Object)CcTypeMap.get(ccsTypeEnum.getType() + sourceObject.get("itemcollection")).loadKDString());
        targetObject.set("zxrq", sourceObject.get("closedate"));
        targetObject.set("taxrate", sourceObject.get("dwse"));
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        Date closedate = sourceObject.getDate("closedate");
        Date minEndDate = DateUtils.getMinDate((Date[])new Date[]{skssqz, closedate != null ? DateUtils.addMonth((Date)closedate, (int)-1) : null});
        Date maxStartDate = DateUtils.getMaxDate((Date[])new Date[]{skssqq, sourceObject.getDate(ccsTypeEnum.getStart())});
        int monthDiff = DateUtils.subtractDatesForMonth((Date)minEndDate, (Date)maxStartDate);
        BigDecimal ynse = targetObject.getBigDecimal("taxbasis").multiply(sourceObject.getBigDecimal("dwse")).multiply(BigDecimal.valueOf(monthDiff + 1)).divide(BigDecimal.valueOf(12L), 2, 4);
        targetObject.set("ynse", (Object)ynse);
        targetObject.set("skssqq", (Object)skssqq);
        targetObject.set("skssqz", (Object)skssqz);
        targetObject.set("org", sourceObject.get(ccsTypeEnum.getOrg()));
        targetObject.set("sbbid", (Object)sbbid);
        targetObject.set("sourceid", (Object)sourceObject.getLong("id"));
        targetObject.set("accountorg", sourceObject.get("accountorg"));
        this.setJmAmount(sourceObject, targetObject, targetObject.getDate("skssqq"), targetObject.getDate("skssqz"), ynse);
        return targetObject;
    }

    private void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz, BigDecimal ynse) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceEntity = sourceObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : sourceEntity) {
            Date start = object.getDate("start");
            Date end = object.getDate("end");
            if (skssqq.compareTo(start) < 0 || end != null && end.compareTo(skssqz) < 0) continue;
            DynamicObject entry = entryentity.addNew();
            entry.set("taxdeduction", object.get("taxdeduction"));
            entry.set("jmbl", object.get("ratio"));
            entry.set("start", object.get("start"));
            entry.set("end", object.get("end"));
            BigDecimal jmamount = ynse.multiply(object.getBigDecimal("ratio")).setScale(2, 4);
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = totalJmamount.add(jmamount);
        }
        targetObject.set("jmse", (Object)totalJmamount);
    }
}

