/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.business.declare.engine.impl.AbstractEngine;
import kd.taxc.tcret.common.enums.FcsTypeEnum;

public class FcsHireEngineServiceImpl
extends AbstractEngine
implements EngineService {
    public static final FcsTypeEnum TYPE = FcsTypeEnum.FCS_BY_HIRE;
    private static final Map<String, Long> itemMap = new HashMap<String, Long>();
    private static final List<String> JZJMCODE_LIST = Lists.newArrayList((Object[])new String[]{"08011707", "08011708", "08011709", "08011710", "08129917"});

    @Override
    public ApiResult runEngine(EngineModel model) {
        DynamicObject[] sourceObjects = this.queryData(model, TYPE);
        String orgid = model.getOrgId();
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)Long.parseLong(orgid)).getData();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (DynamicObject sourceObject : sourceObjects) {
            List<DynamicObject> object = this.initialObj(taxorg, sourceObject, TYPE, model);
            if (null == object) continue;
            dynamicObjects.addAll(object);
        }
        this.addXgm(model, dynamicObjects, TYPE, itemMap);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return ApiResult.success(dynamicObjects);
    }

    @Override
    protected BigDecimal getCurrentPayable(BigDecimal taxRate, Date startdate, Date enddate, DynamicObject sourceObject, DynamicObject targetObject, DynamicObject entry, String tabKey) {
        BigDecimal rent = this.getCurrentRent(sourceObject, startdate);
        targetObject.set("currental", (Object)rent);
        return BigDecimalUtil.multiplyObject((Object)rent, (Object)taxRate, (int)2, (int)4);
    }

    @Override
    protected void setOtherValue(DynamicObject taxorg, DynamicObject sourceObject, DynamicObject targetObject, Long orgId, String tabKey) {
        Date skssqq = targetObject.getDate("skssqq");
        Date skssqz = targetObject.getDate("skssqz");
        int skssqqzMonthDiff = DateUtils.getMonthDiff((Date)skssqz, (Date)skssqq);
        String fields = "leasecontractno,taxauthority,leaseetaxcode,leaseename,leasearea,contractstart,contractend";
        for (String field : fields.split(",")) {
            targetObject.set(field, sourceObject.get(field));
        }
        DynamicObjectCollection targetRententryentity = targetObject.getDynamicObjectCollection("rententryentity");
        DynamicObjectCollection sourcerententryentity = sourceObject.getDynamicObjectCollection("rententryentity");
        for (int i = 0; i < sourcerententryentity.size(); ++i) {
            Date enddate;
            DynamicObject source = (DynamicObject)sourcerententryentity.get(i);
            Date startdate = source.getDate("startdate");
            List periodList = DateUtils.getMonthBetween((Date)startdate, (Date)(enddate = source.getDate("enddate")));
            long count = periodList.stream().filter(s -> {
                Date date = DateUtils.stringToDate((String)s, (String)"yyyy-MM");
                return !date.before(skssqq) && !date.after(skssqz);
            }).count();
            if (count <= 0L) continue;
            DynamicObject target = targetRententryentity.addNew();
            target.set("hirearea", source.get("hirearea"));
            target.set("rentincome", source.get("rentincome"));
            target.set("startdate", source.get("startdate"));
            target.set("enddate", source.get("enddate"));
            target.set("tenantry", source.get("tenantry"));
            target.set("hiretaxcode", source.get("hiretaxcode"));
        }
        DynamicObject fcsbasicinfo = sourceObject.getDynamicObject("fcsbasicinfo");
        if (fcsbasicinfo != null) {
            targetObject.set("number", fcsbasicinfo.get("number"));
            targetObject.set("name", fcsbasicinfo.get("name"));
            targetObject.set("fcsapanage", fcsbasicinfo.get("basedatafield"));
        }
        targetObject.set("unifiedsocialcode", (Object)TaxOrgUtil.getUnifiedsocialcode((DynamicObject)taxorg));
        String taxpayLimit = sourceObject.getString("fcsbyhirelimit");
        this.setSjssq(targetObject, skssqq, skssqz, taxpayLimit);
        targetObject.set("taxlimit", (Object)taxpayLimit);
        targetObject.set("accountorg", sourceObject.get("accorg"));
        this.setJmAmount(sourceObject, targetObject, skssqq, skssqz, skssqqzMonthDiff);
    }

    private void setJmAmount(DynamicObject sourceObject, DynamicObject targetObject, Date skssqq, Date skssqz, int skssqqzMonthDiff) {
        BigDecimal totalJmamount = BigDecimal.ZERO;
        BigDecimal originalAmount = targetObject.getBigDecimal("currental");
        DynamicObjectCollection entryentity = targetObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceJmEntity = sourceObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection sourceRententryEntity = sourceObject.getDynamicObjectCollection("rententryentity");
        List<DynamicObject> rentalList = this.getRentalList(sourceRententryEntity, skssqq, skssqz);
        int missMonthCount = this.getMissMonthCount(rentalList);
        for (DynamicObject sourceJmObject : sourceJmEntity) {
            Date jmStart = sourceJmObject.getDate("start");
            Date jmEnd = sourceJmObject.getDate("end");
            Date minRentalStartDate = null;
            Date maxRentalEndDate = null;
            if (EmptyCheckUtils.isNotEmpty(rentalList)) {
                minRentalStartDate = rentalList.get(0).getDate("startdate");
                maxRentalEndDate = rentalList.get(rentalList.size() - 1).getDate("enddate");
            }
            int minusMonths = 0;
            int pererodMonths = 0;
            if (minRentalStartDate != null && maxRentalEndDate != null) {
                Date minEndDate = DateUtils.getMinDate((Date[])new Date[]{maxRentalEndDate, jmEnd, skssqz});
                Date maxStartDate = DateUtils.getMaxDate((Date[])new Date[]{minRentalStartDate, jmStart, skssqq});
                minusMonths = DateUtils.monthOfD1MinusD2((Date)minEndDate, (Date)maxStartDate) + 1 - missMonthCount;
                minEndDate = DateUtils.getMinDate((Date[])new Date[]{maxRentalEndDate, skssqz});
                maxStartDate = DateUtils.getMaxDate((Date[])new Date[]{minRentalStartDate, skssqq});
                pererodMonths = DateUtils.monthOfD1MinusD2((Date)minEndDate, (Date)maxStartDate) + 1 - missMonthCount;
            }
            String registerule = sourceJmObject.getString("registerule");
            BigDecimal amount = sourceJmObject.getBigDecimal("entervalue");
            if ("1".equals(registerule) || "2".equals(registerule)) {
                BigDecimal registeretio = sourceJmObject.getBigDecimal("registeretio");
                amount = BigDecimalUtil.multiplyObject((Object)originalAmount, (Object)registeretio, (int)2, (int)4);
            }
            if (minusMonths <= 0) continue;
            DynamicObject entry = entryentity.addNew();
            entry.set("amount", (Object)amount);
            DynamicObject taxdeduction = sourceJmObject.getDynamicObject("taxdeduction");
            entry.set("jmcode", (Object)taxdeduction);
            BigDecimal jmamount = BigDecimal.ZERO;
            String deductiontype = taxdeduction.getString("deductiontype");
            BigDecimal taxrate = targetObject.getBigDecimal("taxrate");
            boolean monthly = sourceJmObject.getBoolean("monthly");
            if (!monthly) {
                if ("1".equals(deductiontype)) {
                    jmamount = amount.multiply(taxrate).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(pererodMonths), 2, 4);
                } else if ("2".equals(deductiontype)) {
                    jmamount = amount.multiply(sourceJmObject.getBigDecimal("ratio")).multiply(taxrate).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(pererodMonths), 2, 4);
                } else if ("6".equals(deductiontype)) {
                    jmamount = BigDecimalUtil.multiplyObject((Object)sourceJmObject.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
                }
                if (JZJMCODE_LIST.contains(taxdeduction.getString("number"))) {
                    jmamount = amount.multiply(sourceJmObject.getBigDecimal("ratio")).multiply(new BigDecimal(minusMonths)).divide(new BigDecimal(pererodMonths), 2, 4);
                }
                BigDecimal yjmamount = BigDecimalUtil.divideObject((Object)jmamount, (Object)minusMonths, (int)2);
                entry.set("yjmamount", (Object)yjmamount);
            } else {
                jmamount = BigDecimalUtil.multiplyObject((Object)sourceJmObject.getBigDecimal("monthlimit"), (Object)new BigDecimal(minusMonths), (int)2);
                entry.set("yjmamount", (Object)sourceJmObject.getBigDecimal("monthlimit"));
            }
            entry.set("jmamount", (Object)jmamount);
            totalJmamount = BigDecimalUtil.addObject((Object)totalJmamount, (Object)jmamount);
            entry.set("start", sourceJmObject.get("start"));
            entry.set("end", sourceJmObject.get("end"));
        }
        targetObject.set("currentjmamount", (Object)totalJmamount);
    }

    private int getMissMonthCount(List<DynamicObject> rentalList) {
        int missMonthCount = 0;
        if (rentalList.size() >= 2) {
            for (int i = 0; i < rentalList.size() - 1; ++i) {
                DynamicObject first = rentalList.get(i);
                DynamicObject second = rentalList.get(i + 1);
                int monthDiff = DateUtils.subtractDatesForMonth((Date)second.getDate("startdate"), (Date)first.getDate("enddate"));
                missMonthCount = missMonthCount + monthDiff - 1;
            }
        }
        return missMonthCount;
    }

    private List<DynamicObject> getRentalList(DynamicObjectCollection sourceRententryEntity, Date skssqq, Date skssqz) {
        ArrayList<DynamicObject> rententryList = new ArrayList<DynamicObject>();
        for (DynamicObject rententry : sourceRententryEntity) {
            Date enddate;
            Date startdate = rententry.getDate("startdate");
            if (!DateUtils.isEffectiveDate((Date)skssqq, (Date)startdate, (Date)(enddate = rententry.getDate("enddate"))) && !DateUtils.isEffectiveDate((Date)skssqz, (Date)startdate, (Date)enddate) && !DateUtils.isEffectiveDate((Date)startdate, (Date)skssqq, (Date)skssqz) && !DateUtils.isEffectiveDate((Date)enddate, (Date)skssqq, (Date)skssqz)) continue;
            rententryList.add(rententry);
        }
        rententryList.sort(Comparator.comparing(d -> d.getDate("startdate")));
        return rententryList;
    }

    private BigDecimal getCurrentRent(DynamicObject sourceObject, Date date) {
        DynamicObjectCollection rententryentity = sourceObject.getDynamicObjectCollection("rententryentity");
        String chinesePeriod = DateUtils.getChinesePeriod((String)sourceObject.getString("fcsbyhirelimit"), (Date)date);
        BigDecimal result = BigDecimal.ZERO;
        for (DynamicObject houseRentalAdd : rententryentity) {
            DynamicObjectCollection rentDetail = houseRentalAdd.getDynamicObjectCollection("subentryentity");
            for (DynamicObject object : rentDetail) {
                if (!object.getString("skperiod").equals(chinesePeriod)) continue;
                result = result.add(object.getBigDecimal("rental"));
            }
        }
        return result;
    }

    static {
        itemMap.put("xgmnsr", 789806550519688192L);
        itemMap.put("gtgsh", 1381170168142543875L);
        itemMap.put("xxwlqy", 1381170168142542852L);
    }
}

