/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.common.enums.TcretTaxSource;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class YhsacEngineServiceImpl
implements EngineService {
    private static final String TCRET_YHS_TAX_SOURCE_INFO = TcretTaxSource.YHSAC.getEntryEntity();
    private static final String DECLARE_TYPE = "acsb";
    private static final BigDecimal RATE = BigDecimal.valueOf(0.5);
    private static final Map<String, Long> itemMap = new HashMap<String, Long>();

    @Override
    public ApiResult runEngine(EngineModel model) {
        Long sbbid = Long.valueOf(String.valueOf(model.getCustom().get("sbbid")));
        Long orgid = Long.valueOf(model.getOrgId());
        QFilter q1 = new QFilter("declaretype", "=", (Object)DECLARE_TYPE);
        QFilter q2 = new QFilter("org", "=", (Object)orgid);
        QFilter q3 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid);
        Date declaremonth = (Date)model.getValue("declaremonth");
        QFilter q4 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast((Date)declaremonth));
        Long taxofficeid = Long.valueOf(model.getCustom().get("taxoffice").toString());
        QFilter q5 = new QFilter("taxoffice", "=", (Object)taxofficeid);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)TCRET_YHS_TAX_SOURCE_INFO, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects.stream().map(a -> a.getLong("id")).toArray(Long[]::new), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_YHS_TAX_SOURCE_INFO));
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(load.length);
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)TCRET_YHS_TAX_SOURCE_INFO);
        for (DynamicObject object : load) {
            DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            BeanCopyUtils.copyDynamicObject((DynamicObject)object, (DynamicObject)target);
            target.set("sbbid", (Object)sbbid);
            objectList.add(target);
        }
        this.addXgm(model, sbbid, objectList, entityName, itemMap.getOrDefault(model.getCustom().get("reliefPolicy"), 0L));
        QFilter filter = new QFilter("id", "in", objectList.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{filter});
        SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[0]));
        return ApiResult.success(objectList);
    }

    private void addXgm(EngineModel model, Long sbbid, List<DynamicObject> objectList, String entityName, Long deductioncode) {
        Long orgid = Long.valueOf(model.getOrgId());
        Map<String, List<DynamicObject>> collect = objectList.stream().collect(Collectors.groupingBy(e -> e.getString("org_id") + e.getString("taxitem") + DateUtils.format((Date)e.getDate("skssqq")) + DateUtils.format((Date)e.getDate("skssqz"))));
        ArrayList xgmList = new ArrayList();
        HashMap changeRecordMap = new HashMap();
        collect.forEach((k, v) -> {
            DynamicObject object1 = (DynamicObject)v.get(0);
            String key = object1.getString("org") + DateUtils.format((Date)object1.getDate("skssqq")) + DateUtils.format((Date)object1.getDate("skssqz"));
            String reliefPolicyType = (String)model.getCustom().get("reliefPolicy");
            if (StringUtil.isNotBlank((CharSequence)reliefPolicyType)) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                object.set("org", (Object)orgid);
                object.set("skssqq", (Object)object1.getDate("skssqq"));
                object.set("skssqz", (Object)object1.getDate("skssqz"));
                object.set("taxitem", object1.get("taxitem"));
                object.set("taxrate", object1.get("taxrate"));
                object.set("deductioncode", (Object)deductioncode);
                object.set("declaretype", (Object)DECLARE_TYPE);
                object.set("sbbid", (Object)sbbid);
                object.set("isxgm", (Object)"1");
                BigDecimal deducttax = BigDecimal.ZERO;
                for (DynamicObject o : v) {
                    BigDecimal amount = BigDecimalUtil.subtractObject((Object)o.getBigDecimal("ynse"), (Object)o.getBigDecimal("deducttax"));
                    deducttax = BigDecimalUtil.addObject((Object)deducttax, (Object)BigDecimalUtil.multiplyObject((Object)amount, (Object)RATE, (int)2, (int)4));
                }
                DynamicObject changeRecord = changeRecordMap.computeIfAbsent(key, d -> OrgChangeRecordUtil.loadChangeRecord((String)object1.getString("org_id"), (Date)object1.getDate("skssqq"), (Date)object1.getDate("skssqz")));
                if (changeRecord != null) {
                    deducttax = PbtDeclareUtil.ajustJmse(reliefPolicyType, changeRecord, object1.getDate("skssqq"), object1.getDate("skssqz"), deducttax);
                }
                object.set("deducttax", (Object)deducttax);
                if (deducttax.compareTo(BigDecimal.ZERO) > 0) {
                    xgmList.add(object);
                }
            }
        });
        SaveServiceHelper.save((DynamicObject[])xgmList.toArray(new DynamicObject[0]));
    }

    static {
        itemMap.put("xgmnsr", 1218702811781430272L);
        itemMap.put("gtgsh", 1381170168142543877L);
        itemMap.put("xxwlqy", 1381170168142542854L);
    }
}

