/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;

public class ZysAqEngineServiceImpl
implements EngineService {
    private final Map<String, Long> itemMap = new HashMap<String, Long>();

    public ZysAqEngineServiceImpl() {
        this.itemMap.put("xgmnsr", 789806546954531840L);
        this.itemMap.put("gtgsh", 1381170168142543872L);
        this.itemMap.put("xxwlqy", 1381170168142542849L);
    }

    @Override
    public ApiResult runEngine(EngineModel model) {
        Long sbbid = Long.valueOf(String.valueOf(model.getCustom().get("sbbid")));
        Date skssqq = DateUtils.stringToDate((String)model.getStartDate());
        Date skssqz = DateUtils.stringToDate((String)model.getEndDate());
        QFilter q2 = new QFilter("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz);
        String taxtype = (String)model.getCustom().get("taxtype");
        Date declaremonth = (Date)model.getValue("declaremonth");
        if ("zysac".equals(taxtype)) {
            q2 = new QFilter("skssqz", "<=", (Object)declaremonth);
        }
        QFilter q3 = new QFilter("org", "=", (Object)Long.valueOf(model.getOrgId()));
        QFilter q4 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid);
        Long taxofficeid = Long.valueOf(model.getCustom().get("taxoffice").toString());
        QFilter q5 = new QFilter("taxoffice", "=", (Object)taxofficeid);
        QFilter q6 = new QFilter("isxgm", "=", (Object)"0");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcret_zys_collect", (String)"id", (QFilter[])new QFilter[]{q2, q3, q4, q5, q6});
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects.stream().map(a -> a.getLong("id")).toArray(Long[]::new), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_zys_collect"));
        ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(load.length);
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)"tcret_zys_collect");
        for (DynamicObject object : load) {
            DynamicObject target = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            BeanCopyUtils.copyDynamicObject((DynamicObject)object, (DynamicObject)target);
            target.set("sbbid", (Object)sbbid);
            objectList.add(target);
        }
        this.addXgm(model, Arrays.asList(load), entityName, this.itemMap.getOrDefault(model.getCustom().get("reliefPolicy"), 0L));
        QFilter filter = new QFilter("id", "in", objectList.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{filter});
        SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[0]));
        return ApiResult.success((Object)"success");
    }

    private void addXgm(EngineModel model, List<DynamicObject> objectList, String entityName, Long deductioncode) {
        Long sbbid = Long.valueOf(String.valueOf(model.getCustom().get("sbbid")));
        ArrayList<DynamicObject> xgmList = new ArrayList<DynamicObject>();
        for (DynamicObject object : objectList) {
            String reliefPolicyType = (String)model.getCustom().get("reliefPolicy");
            if (!StringUtil.isNotBlank((CharSequence)reliefPolicyType)) continue;
            DynamicObject xgmObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            xgmObject.set("org", object.get("org.id"));
            xgmObject.set("taxoffice", object.get("taxoffice.id"));
            xgmObject.set("taxsource", object.get("taxsource.id"));
            xgmObject.set("skssqq", object.get("skssqq"));
            xgmObject.set("skssqz", object.get("skssqz"));
            xgmObject.set("isxgm", (Object)"1");
            xgmObject.set("sbbid", (Object)sbbid);
            DynamicObjectCollection xgmentryentity = xgmObject.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                DynamicObject xgmentry = xgmentryentity.addNew();
                xgmentry.set("taxitem", entry.get("taxitem.id"));
                xgmentry.set("taxsubitem", entry.get("taxsubitem"));
                xgmentry.set("levy", entry.get("levy"));
                xgmentry.set("taxrate", entry.get("taxrate"));
                BigDecimal ynse = entry.getBigDecimal("ynse");
                BigDecimal jmse = entry.getBigDecimal("jmse");
                xgmentry.set("jmse", (Object)BigDecimalUtil.multiplyObject((Object)ynse.subtract(jmse), (Object)new BigDecimal("0.5"), (int)4, (int)4));
                xgmentry.set("taxdeduction", (Object)deductioncode);
            }
            xgmList.add(xgmObject);
        }
        SaveServiceHelper.save((DynamicObject[])xgmList.toArray(new DynamicObject[0]));
    }
}

