/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.SourceRelationConstant;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class TdzzsDetailsFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        QFilter q1 = new QFilter("sbbid", "=", bussinessParamsVo.getExtendParams().get("sbbid"));
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"tdzzs").or("taxtype", "=", (Object)"tdzzsqs");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (String)"taxsourceid", (QFilter[])new QFilter[]{q1, taxtypeFilter});
        List taxsourceids = dynamicObjects.stream().map(d -> d.getLong("taxsourceid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", taxsourceids);
        QFilter typeFilter = new QFilter("type", "=", (Object)"latwp").or("type", "=", (Object)"latqs");
        DynamicObjectCollection nsrxxList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,taxsourceid,skssqq,skssqz", (QFilter[])new QFilter[]{qFilter, typeFilter});
        Map<Long, DynamicObject> nsrxxMap = nsrxxList.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
        List sbbids = nsrxxList.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        QFilter sbbidFilter = new QFilter("sbbid", "in", sbbids);
        DynamicObject[] mxList = BusinessDataServiceHelper.load((String)"tcret_wp_jm_entry_tp", (String)"houtype,taxdeduction,sbbid,jmse", (QFilter[])new QFilter[]{sbbidFilter});
        Map<String, List<DynamicObject>> groupedMxData = Arrays.stream(mxList).collect(Collectors.groupingBy(d -> {
            DynamicObject nsrxx = (DynamicObject)nsrxxMap.get(d.getLong("sbbid"));
            return DateUtils.format((Date)nsrxx.getDate("skssqq")) + DateUtils.format((Date)nsrxx.getDate("skssqz")) + nsrxx.getLong("taxsourceid") + d.getString("taxdeduction");
        }));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(groupedMxData.size());
        for (Map.Entry<String, List<DynamicObject>> entry : groupedMxData.entrySet()) {
            List<DynamicObject> jmList = entry.getValue();
            DynamicObject jmObject = jmList.get(0);
            DynamicObject nsrxx = nsrxxMap.get(jmObject.getLong("sbbid"));
            DynamicObject tdzzsXm = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", nsrxx.get("taxsourceid"))});
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("tcret_ccxws_tdzzs_fb#itemnumber", tdzzsXm.get("number"));
            map.put("tcret_ccxws_tdzzs_fb#startdate", DateUtils.format((Date)nsrxx.getDate("skssqq")));
            map.put("tcret_ccxws_tdzzs_fb#enddate", DateUtils.format((Date)nsrxx.getDate("skssqz")));
            map.put("tcret_ccxws_tdzzs_fb#jmxzdm", jmObject.getString("taxdeduction.number") + jmObject.getString("taxdeduction.name"));
            map.put("tcret_ccxws_tdzzs_fb#jmse", BigDecimalUtil.sumDynamicObjectAmount(jmList, (String)"jmse"));
            list.add(map);
        }
        return list;
    }
}

