/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata.zb.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.business.declare.fetchdata.zb.IZbFetchDataService;
import kd.taxc.tcret.common.utils.DataSetUtils;
import kd.taxc.tcret.common.utils.HbsUtils;

public class HbsFetchDataService
implements IZbFetchDataService {
    private static final long TAXORGAN_XIZAN_ID = 1010868748409687313L;
    private static final String SELECT_SQL_HBS_AY = "select xh, taxtype,wrwzszm,wrwmc,org,startdate,enddate,sl,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj,sum(yjse) as yjse  group by xh,taxtype,wrwzszm,wrwmc,org,startdate,enddate,sl";
    private static final String SELECT_SQL_HBS_AJ = "select xh, taxtype,wrwzszm,wrwmc,org,sl,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj,sum(yjse) as yjse  group by xh,taxtype,wrwzszm,wrwmc,org,sl";
    private static final String SELECT_SQL_HBS_AY_NO_ZM = "select xh, taxtype,wrwmc,org,startdate,enddate,sl,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj,sum(yjse) as yjse  group by xh,taxtype,wrwmc,org,startdate,enddate,sl";
    private static final String SELECT_SQL_HBS_AJ_NO_ZM = "select xh, taxtype,wrwmc,org,sl,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj,sum(yjse) as yjse  group by xh,taxtype,wrwmc,org,sl";
    private static final List<String> FIELDS_HBS = Lists.newArrayList((Object[])new String[]{"taxtype", "sm", "sl", "startdate", "enddate", "jsyj", "ynse", "jmse", "yjse"});
    private static List<QFilter> hbsQFilters = new ArrayList<QFilter>();

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String taxauthority = (String)bussinessParamsVo.getExtendParams().get("taxauthority");
        QFilter q1 = new QFilter("id", "=", (Object)1010868748409687313L);
        QFilter q2 = new QFilter("parent", "=", (Object)1010868748409687313L);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bastax_taxorgan", (String)"id", (QFilter[])new QFilter[]{q1.or(q2)});
        boolean isxz = query.stream().anyMatch(a -> a.getString("id").equals(taxauthority));
        String declaremonth = (String)bussinessParamsVo.getExtendParams().get("declaremonth");
        Date date = DateUtils.stringToDate((String)declaremonth);
        Date startdate = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)date, (int)-3));
        Date enddate = DateUtils.getLastDateOfSeason((Date)startdate);
        String startdateStr = DateUtils.format((Date)startdate);
        String enddateStr = DateUtils.format((Date)enddate);
        String monthSelectFields = "5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,wrwmc,wrwzszm,org,month as startdate,monthend as enddate,dwse as sl,ynse,wrwdls as jsyj,jmse,bqyjse as yjse";
        String seasonSelectFields = "5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,wrwmc,wrwzszm,org,dwse as sl,ynse,wrwdls as jsyj,jmse,bqyjse as yjse";
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        Long sbbid = (Long)bussinessParamsVo.getExtendParams().get("sbbid");
        for (QFilter filter : hbsQFilters) {
            this.fetchByQFilter(maps, sbbid, filter, isxz, startdateStr, enddateStr, monthSelectFields, seasonSelectFields, "tdm_pollution_air_water", true);
        }
        monthSelectFields = "5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,wrwmc,org,month as startdate,monthend as enddate,dwse as sl,ynse,wrwdls as jsyj,jmse,bqyjse as yjse";
        seasonSelectFields = "5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,wrwmc,org,dwse as sl,ynse,wrwdls as jsyj,jmse,bqyjse as yjse";
        QFilter airFilter = new QFilter("wrwlb.number", "=", (Object)"102").and("wrwmc.number", "=", (Object)"101211111");
        this.fetchByQFilter(maps, sbbid, airFilter, isxz, startdateStr, enddateStr, monthSelectFields, seasonSelectFields, "tdm_pollution_air_water", false);
        String monthSolidSelectFields = "5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,wrwmc,wrwzszm,org,month as startdate,endmonth as enddate,dwse as sl,ynse,wrwpfl as jsyj,jmse,bqyjse as yjse";
        String seasonSolidSelectFields = "5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,wrwmc,wrwzszm,org,dwse as sl,ynse,wrwpfl as jsyj,jmse,bqyjse as yjse";
        QFilter filter = new QFilter("wrwlb.number", "=", (Object)"104");
        this.fetchByQFilter(maps, sbbid, filter, isxz, startdateStr, enddateStr, monthSolidSelectFields, seasonSolidSelectFields, "tdm_solid_waste_info", true);
        String seasonNoiseSelectFields = "'" + enddateStr + "' as enddate,'" + startdateStr + "' as startdate,5 as xh,'" + HbsFetchDataService.getHBS() + "' as taxtype,org,entryentity.dwse as sl,entryentity.sm as sm,entryentity.ynse as ynse,entryentity.jsyj as jsyj,0 as jmse,entryentity.bqyjse as yjse";
        this.fetchByQFilterNoGroup(maps, sbbid, seasonNoiseSelectFields, "tdm_noise_info");
        return maps;
    }

    private void fetchByQFilterNoGroup(List<Map<String, Object>> maps, Long sbbid, String seasonNoiseSelectFields, String entityName) {
        List taxSourceIds = SourceOperateHelper.queryTaxSourceIds((String)entityName, (Long)sbbid);
        QFilter qFilter = new QFilter("id", "in", (Object)taxSourceIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)seasonNoiseSelectFields, (QFilter[])new QFilter[]{qFilter}, (String)"month asc");
        while (dataSet.hasNext()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            Row row = dataSet.next();
            for (String field : FIELDS_HBS) {
                String key = String.format("%s#%s", "tcret_ccxws_zb_hb", field);
                resultMap.put(key, row.get(field));
            }
            maps.add(resultMap);
        }
    }

    private void fetchByQFilter(List<Map<String, Object>> maps, Long sbbid, QFilter filter, boolean isxz, String startdateStr, String enddateStr, String monthField, String seasonField, String entityName, boolean needZm) {
        List taxSourceIds = SourceOperateHelper.queryTaxSourceIds((String)entityName, (Long)sbbid);
        QFilter qFilter = new QFilter("id", "in", (Object)taxSourceIds);
        List<QFilter> filters = Arrays.asList(filter, qFilter);
        if (isxz) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)monthField, (QFilter[])filters.toArray(new QFilter[0]), (String)"month asc");
            DataSet select = needZm ? dataSet.executeSql(SELECT_SQL_HBS_AY) : dataSet.executeSql(SELECT_SQL_HBS_AY_NO_ZM);
            maps.addAll(DataSetUtils.dataSet2ListMap4Hbs(select, "tcret_ccxws_zb_hb", FIELDS_HBS, SCALE_2_AMOUNT_FIELDS));
        } else {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)seasonField, (QFilter[])filters.toArray(new QFilter[0]), (String)"month asc");
            DataSet select = needZm ? dataSet.executeSql(SELECT_SQL_HBS_AJ) : dataSet.executeSql(SELECT_SQL_HBS_AJ_NO_ZM);
            while (select.hasNext()) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                Row row = select.next();
                for (String field : FIELDS_HBS) {
                    String key = String.format("%s#%s", "tcret_ccxws_zb_hb", field);
                    if ("startdate".equals(field)) {
                        resultMap.put(key, startdateStr);
                        continue;
                    }
                    if ("enddate".equals(field)) {
                        resultMap.put(key, enddateStr);
                        continue;
                    }
                    if ("sm".equals(field)) {
                        Long wrwzszm = 0L;
                        if (needZm) {
                            wrwzszm = row.getLong("wrwzszm");
                        }
                        Long wrwmc = row.getLong("wrwmc");
                        resultMap.put(key, HbsUtils.doQueryTaxItem(wrwzszm, wrwmc));
                        continue;
                    }
                    resultMap.put(key, row.get(field));
                }
                maps.add(resultMap);
            }
        }
    }

    private static String getHBS() {
        return ResManager.loadKDString((String)"\u73af\u5883\u4fdd\u62a4\u7a0e", (String)"HbsFetchDataService_0", (String)"taxc-tcret", (Object[])new Object[0]);
    }

    static {
        hbsQFilters.add(new QFilter("wrwlb.number", "=", (Object)"101").and("swrzl.number", "=", (Object)"301"));
        hbsQFilters.add(new QFilter("wrwlb.number", "=", (Object)"101").and("swrzl.number", "=", (Object)"302"));
        hbsQFilters.add(new QFilter("wrwlb.number", "=", (Object)"101").and("swrzl.number", "=", (Object)"303"));
        hbsQFilters.add(new QFilter("wrwlb.number", "=", (Object)"101").and("swrzl.number", "=", (Object)"304"));
        hbsQFilters.add(new QFilter("wrwlb.number", "=", (Object)"102").and("wrwmc.number", "!=", (Object)"101211111"));
    }
}

