/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata.zb.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.SourceRelationConstant;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.business.declare.fetchdata.TdzzsDynmicSourceObj;
import kd.taxc.tcret.business.declare.fetchdata.zb.IZbFetchDataService;

public class TdzssFetchDataService
implements IZbFetchDataService {
    private static final Map<String, MultiLangEnumBridge> TDZ_SMS = new HashMap<String, MultiLangEnumBridge>(){
        {
            this.put("ptzz", new MultiLangEnumBridge("\u666e\u901a\u4f4f\u5b85\uff08\u5c3e\u76d8\uff09", "TdzssFetchDataService_1", "taxc-tcret"));
            this.put("fptzz", new MultiLangEnumBridge("\u975e\u666e\u901a\u4f4f\u5b85\uff08\u5c3e\u76d8\uff09", "TdzssFetchDataService_2", "taxc-tcret"));
            this.put("qtlxfc", new MultiLangEnumBridge("\u5176\u4ed6\u7c7b\u578b\u623f\u5730\u4ea7\uff08\u5c3e\u76d8\uff09", "TdzssFetchDataService_3", "taxc-tcret"));
        }
    };

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Object sbbid = bussinessParamsVo.getExtendParams().get("sbbid");
        QFilter q1 = new QFilter("sbbid", "=", sbbid);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"tdzzs");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (String)"taxsourceid", (QFilter[])new QFilter[]{q1, taxtypeFilter});
        List taxsourceids = dynamicObjects.stream().map(d -> d.getLong("taxsourceid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", taxsourceids);
        QFilter typeFiter = new QFilter("type", "=", (Object)"latwp");
        DynamicObjectCollection nsrxxList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,taxsourceid,skssqq,skssqz", (QFilter[])new QFilter[]{qFilter, typeFiter});
        List sbbids = nsrxxList.stream().map(s -> s.getString("id")).collect(Collectors.toList());
        QFilter sbbidFilter = new QFilter("sbbid", "in", sbbids);
        DynamicObjectCollection mxList = QueryServiceHelper.query((String)"tcret_tdzzs_wpsy_tax", (String)"sbbid,ewblxh,ptzz,fptzz,qtlxfc,hj", (QFilter[])new QFilter[]{sbbidFilter}, (String)"ewblxh");
        Map<String, List<DynamicObject>> mxMap = mxList.stream().collect(Collectors.groupingBy(d -> d.getString("sbbid")));
        List<TdzzsDynmicSourceObj> tdzzsWpxsData = this.getTdzzsWpxsData(nsrxxList, mxMap);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(tdzzsWpxsData.size());
        for (TdzzsDynmicSourceObj tdzzsWpxsDatum : tdzzsWpxsData) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            resultMap.put("tcret_ccxws_zb_hb#taxtype", TdzssFetchDataService.getTDZZS());
            resultMap.put("tcret_ccxws_zb_hb#sm", tdzzsWpxsDatum.getSm());
            resultMap.put("tcret_ccxws_zb_hb#startdate", tdzzsWpxsDatum.getStartdate());
            resultMap.put("tcret_ccxws_zb_hb#enddate", tdzzsWpxsDatum.getEnddate());
            resultMap.put("tcret_ccxws_zb_hb#sl", tdzzsWpxsDatum.getSl());
            resultMap.put("tcret_ccxws_zb_hb#jsyj", tdzzsWpxsDatum.getJsyj());
            resultMap.put("tcret_ccxws_zb_hb#ynse", tdzzsWpxsDatum.getYnse());
            resultMap.put("tcret_ccxws_zb_hb#jmse", tdzzsWpxsDatum.getJmse());
            resultMap.put("tcret_ccxws_zb_hb#yjse", tdzzsWpxsDatum.getYjse());
            maps.add(resultMap);
        }
        return maps;
    }

    private List<TdzzsDynmicSourceObj> getTdzzsWpxsData(DynamicObjectCollection nsrxxList, Map<String, List<DynamicObject>> mxMap) {
        ArrayList dynmicSourceObjs = Lists.newArrayList();
        for (DynamicObject tdmTdzzsWpxsswTp : nsrxxList) {
            List<DynamicObject> mxList = mxMap.get(tdmTdzzsWpxsswTp.getString("id"));
            for (Map.Entry<String, MultiLangEnumBridge> tdzzssm : TDZ_SMS.entrySet()) {
                String key = tdzzssm.getKey();
                TdzzsDynmicSourceObj dynmicSourceObj = new TdzzsDynmicSourceObj();
                dynmicSourceObj.setSm(tdzzssm.getValue().loadKDString());
                dynmicSourceObj.setStartdate(DateUtils.format((Date)tdmTdzzsWpxsswTp.getDate("skssqq")));
                dynmicSourceObj.setEnddate(DateUtils.format((Date)tdmTdzzsWpxsswTp.getDate("skssqz")));
                dynmicSourceObj.setJsyj(mxList.stream().filter(s -> "18".equals(s.get("ewblxh"))).findFirst().get().getBigDecimal(key));
                dynmicSourceObj.setSl(mxList.stream().filter(s -> "20".equals(s.get("ewblxh"))).findFirst().get().getBigDecimal(key));
                dynmicSourceObj.setYnse(mxList.stream().filter(s -> "22".equals(s.get("ewblxh"))).findFirst().get().getBigDecimal(key));
                dynmicSourceObj.setJmse(mxList.stream().filter(s -> "23".equals(s.get("ewblxh"))).findFirst().get().getBigDecimal(key));
                dynmicSourceObj.setYjse(mxList.stream().filter(s -> "24".equals(s.get("ewblxh"))).findFirst().get().getBigDecimal(key));
                dynmicSourceObjs.add(dynmicSourceObj);
            }
        }
        Map<String, List> collect = dynmicSourceObjs.stream().collect(Collectors.toMap(e -> e.getSm() + e.getStartdate() + e.getEnddate() + e.getSl(), xva$0 -> Lists.newArrayList((Object[])new TdzzsDynmicSourceObj[]{xva$0}), (k1, k2) -> {
            k1.addAll(k2);
            return k1;
        }));
        ArrayList dynmicResults = Lists.newArrayList();
        collect.forEach((k, v) -> {
            TdzzsDynmicSourceObj dynmicResult = new TdzzsDynmicSourceObj();
            TdzzsDynmicSourceObj vobj = (TdzzsDynmicSourceObj)v.get(0);
            dynmicResult.setSm(vobj.getSm());
            dynmicResult.setStartdate(vobj.getStartdate());
            dynmicResult.setEnddate(vobj.getEnddate());
            BigDecimal jsyj = BigDecimal.ZERO;
            BigDecimal ynse = BigDecimal.ZERO;
            BigDecimal jmse = BigDecimal.ZERO;
            BigDecimal yjse = BigDecimal.ZERO;
            for (TdzzsDynmicSourceObj tdzzsDynmicSourceObj : v) {
                jsyj = jsyj.add(tdzzsDynmicSourceObj.getJsyj());
                ynse = ynse.add(tdzzsDynmicSourceObj.getYnse());
                jmse = jmse.add(tdzzsDynmicSourceObj.getJmse());
                yjse = yjse.add(tdzzsDynmicSourceObj.getYjse());
            }
            vobj.setJsyj(jsyj);
            vobj.setYnse(ynse);
            vobj.setJmse(jmse);
            vobj.setYjse(yjse);
            dynmicResults.add(vobj);
        });
        dynmicResults.sort((a, b) -> a.getStartdate().equals(b.getStartdate()) ? a.getSm().compareTo(b.getSm()) : a.getStartdate().compareTo(b.getStartdate()));
        return dynmicResults;
    }

    private static String getTDZZS() {
        return ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e", (String)"TdzssFetchDataService_0", (String)"taxc-tcret", (Object[])new Object[0]);
    }
}

