/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata.zb.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.SourceRelationConstant;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.business.declare.fetchdata.TdzzsDynmicSourceObj;
import kd.taxc.tcret.business.declare.fetchdata.zb.IZbFetchDataService;

public class TdzssYjFetchDataService
implements IZbFetchDataService {
    private static final Map<Long, MultiLangEnumBridge> SM = new HashMap<Long, MultiLangEnumBridge>(){
        {
            this.put(1361446970413048832L, new MultiLangEnumBridge("\u666e\u901a\u4f4f\u5b85\uff08\u9884\u5f81\uff09", "TdzssYjFetchDataService_0", "taxc-tcret"));
            this.put(1361446970413048833L, new MultiLangEnumBridge("\u975e\u666e\u901a\u4f4f\u5b85\uff08\u9884\u5f81\uff09", "TdzssYjFetchDataService_1", "taxc-tcret"));
            this.put(1361446970413048834L, new MultiLangEnumBridge("\u5176\u4ed6\u7c7b\u578b\u623f\u5730\u4ea7\uff08\u9884\u5f81\uff09", "TdzssYjFetchDataService_2", "taxc-tcret"));
        }
    };

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Object sbbid = bussinessParamsVo.getExtendParams().get("sbbid");
        QFilter q1 = new QFilter("sbbid", "=", sbbid);
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)"tdzzsyj");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)SourceRelationConstant.BDTAXR_SOURCE_MAPPING, (String)"taxsourceid", (QFilter[])new QFilter[]{q1, taxtypeFilter});
        List taxsourceids = dynamicObjects.stream().map(d -> d.getLong("taxsourceid")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", taxsourceids);
        QFilter typeFiter = new QFilter("type", "=", (Object)"latyj");
        DynamicObjectCollection nsrxxList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,taxsourceid,skssqq,skssqz", (QFilter[])new QFilter[]{qFilter, typeFiter});
        List sbbids = nsrxxList.stream().map(s -> s.getString("id")).collect(Collectors.toList());
        QFilter sbbidFilter = new QFilter("sbbid", "in", sbbids);
        QFilter ewblxhFilter = new QFilter("ewblxh", "!=", (Object)"sum");
        DynamicObjectCollection mxList = QueryServiceHelper.query((String)"tcret_tdzzssy_mx", (String)"sbbid,ewblxh,buildingtype,subbuildingtype,yssr,hbsr,swjqtsr,stxssr,yzl,ynse,bqyjse,bqybtse", (QFilter[])new QFilter[]{sbbidFilter, ewblxhFilter}, (String)"ewblxh");
        Map<String, List<DynamicObject>> mxMap = mxList.stream().collect(Collectors.groupingBy(d -> d.getString("sbbid")));
        List<TdzzsDynmicSourceObj> tdzzsYjsyxxData = this.getTdzzsYjsyxxData(nsrxxList, mxMap);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(tdzzsYjsyxxData.size());
        for (TdzzsDynmicSourceObj tdzzsYjsyxxDatum : tdzzsYjsyxxData) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            resultMap.put("tcret_ccxws_zb_hb#taxtype", TdzssYjFetchDataService.getTDZZS());
            resultMap.put("tcret_ccxws_zb_hb#sm", tdzzsYjsyxxDatum.getSm());
            resultMap.put("tcret_ccxws_zb_hb#startdate", tdzzsYjsyxxDatum.getStartdate());
            resultMap.put("tcret_ccxws_zb_hb#enddate", tdzzsYjsyxxDatum.getEnddate());
            resultMap.put("tcret_ccxws_zb_hb#sl", tdzzsYjsyxxDatum.getSl());
            resultMap.put("tcret_ccxws_zb_hb#jsyj", tdzzsYjsyxxDatum.getJsyj());
            resultMap.put("tcret_ccxws_zb_hb#ynse", tdzzsYjsyxxDatum.getYnse());
            resultMap.put("tcret_ccxws_zb_hb#jmse", tdzzsYjsyxxDatum.getJmse());
            resultMap.put("tcret_ccxws_zb_hb#yjse", tdzzsYjsyxxDatum.getYjse());
            maps.add(resultMap);
        }
        return maps;
    }

    private List<TdzzsDynmicSourceObj> getTdzzsYjsyxxData(DynamicObjectCollection nsrxxList, Map<String, List<DynamicObject>> mxMap) {
        ArrayList dynmicSourceObjs = Lists.newArrayList();
        for (DynamicObject nsrxx : nsrxxList) {
            List<DynamicObject> mxList = mxMap.get(nsrxx.getString("id"));
            if (!EmptyCheckUtils.isNotEmpty(mxList)) continue;
            for (DynamicObject mx : mxList) {
                TdzzsDynmicSourceObj dynmicSourceObj = new TdzzsDynmicSourceObj();
                MultiLangEnumBridge buildingtype = SM.get(mx.getLong("buildingtype"));
                if (null != buildingtype) {
                    dynmicSourceObj.setSm(buildingtype.loadKDString());
                }
                dynmicSourceObj.setStartdate(DateUtils.format((Date)nsrxx.getDate("skssqq")));
                dynmicSourceObj.setEnddate(DateUtils.format((Date)nsrxx.getDate("skssqz")));
                dynmicSourceObj.setJsyj(mx.getBigDecimal("yssr"));
                dynmicSourceObj.setSl(mx.getBigDecimal("yzl"));
                dynmicSourceObj.setYnse(mx.getBigDecimal("ynse"));
                dynmicSourceObj.setJmse(BigDecimal.ZERO);
                dynmicSourceObj.setYjse(mx.getBigDecimal("bqyjse"));
                dynmicSourceObjs.add(dynmicSourceObj);
            }
        }
        ArrayList dynmicResults = Lists.newArrayList();
        Map<String, List> collect = dynmicSourceObjs.stream().collect(Collectors.toMap(e -> e.getSm() + e.getStartdate() + e.getEnddate() + e.getSl(), xva$0 -> Lists.newArrayList((Object[])new TdzzsDynmicSourceObj[]{xva$0}), (k1, k2) -> {
            k1.addAll(k2);
            return k1;
        }));
        collect.forEach((k, v) -> {
            TdzzsDynmicSourceObj dynmicResult = new TdzzsDynmicSourceObj();
            TdzzsDynmicSourceObj vobj = (TdzzsDynmicSourceObj)v.get(0);
            dynmicResult.setSm(vobj.getSm());
            dynmicResult.setStartdate(vobj.getStartdate());
            dynmicResult.setEnddate(vobj.getEnddate());
            BigDecimal jsyj = BigDecimal.ZERO;
            BigDecimal ynse = BigDecimal.ZERO;
            BigDecimal jmse = BigDecimal.ZERO;
            BigDecimal yjse = BigDecimal.ZERO;
            for (TdzzsDynmicSourceObj tdzzsDynmicSourceObj : v) {
                jsyj = jsyj.add(tdzzsDynmicSourceObj.getJsyj());
                ynse = ynse.add(tdzzsDynmicSourceObj.getYnse());
                jmse = jmse.add(tdzzsDynmicSourceObj.getJmse());
                yjse = yjse.add(tdzzsDynmicSourceObj.getYjse());
            }
            vobj.setJsyj(jsyj);
            vobj.setYnse(ynse);
            vobj.setJmse(jmse);
            vobj.setYjse(yjse);
            dynmicResults.add(vobj);
        });
        dynmicResults.sort((a, b) -> a.getStartdate().equals(b.getStartdate()) ? a.getSm().compareTo(b.getSm()) : a.getStartdate().compareTo(b.getStartdate()));
        return dynmicResults;
    }

    private static String getTDZZS() {
        return ResManager.loadKDString((String)"\u571f\u5730\u589e\u503c\u7a0e", (String)"TdzssYjFetchDataService_3", (String)"taxc-tcret", (Object[])new Object[0]);
    }
}

