/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata.zb.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.business.declare.fetchdata.zb.IZbFetchDataService;
import kd.taxc.tcret.common.utils.DataSetUtils;

public class YhsFetchDataService
implements IZbFetchDataService {
    private static final List<String> YHS_FIELDS = Lists.newArrayList((Object[])new String[]{"taxtype", "sm", "sl", "startdate", "enddate", "jsyj", "ynse", "jmse", "yjse"});
    private static final String YHS_SELECT_SQL = "select xh, taxtype,sm,org,startdate,enddate,sl,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsyj) as jsyj,sum(yjse) as yjse  group by xh,taxtype,sm,org,startdate,enddate,sl";

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Long sbbid = (Long)bussinessParamsVo.getExtendParams().get("sbbid");
        String declaremonth = (String)bussinessParamsVo.getExtendParams().get("declaremonth");
        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter declaremonthFilter = new QFilter("skssqq", "<=", (Object)DateUtils.stringToDate((String)declaremonth));
        String taxlimit = (String)bussinessParamsVo.getExtendParams().get("taxlimit");
        DataSet queryDataSet = "single".equals(taxlimit) ? QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_yhs_tax_source_info_tp", (String)("4 as xh,'" + YhsFetchDataService.getYHS() + "' as taxtype,taxitem.name as sm,org,skssqq as startdate,skssqz as enddate,taxrate as sl,ynse,deducttax as jmse,verifybasis as jsyj,yjse"), (QFilter[])new QFilter[]{qFilter, declaremonthFilter}, (String)"skssqq asc") : QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_yhs_tax_source_info_tp", (String)("4 as xh,'" + YhsFetchDataService.getYHS() + "' as taxtype,taxitem.name as sm,org,skssqq as startdate,skssqz as enddate,taxrate as sl,ynse,deducttax as jmse,verifybasis as jsyj,yjse"), (QFilter[])new QFilter[]{qFilter}, (String)"skssqq asc");
        DataSet dataSet = queryDataSet.executeSql(YHS_SELECT_SQL);
        return DataSetUtils.dataSet2ListMap(dataSet, "tcret_ccxws_zb_hb", YHS_FIELDS, SCALE_2_AMOUNT_FIELDS);
    }

    private static String getYHS() {
        return ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"YhsFetchDataService_0", (String)"taxc-tcret", (Object[])new Object[0]);
    }
}

