/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.declare.fetchdata.zb.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcret.business.declare.fetchdata.zb.IZbFetchDataService;
import kd.taxc.tcret.common.utils.DataSetUtils;

public class ZysFetchDataService
implements IZbFetchDataService {
    private static final List<String> ZYS_FIELDS = Lists.newArrayList((Object[])new String[]{"taxtype", "sm", "sl", "startdate", "enddate", "jsyj", "ynse", "jmse", "yjse"});
    private static final String ZYS_SELECT_SQL = "select xh,taxtype,sm,startdate,enddate,sl,levy,sum(ynse) as ynse,sum(jmse) as jmse,sum(jsxssl) as jsxssl,sum(jsxse) as jsxse,sum(yjse) as yjse  group by xh,taxtype,sm,levy,startdate,enddate,sl";

    @Override
    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        Long sbbid = (Long)bussinessParamsVo.getExtendParams().get("sbbid");
        String declaremonth = (String)bussinessParamsVo.getExtendParams().get("declaremonth");
        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter declaremonthFilter = new QFilter("skssqq", "<=", (Object)DateUtils.stringToDate((String)declaremonth));
        String taxlimit = (String)bussinessParamsVo.getExtendParams().get("taxlimit");
        DataSet queryDataSet = "single".equals(taxlimit) ? QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_zys_collect_tp", (String)("7 as xh,'" + ZysFetchDataService.getZYS() + "' as taxtype,entryentity.taxitem.taxitem as sm,skssqq as startdate,skssqz as enddate,entryentity.levy as levy,entryentity.taxrate as sl,entryentity.ynse as ynse,entryentity.jmse as jmse,entryentity.yjse as yjse,entryentity.jsxssl as jsxssl,entryentity.jsxse as jsxse"), (QFilter[])new QFilter[]{qFilter, declaremonthFilter}, (String)"skssqq asc") : QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"tcret_zys_collect_tp", (String)("7 as xh,'" + ZysFetchDataService.getZYS() + "' as taxtype,entryentity.taxitem.taxitem as sm,skssqq as startdate,skssqz as enddate,entryentity.levy as levy,entryentity.taxrate as sl,entryentity.ynse as ynse,entryentity.jmse as jmse,entryentity.yjse as yjse,entryentity.jsxssl as jsxssl,entryentity.jsxse as jsxse"), (QFilter[])new QFilter[]{qFilter}, (String)"skssqq asc");
        DataSet dataSet = queryDataSet.executeSql(ZYS_SELECT_SQL);
        return DataSetUtils.dataSet2ListMapForZys(dataSet, "tcret_ccxws_zb_hb", ZYS_FIELDS, SCALE_2_AMOUNT_FIELDS);
    }

    private static String getZYS() {
        return ResManager.loadKDString((String)"\u8d44\u6e90\u7a0e", (String)"ZysFetchDataService_0", (String)"taxc-tcret", (Object[])new Object[0]);
    }
}

