/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.draft;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.common.enums.CcsTypeEnum;
import kd.taxc.tcret.common.enums.FcsTypeEnum;
import kd.taxc.tcret.common.enums.TcretDraftEnum;
import kd.taxc.tcret.common.enums.TcretTaxTypeEnum;
import kd.taxc.tcret.common.enums.TcretTypeEnum;
import kd.taxc.tcret.common.utils.PbtDeclareUtil;

public class DraftDateService {
    public static Map<String, DynamicObject[]> getDraftDynamicObjectMap(Long orgId, Long taxOffice, Date declareDate, List<String> taxTypes) {
        HashMap<String, DynamicObject[]> draftMap = new HashMap<String, DynamicObject[]>(16);
        if (CollectionUtils.isEmpty(taxTypes)) {
            return draftMap;
        }
        for (String taxType : taxTypes) {
            String entity = TcretDraftEnum.getByTaxType(taxType).getDraft();
            if (!StringUtils.isNotBlank((CharSequence)entity)) continue;
            String selectFields = "";
            if (taxType.startsWith("ccs")) {
                selectFields = "id,billno,accountorg,isxxwlqy,entryentity.taxtype,entryentity.sourceid,entryentity.ccsbdm,entryentity.ccpzdm,entryentity.cclx,entryentity.cczcrq,entryentity.zxrq,entryentity.skssqq,entryentity.skssqz,entryentity.taxbasis,entryentity.taxrate,entryentity.currentpayable,entryentity.currentjmamount,entryentity.paidtaxes,entryentity.ybtse";
            }
            if (FcsTypeEnum.FCS_BY_PRICE.getType().equals(taxType)) {
                selectFields = "id,billno,accountorg,isxxwlqy,entryentity.sourceid,entryentity.assertvalue,entryentity.currentjmamount,entryentity.rentalvalue,entryentity.taxbasis,entryentity.taxrate,entryentity.taxratio,entryentity.skssqq,entryentity.skssqz,entryentity.currentpayable,entryentity.name,entryentity.paidtaxes,entryentity.ybtse";
            }
            if (FcsTypeEnum.FCS_BY_HIRE.getType().equals(taxType)) {
                selectFields = "id,billno,accountorg,isxxwlqy,entryentity.sourceid,entryentity.currental,entryentity.name,entryentity.taxrate,entryentity.skssqq,entryentity.skssqz,entryentity.currentpayable,entryentity.currentjmamount,entryentity.paidtaxes,entryentity.ybtse";
            }
            if (FcsTypeEnum.TDS.getType().equals(taxType)) {
                selectFields = "id,billno,accountorg,isxxwlqy,entryentity.sourceid,entryentity.occupylandarea,entryentity.landlevel,entryentity.taxstandard,entryentity.taxbasis,entryentity.skssqq,entryentity.skssqz,entryentity.currentpayable,entryentity.currentjmamount,entryentity.name,entryentity.paidtaxes,entryentity.ybtse";
            }
            Date start = DateUtils.getFirstDateOfMonth((Date)declareDate);
            Date end = DateUtils.getLastDateOfMonth((Date)declareDate);
            QFilter q1 = new QFilter("org", "=", (Object)orgId);
            QFilter q2 = new QFilter("taxoffice", "=", (Object)taxOffice);
            QFilter q3 = new QFilter("collectiondate", ">=", (Object)start).and(new QFilter("collectiondate", "<=", (Object)end));
            QFilter q4 = new QFilter("billstatus", "=", (Object)"C");
            DynamicObject[] draft = BusinessDataServiceHelper.load((String)entity, (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3, q4});
            if (draft == null) continue;
            draftMap.put(taxType, draft);
        }
        return draftMap;
    }

    /*
     * Could not resolve type clashes
     */
    public static List<String> getNoDraftList(String orgId, String taxOffice, Long sbbid, Map<String, DynamicObject[]> draftDynamicObjectMap, List<String> draftTaxTypeList, String isxxwlqy, String declaremonth) {
        Map<String, String> skssqMap = DraftDateService.getSkssq(OperationStatus.ADDNEW, sbbid);
        String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)Long.parseLong(orgId), (Date)DateUtils.stringToDate((String)skssqMap.get("skssqq")), (Date)DateUtils.stringToDate((String)skssqMap.get("skssqz")), (boolean)true);
        boolean isXgm = "xgmnsr".equals(reliefPolicyType);
        boolean isXxwl = "true".equals(isxxwlqy);
        boolean isGtgsh = "gtgsh".equals(reliefPolicyType);
        boolean isXwlqy = isXgm || isXxwl || isGtgsh;
        String baseEntity = "";
        String selectFields = "";
        String commonFields = "";
        ArrayList<String> noDraftList = new ArrayList<String>();
        for (String taxtype : draftTaxTypeList) {
            QFilter q1 = new QFilter("sbbid", "=", (Object)sbbid);
            if (taxtype.startsWith("ccs")) {
                baseEntity = "tcret_pbt_ccs_sum";
                selectFields = "id,taytype";
                QFilter q2 = new QFilter("taytype", "=", (Object)taxtype);
                q1 = q1.and(q2);
            } else {
                FcsTypeEnum enumType = FcsTypeEnum.getByTaxType(taxtype);
                baseEntity = enumType.getEntityName();
                selectFields = "id,isxgm";
                if (!isXwlqy) {
                    QFilter q2 = new QFilter("isxgm", "!=", (Object)"1");
                    q1 = q1.and(q2);
                }
            }
            if (taxtype.startsWith("ccs")) {
                commonFields = "sourceid,ccsbdm,ccpzdm,cclx,cczcrq,zxrq,skssqq,skssqz,taxbasis,taxrate,ynse,jmse,paidtaxes,ybtse,accountorg,draftid";
            }
            if (FcsTypeEnum.FCS_BY_PRICE.getType().equals(taxtype)) {
                commonFields = "assertvalue,currentjmamount,rentalvalue,taxbasis,taxrate,taxratio,skssqq,skssqz,currentpayable,paidtaxes,ybtse,accountorg,draftid";
            }
            if (FcsTypeEnum.FCS_BY_HIRE.getType().equals(taxtype)) {
                commonFields = "currental,taxrate,skssqq,skssqz,currentpayable,currentjmamount,paidtaxes,ybtse,accountorg,draftid";
                selectFields = selectFields + ",leasecontractno";
            }
            if (FcsTypeEnum.TDS.getType().equals(taxtype)) {
                commonFields = "occupylandarea,landlevel,taxstandard,taxbasis,skssqq,skssqz,currentpayable,currentjmamount,paidtaxes,ybtse,accountorg,draftid";
            }
            TcretDraftEnum draftEnum = TcretDraftEnum.getByTaxType(taxtype);
            String matchField = draftEnum.getMatchField();
            selectFields = selectFields + "," + matchField;
            String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)baseEntity);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)(selectFields + "," + commonFields), (QFilter[])new QFilter[]{q1});
            DynamicObject[] draftObjByTypes = draftDynamicObjectMap.get(taxtype);
            ArrayList draftObjList = new ArrayList(16);
            if (draftObjByTypes != null) {
                for (DynamicObject obj : draftObjByTypes) {
                    DynamicObjectCollection collection;
                    DynamicObjectCollection dynamicObjectCollection = collection = obj == null ? null : obj.getDynamicObjectCollection("entryentity");
                    if (collection == null) continue;
                    for (Object draftObj : collection) {
                        HashMap<String, Object> map = new HashMap<String, Object>(16);
                        String[] stringArray = commonFields.split(",");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String field = stringArray[i];
                            if ("draftid".equals(field)) {
                                map.put(field, draftObj.get("id"));
                                continue;
                            }
                            if ("ynse".equals(field)) {
                                map.put(field, draftObj.get("currentpayable"));
                                continue;
                            }
                            if ("jmse".equals(field)) {
                                map.put(field, draftObj.get("currentjmamount"));
                                continue;
                            }
                            if ("accountorg".equals(field)) {
                                map.put(field, obj.get(field));
                                continue;
                            }
                            map.put(field, draftObj.get(field));
                        }
                        if (TcretDraftEnum.FCS_BY_HIRE.getType().equals(taxtype)) {
                            map.put("leasecontractno", draftObj.get("sourceid.number"));
                            map.put("sourceid", draftObj.get("sourceid.id"));
                        }
                        if (TcretDraftEnum.FCS_BY_PRICE.getType().equals(taxtype) || TcretDraftEnum.TDS.getType().equals(taxtype)) {
                            map.put("number", draftObj.get("sourceid.number"));
                            map.put("sourceid", draftObj.get("sourceid.id"));
                        }
                        if (taxtype.startsWith("ccs")) {
                            map.put("taxtype", draftObj.get("taxtype"));
                        }
                        draftObjList.add(map);
                    }
                }
            }
            for (DynamicObject obj : dynamicObjects) {
                if (obj == null || !taxtype.startsWith("ccs") && isXwlqy && (obj.getString("isxgm").equals("true") || obj.getString("isxgm").equals("1"))) continue;
                boolean curentMatch = false;
                if (!CollectionUtils.isEmpty(draftObjList)) {
                    for (Object draftObj : draftObjList) {
                        if (!obj.getString("skssqq").equals(String.valueOf(draftObj.get("skssqq"))) || !obj.getString("skssqz").equals(String.valueOf(draftObj.get("skssqz")))) continue;
                        if (taxtype.startsWith("ccs") && obj.getString("taytype").equals(String.valueOf(draftObj.get("taxtype"))) && obj.getString(matchField).equals(String.valueOf(draftObj.get(matchField)))) {
                            curentMatch = true;
                            for (String field : commonFields.split(",")) {
                                obj.set(field, draftObj.get(field));
                            }
                        } else {
                            if (taxtype.startsWith("ccs")) continue;
                            boolean match = obj.getString(matchField).equals(String.valueOf(draftObj.get(matchField)));
                            if ("sourceid".equals(matchField)) {
                                match = obj.getString("sourceid.id").equals(String.valueOf(draftObj.get(matchField)));
                            }
                            if (!match) continue;
                            curentMatch = true;
                            for (String field : commonFields.split(",")) {
                                obj.set(field, draftObj.get(field));
                            }
                        }
                        break;
                    }
                }
                if (curentMatch) continue;
                String number = "";
                if (taxtype.startsWith("ccs")) {
                    QFilter q = new QFilter("id", "=", (Object)obj.getLong(matchField));
                    DynamicObject obj1 = QueryServiceHelper.queryOne((String)CcsTypeEnum.getByTaxType(taxtype).getSourceEntity(), (String)"number", (QFilter[])new QFilter[]{q});
                    number = obj1 == null ? "" : obj1.getString("number");
                } else {
                    DynamicObject sourceObject;
                    number = FcsTypeEnum.FCS_BY_HIRE.getType().equals(taxtype) ? ((sourceObject = BusinessDataServiceHelper.loadSingle((String)FcsTypeEnum.FCS_BY_HIRE.getSourceEntity(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)obj.getLong("sourceid.id"))})) == null ? "" : sourceObject.getString("leasecontractno")) : obj.getString(matchField);
                }
                StringBuilder noDraft = new StringBuilder();
                noDraft.append(draftEnum.getNameStr()).append(number);
                noDraftList.add(noDraft.toString());
            }
            if (!CollectionUtils.isEmpty(noDraftList)) continue;
            if (!taxtype.startsWith("ccs") && isXwlqy) {
                for (DynamicObject obj : dynamicObjects) {
                    if (obj.getString("isxgm").equals("true") || obj.getString("isxgm").equals("1")) continue;
                    for (DynamicObject o : dynamicObjects) {
                        if (!o.getString("isxgm").equals("true") && !o.getString("isxgm").equals("1") || !obj.get(matchField).equals(o.get(matchField)) || !obj.get("skssqq").equals(o.get("skssqq")) || !obj.get("skssqz").equals(o.get("skssqz"))) continue;
                        o.set("currentjmamount", obj.get("currentjmamount"));
                        obj.set("currentjmamount", null);
                    }
                }
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
        return noDraftList;
    }

    public static Map<String, String> getSkssq(OperationStatus operationStatus, Long sbbId) {
        QFilter filter = new QFilter("sbbid", "=", (Object)sbbId);
        DynamicObjectCollection declareQueryCollection = QueryServiceHelper.query((String)EntityMappingUtils.getEntityName((OperationStatus)operationStatus, (String)"tcret_declare_main"), (String)"id, entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz, entryentity.taxlimit as taxlimit, entryentity.taxstatus as taxstatus,billstatus, status", (QFilter[])new QFilter[]{filter});
        return PbtDeclareUtil.getSkssqzMap((List<DynamicObject>)declareQueryCollection);
    }

    public static List<String> getDifferentDrafIsxxwlqy(List<String> draftTaxTypeList, Map<String, DynamicObject[]> draftDynamicObjectMap, String isxxwlqy) {
        ArrayList<String> drafIsxxwlqyList = new ArrayList<String>();
        List<String> checkIsxxwlqyList = Arrays.asList(TcretDraftEnum.FCS_BY_PRICE.getType(), TcretDraftEnum.FCS_BY_HIRE.getType(), TcretDraftEnum.TDS.getType());
        for (String taxType : draftTaxTypeList) {
            if (!checkIsxxwlqyList.contains(taxType)) continue;
            DynamicObject[] draftObjs = draftDynamicObjectMap.get(taxType);
            if (draftObjs == null) {
                return draftTaxTypeList;
            }
            for (DynamicObject draftObj : draftObjs) {
                String drafIsxxwlqy = draftObj.getString("isxxwlqy");
                if ("1".equals(drafIsxxwlqy)) {
                    drafIsxxwlqy = "true";
                }
                if ("0".equals(drafIsxxwlqy)) {
                    drafIsxxwlqy = "false";
                }
                String draftNumber = draftObj.getString("billno");
                if ("true".equals(isxxwlqy) && "true".equals(drafIsxxwlqy) || !"true".equals(isxxwlqy) && !"true".equals(drafIsxxwlqy)) continue;
                String draftMsg = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u5e95\u7a3f\u3010%s\u3011", (String)"PbtDeclareHomePlugin_38", (String)"taxc-tcret", (Object[])new Object[0]), draftNumber);
                drafIsxxwlqyList.add(TcretDraftEnum.getByTaxType(taxType).getNameStr() + draftMsg);
            }
        }
        return drafIsxxwlqyList;
    }

    public static List<String> getTaxTypesByDeclareItemCollection(DynamicObjectCollection collection) {
        ArrayList<String> taxtypelist = new ArrayList<String>();
        for (DynamicObject obj : collection) {
            String taxType = obj.getString("taxtype");
            taxtypelist.add(taxType);
        }
        return taxtypelist;
    }

    public static List<String> getDraftTaxTypes(List<String> taxTypeList) {
        ArrayList<String> taxtypelist = new ArrayList<String>(16);
        if (CollectionUtils.isEmpty(taxTypeList)) {
            return taxtypelist;
        }
        for (String taxType : taxTypeList) {
            if (!TcretDraftEnum.getTypeList().contains(taxType)) continue;
            taxtypelist.add(taxType);
        }
        return taxtypelist;
    }

    public static List<String> getNoYwjsfaList(Long orgId, List<DynamicObject> taxTypeList) {
        ArrayList<String> noYwjsfaTaxTypes = new ArrayList<String>();
        for (DynamicObject item : taxTypeList) {
            String taxtype = item.getString("taxtype");
            List<String> tcretTaxTypeEnums = Arrays.asList(TcretTaxTypeEnum.TAXTYPE_FCS_HIRE.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_FCS_PRICE.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_FCS_TDS.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_CCS_CB.getTaxtype(), TcretTaxTypeEnum.TAXTYPE_CCS_CL.getTaxtype());
            if (!tcretTaxTypeEnums.contains(taxtype)) {
                noYwjsfaTaxTypes.add(taxtype);
                continue;
            }
            Long taxCategoryId = TcretTaxTypeEnum.getBaseTaxIdByTaxtype(taxtype);
            TaxResult taxtionResult = ProvisionSharePlanDataServiceHelper.queryTaxSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)taxCategoryId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)item.getDate("skssqq"), (Date)item.getDate("skssqz"));
            if (!taxtionResult.isSuccess()) {
                noYwjsfaTaxTypes.add(taxtype);
                continue;
            }
            DynamicObjectCollection data = (DynamicObjectCollection)taxtionResult.getData();
            if (CollectionUtils.isEmpty((Collection)data)) {
                noYwjsfaTaxTypes.add(taxtype);
                continue;
            }
            if ("0".equals(((DynamicObject)data.get(0)).getString("ruleentity.rule.enable"))) {
                noYwjsfaTaxTypes.add(taxtype);
                continue;
            }
            String taxdimension = ((DynamicObject)data.get(0)).getString("ruleentity.rule.provisiondimension");
            if (taxdimension.contains("accountorg")) continue;
            noYwjsfaTaxTypes.add(taxtype);
        }
        return noYwjsfaTaxTypes;
    }

    public static BaseResult checkDraftSourceInfo(Long orgid, String isxxwlqy, Date declaremonth, Long taxOffice, List<DynamicObject> declareItemCollection) {
        StringBuilder message = new StringBuilder();
        Map<String, List<DynamicObject>> taxtypeMap = declareItemCollection.stream().collect(Collectors.groupingBy(e -> e.getString("taxtype")));
        for (String taxtype : taxtypeMap.keySet()) {
            if ("fcscj".equals(taxtype)) {
                DraftDateService.checkFcs(orgid, isxxwlqy, declaremonth, taxOffice, FcsTypeEnum.FCS_BY_PRICE, message);
            }
            if ("fcscz".equals(taxtype)) {
                DraftDateService.checkFcs(orgid, isxxwlqy, declaremonth, taxOffice, FcsTypeEnum.FCS_BY_HIRE, message);
            }
            if ("cztdsys".equals(taxtype)) {
                DraftDateService.checkFcs(orgid, isxxwlqy, declaremonth, taxOffice, FcsTypeEnum.TDS, message);
            }
            if ("ccscl".equals(taxtype)) {
                DraftDateService.checkCcs(orgid, declaremonth, taxOffice, CcsTypeEnum.CCSCL, message);
            }
            if (!"ccscb".equals(taxtype)) continue;
            DraftDateService.checkCcs(orgid, declaremonth, taxOffice, CcsTypeEnum.CCSCB, message);
        }
        if (message.length() > 0) {
            return BaseResult.fail((String)message.toString(), (Object)false);
        }
        return BaseResult.ok((Object)true);
    }

    private static void checkCcs(Long orgid, Date declaremonth, Long taxOffice, CcsTypeEnum type, StringBuilder message) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter("withheld", "=", (Object)"0"));
        qFilters.add(new QFilter(type.getOrg(), "=", (Object)orgid));
        qFilters.add(new QFilter("taxauthority", "=", (Object)taxOffice));
        int month = DateUtils.getMonthOfDate((Date)declaremonth);
        qFilters.add(new QFilter(type.getSbqx(), "=", (Object)String.valueOf(month)));
        Date lastDateOfYear = DateUtils.getLastDateOfYear((Date)declaremonth);
        qFilters.add(new QFilter(type.getStart(), "<=", (Object)lastDateOfYear));
        Date firstDateOfYear = DateUtils.getFirstDateOfYear((Date)declaremonth);
        qFilters.add(new QFilter("closedate", "is null", null).or(new QFilter("closedate", ">=", (Object)firstDateOfYear)));
        String entityName = type.getSourceEntity();
        DynamicObjectCollection sourceList = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]));
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter q1 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxOffice);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)declaremonth);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)declaremonth);
        QFilter q3 = new QFilter("collectiondate", ">=", (Object)firstDateOfMonth).and(new QFilter("collectiondate", "<=", (Object)lastDateOfMonth));
        QFilter sourcetype = new QFilter("sourcetype", "=", (Object)type.getType());
        DynamicObjectCollection draftList = QueryServiceHelper.query((String)TcretTypeEnum.getDraftByType(type.getType()), (String)"billno,entryentity.sourceid as sourceid", (QFilter[])new QFilter[]{orgFilter, q1, q2, q3, sourcetype});
        Map<Long, String> billnoSourceidMap = draftList.stream().collect(Collectors.toMap(k -> k.getLong("sourceid"), v -> v.getString("billno"), (k1, k2) -> k1));
        if (CollectionUtils.isEmpty((Collection)draftList)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u7533\u62a5\u5e95\u7a3f\u672a\u751f\u6210\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u5e95\u7a3f\u540e\u91cd\u65b0\u786e\u8ba4\u7533\u62a5\u9879\u76ee\u3002", (String)"DraftDateService_0", (String)"taxc-tcret", (Object[])new Object[0]), TcretTypeEnum.getTaxName(type.getType()));
            message.append(msg).append("\r\n");
            return;
        }
        for (DynamicObject object : sourceList) {
            if (billnoSourceidMap.containsKey(object.getLong("id"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7a0e\u6e90\u4fe1\u606f\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u7a0e\u6e90\uff0c\u672a\u751f\u6210\u7533\u62a5\u5e95\u7a3f\u6216\u5e95\u7a3f\u672a\u5ba1\u6838\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u5e95\u7a3f\u540e\u91cd\u65b0\u786e\u8ba4\u7533\u62a5\u9879\u76ee\u3002", (String)"DraftDateService_2", (String)"taxc-tcret", (Object[])new Object[0]), TcretTypeEnum.getTaxName(type.getType()), object.getString("number"));
            message.append(msg).append("\r\n");
        }
    }

    private static void checkFcs(Long orgid, String isxxwlqy, Date declaremonth, Long taxOffice, FcsTypeEnum fcsTypeEnum, StringBuilder message) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        qFilters.add(orgFilter);
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(new QFilter(fcsTypeEnum.getTaxtimelimitKey(), "!=", (Object)"false"));
        qFilters.add(new QFilter("taxauthority", "=", (Object)taxOffice));
        if (FcsTypeEnum.FCS_BY_HIRE == fcsTypeEnum) {
            qFilters.add(new QFilter("fcsapanage.number", "!=", (Object)"SZSSWJ"));
        }
        String entityName = fcsTypeEnum.getSourceEntity();
        DynamicObjectCollection sourceList = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]));
        QFilter q1 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxOffice);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)declaremonth);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)declaremonth);
        QFilter q3 = new QFilter("collectiondate", ">=", (Object)firstDateOfMonth).and(new QFilter("collectiondate", "<=", (Object)lastDateOfMonth));
        DynamicObjectCollection draftList = QueryServiceHelper.query((String)TcretTypeEnum.getDraftByType(fcsTypeEnum.getType()), (String)"billno,entryentity.sourceid as sourceid,isxxwlqy", (QFilter[])new QFilter[]{orgFilter, q1, q2, q3});
        Map<Long, String> billnoSourceidMap = draftList.stream().collect(Collectors.toMap(k -> k.getLong("sourceid"), v -> v.getString("billno"), (k1, k2) -> k1));
        if (CollectionUtils.isEmpty((Collection)draftList)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u7533\u62a5\u5e95\u7a3f\u672a\u751f\u6210\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u5e95\u7a3f\u540e\u91cd\u65b0\u786e\u8ba4\u7533\u62a5\u9879\u76ee\u3002", (String)"DraftDateService_0", (String)"taxc-tcret", (Object[])new Object[0]), TcretTypeEnum.getTaxName(fcsTypeEnum.getType()));
            message.append(msg).append("\r\n");
            return;
        }
        Map<String, List<DynamicObject>> draftMap = draftList.stream().collect(Collectors.groupingBy(e -> e.getString("billno")));
        for (Map.Entry<String, List<DynamicObject>> draft : draftMap.entrySet()) {
            String xxwlqy;
            DynamicObject object = draft.getValue().get(0);
            String draftisxxwlqy = object.getString("isxxwlqy");
            draftisxxwlqy = "1".equals(draftisxxwlqy) ? "1" : "0";
            if (draftisxxwlqy.equals(xxwlqy = "true".equals(isxxwlqy) ? "1" : "0")) continue;
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7533\u62a5\u5e95\u7a3f\u7f16\u53f7\u4e3a\u3010%2$s\u3011\u7684\u5e95\u7a3f\u4e0e\u5f53\u524d\u3010\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\u3011\u9009\u62e9\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DraftDateService_1", (String)"taxc-tcret", (Object[])new Object[0]), TcretTypeEnum.getTaxName(fcsTypeEnum.getType()), draft.getKey());
            message.append(msg).append("\r\n");
        }
        for (DynamicObject object : sourceList) {
            if (billnoSourceidMap.containsKey(object.getLong("id"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u7a0e\u6e90\u4fe1\u606f\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u7a0e\u6e90\uff0c\u672a\u751f\u6210\u7533\u62a5\u5e95\u7a3f\u6216\u5e95\u7a3f\u672a\u5ba1\u6838\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u5e95\u7a3f\u540e\u91cd\u65b0\u786e\u8ba4\u7533\u62a5\u9879\u76ee\u3002", (String)"DraftDateService_2", (String)"taxc-tcret", (Object[])new Object[0]), TcretTypeEnum.getTaxName(fcsTypeEnum.getType()), object.getString("number"));
            message.append(msg).append("\r\n");
        }
    }

    public static BaseResult checkDraftData(String orgId, String taxOffice, String declaremonth, String sbbId, Map<String, DynamicObject[]> draftDynamicObjectMap, String isxxwlqy, List<String> draftTaxTypeList) {
        List<String> noDraftList = DraftDateService.getNoDraftList(orgId, taxOffice, Long.parseLong(sbbId), draftDynamicObjectMap, draftTaxTypeList, isxxwlqy, declaremonth);
        if (!CollectionUtils.isEmpty(noDraftList)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u7533\u62a5\u5e95\u7a3f\u672a\u751f\u6210\uff0c\u8bf7\u63d0\u4ea4\u5ba1\u6838\u5e95\u7a3f\u540e\u91cd\u65b0\u786e\u8ba4\u7533\u62a5\u9879\u76ee\u3002", (String)"PbtDeclareHomePlugin_37", (String)"taxc-tcret", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(noDraftList));
            return BaseResult.ok((String)msg, (Object)false);
        }
        List<String> differentDrafIsxxwlqy = DraftDateService.getDifferentDrafIsxxwlqy(draftTaxTypeList, draftDynamicObjectMap, isxxwlqy);
        if (!CollectionUtils.isEmpty(differentDrafIsxxwlqy)) {
            String msg = String.format(ResManager.loadKDString((String)"%s\u4e0e\u5f53\u524d\u3010\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\u3011\u9009\u62e9\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PbtDeclareHomePlugin_39", (String)"taxc-tcret", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(differentDrafIsxxwlqy));
            return BaseResult.ok((String)msg, (Object)false);
        }
        return BaseResult.ok((Object)true);
    }
}

