/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.business.draft.DraftCalculateServiceFactory;
import kd.taxc.tcret.common.constant.TcretDraftConstant;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public class DraftServiceHelpler
implements TcretDraftConstant {
    public static DynamicObject queryDraft(String entityName, Long orgId, Long accountOrgId, Long taxofficeId, Date collectionDate, String sourceType) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("accountorg", "=", (Object)accountOrgId);
        QFilter q3 = new QFilter("taxoffice", "=", (Object)taxofficeId);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)collectionDate);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)collectionDate);
        QFilter q4 = new QFilter("collectiondate", ">=", (Object)firstDateOfMonth).and(new QFilter("collectiondate", "<=", (Object)lastDateOfMonth));
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(q1);
        qFilters.add(q2);
        qFilters.add(q3);
        qFilters.add(q4);
        if (!StringUtil.isBlank((CharSequence)sourceType)) {
            QFilter q5 = new QFilter("sourcetype", "=", (Object)sourceType);
            qFilters.add(q5);
        }
        return QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static boolean check(IFormView view, DynamicObject taxOrg, Long category, Date collectionDate) {
        List data = (List)ProvisionSharePlanDataServiceHelper.queryTaxSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxOrg.getLong("id")), (Long)category, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)collectionDate, (Date)collectionDate).getData();
        if (data.size() == 0 || "0".equals(((DynamicObject)data.get(0)).getString("enable"))) {
            if (view != null) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\uff1a\u672c\u671f\u65e0\u53ef\u7528\u7684\u201c\u7eb3\u7a0e\u7533\u62a5\u201d\u8ba1\u7a0e\u65b9\u6848\uff0c\u8bf7\u524d\u5f80\u201c\u8ba1\u7a0e\u65b9\u6848\u8bbe\u7f6e\u201d\u7ef4\u62a4\u201c\u8ba1\u7a0e\u65b9\u6848\u201d\u53ca\u5176\u201c\u5171\u4eab\u65b9\u6848\u201d\u3002", (String)"DraftServiceHelpler_0", (String)"taxc-tcret", (Object[])new Object[0]), taxOrg.getString("name")));
            }
            return false;
        }
        if (!CollectionUtils.isEmpty((Collection)data)) {
            DynamicObject entry = (DynamicObject)data.get(0);
            String taxdimension = entry.getString("ruleentity.rule.provisiondimension");
            Date startdate = entry.getDate("ruleentity.rule.startdate");
            Date enddate = entry.getDate("ruleentity.rule.enddate");
            if (!taxdimension.contains("accountorg")) {
                if (view != null) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\uff1a\u672c\u671f\u65e0\u53ef\u7528\u7684\u201c\u7eb3\u7a0e\u7533\u62a5\u201d\u8ba1\u7a0e\u65b9\u6848\uff0c\u8bf7\u524d\u5f80\u201c\u8ba1\u7a0e\u65b9\u6848\u8bbe\u7f6e\u201d\u7ef4\u62a4\u201c\u8ba1\u7a0e\u65b9\u6848\u201d\u53ca\u5176\u201c\u5171\u4eab\u65b9\u6848\u201d\u3002", (String)"DraftServiceHelpler_0", (String)"taxc-tcret", (Object[])new Object[0]), taxOrg.getString("name")));
                }
                return false;
            }
            view.getPageCache().put("planstartdate", DateUtils.format((Date)startdate));
            if (enddate != null) {
                view.getPageCache().put("planenddate", DateUtils.format((Date)enddate));
            }
        }
        return true;
    }

    public static List<DynamicObject> getDataByRunEngine(List<DynamicObject> items, String entityName, Long orgid, Long taxofficeId, Date collectionDate, String isxxwlqy, Long accountOrgId) {
        EngineService engineService = DraftCalculateServiceFactory.getEngineService(entityName);
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(8);
        DynamicObject taxorg = (DynamicObject)TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)orgid).getData();
        Boolean changeEffectCurrentMonth = TcretSystemParamUtil.getChangeEffectCurrentMonth(orgid);
        for (DynamicObject item : items) {
            ApiResult apiResult;
            Date skssqq = item.getDate("skssqq");
            Date skssqz = item.getDate("skssqz");
            String itemTaxtype = item.getString("taxtype");
            String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)orgid, (Date)skssqq, (Date)skssqz, (boolean)true);
            EngineModel model = new EngineModel(taxorg.getString("id"), DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
            String taxlimit = item.getString("taxlimit");
            model.addCustom("taxlimit", (Object)taxlimit);
            model.addCustom("declaremonth", (Object)collectionDate);
            model.addCustom("taxoffice", (Object)String.valueOf(taxofficeId));
            model.addCustom("sbbid", (Object)0L);
            model.addCustom("changeeffectcurrentmonth", (Object)changeEffectCurrentMonth);
            model.addCustom("taxtype", (Object)itemTaxtype);
            model.addCustom("accountorg", (Object)accountOrgId);
            if (!itemTaxtype.startsWith("ccs")) {
                if ("1".equals(isxxwlqy)) {
                    model.addCustom("reliefPolicy", (Object)"xxwlqy");
                } else if (("0".equals(isxxwlqy) || "".equals(isxxwlqy)) && "xxwlqy".equals(reliefPolicyType)) {
                    model.addCustom("reliefPolicy", (Object)"");
                } else {
                    model.addCustom("reliefPolicy", (Object)reliefPolicyType);
                }
            }
            if (!(apiResult = engineService.runEngine(model)).getSuccess()) continue;
            List data = (List)apiResult.getData();
            detailList.addAll(data);
        }
        return detailList;
    }

    public static HashMap<String, Date> getXxwlqyDate(List<DynamicObject> declareQueryCollection, DynamicObject taxMainInfo, DynamicObject taxOrg) {
        DynamicObject dynamicObject2;
        Date start = declareQueryCollection.get(0).getDate("skssqq");
        Date end = declareQueryCollection.get(0).getDate("skssqz");
        for (DynamicObject dynamicObject2 : declareQueryCollection) {
            if (dynamicObject2.getDate("skssqq").before(start)) {
                start = dynamicObject2.getDate("skssqq");
            }
            if (!dynamicObject2.getDate("skssqz").after(end)) continue;
            end = dynamicObject2.getDate("skssqz");
        }
        String orgId = taxOrg.getString("id");
        dynamicObject2 = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)start, (Date)end);
        if (dynamicObject2 != null) {
            String registertype;
            String taxpayertype = dynamicObject2.getString("taxpayertype");
            if (taxMainInfo == null) {
                taxMainInfo = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId)).getData();
            }
            String string = registertype = taxMainInfo != null ? taxMainInfo.getString("registertype.number") : "";
            if ("ybnsr".equals(taxpayertype) && !Arrays.asList("410", "411", "412", "413").contains(registertype)) {
                HashMap<String, Date> map = new HashMap<String, Date>(8);
                map.put("skssqq", start);
                map.put("skssqz", end);
                return map;
            }
        }
        return new HashMap<String, Date>(8);
    }

    public static DynamicObject getCurrency() {
        return BusinessDataServiceHelper.loadSingle((Object)1L, (String)"bd_currency");
    }
}

