/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.hbs;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.tcret.business.hbs.ISourceProvider;
import kd.taxc.tcret.business.hbs.impl.AirWaterSourceProvider;
import kd.taxc.tcret.business.hbs.impl.NoiseInfoSourceProvider;
import kd.taxc.tcret.business.hbs.impl.SolidWasteSourceProvider;

public class HbsSourceProvider {
    private static final Map<String, ISourceProvider> providerMap = new HashMap<String, ISourceProvider>();

    public static List<DynamicObject> execute(Long orgId, Date skssqq, Date skssqz, Long taxoffice, Long sbbid) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (Map.Entry<String, ISourceProvider> entry : providerMap.entrySet()) {
            ISourceProvider provider = entry.getValue();
            List<DynamicObject> sourceList = provider.query(orgId, skssqq, skssqz, taxoffice, sbbid);
            SourceOperateHelper.saveMappingData((String)entry.getKey(), (Long)sbbid, sourceList);
            result.addAll(sourceList);
        }
        return result;
    }

    public static DynamicObjectCollection buildDeclareItem(Long orgId, Date skssqq, Date skssqz, Long taxoffice, Long sbbid) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tcret_pbt_items");
        for (Map.Entry<String, ISourceProvider> entry : providerMap.entrySet()) {
            boolean exists = entry.getValue().exists(orgId, skssqq, skssqz, taxoffice, sbbid);
            if (!exists) continue;
            DynamicObject aqobject = new DynamicObject((DynamicObjectType)entityType);
            aqobject.set("taxtype", (Object)"hbsaq");
            aqobject.set("skssqq", (Object)skssqq);
            aqobject.set("skssqz", (Object)skssqz);
            aqobject.set("taxlimit", (Object)"season");
            collection.add((Object)aqobject);
            return collection;
        }
        return collection;
    }

    static {
        providerMap.put("tdm_pollution_air_water", new AirWaterSourceProvider());
        providerMap.put("tdm_solid_waste_info", new SolidWasteSourceProvider());
        providerMap.put("tdm_noise_info", new NoiseInfoSourceProvider());
    }
}

