/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.hbs.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcret.business.hbs.ISourceProvider;
import kd.taxc.tcret.common.enums.TcretTaxSource;
import kd.taxc.tcret.common.utils.HbsUtils;

public class AirWaterSourceProvider
implements ISourceProvider {
    private static final String TCRET_HBS_TAX_SOURCE_INFO = TcretTaxSource.HBSAQ.getEntryEntity();

    @Override
    public List<DynamicObject> query(Long orgId, Date skssqq, Date skssqz, Long taxoffice, Long sbbid) {
        QFilter[] filters = this.buildFilters(orgId, skssqq, skssqz, taxoffice, sbbid);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)TCRET_HBS_TAX_SOURCE_INFO, (String)"id,name,month,number,wrwlb.number,swrzl.number,wrwdls,wrwmc.id", (QFilter[])filters);
        List<Long> ids = HbsUtils.filterPollutionAirWater(objects);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_HBS_TAX_SOURCE_INFO));
        return new ArrayList<DynamicObject>(Arrays.asList(dynamicObjects));
    }

    @Override
    public boolean exists(Long orgId, Date skssqq, Date skssqz, Long taxoffice, Long sbbid) {
        QFilter[] filters = this.buildFilters(orgId, skssqq, skssqz, taxoffice, sbbid);
        return QueryServiceHelper.exists((String)TCRET_HBS_TAX_SOURCE_INFO, (QFilter[])filters);
    }

    private QFilter[] buildFilters(Long orgId, Date skssqq, Date skssqz, Long taxoffice, Long sbbid) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        QFilter q3 = new QFilter("pfksszgswjg", "=", (Object)taxoffice);
        QFilter q4 = new QFilter("wrwlb.number", "in", Arrays.asList("101", "102"));
        QFilter q5 = new QFilter("month", ">=", (Object)skssqq).and("month", "<", (Object)skssqz);
        QFilter q6 = new QFilter("sbbid", "=", (Object)0L).or("sbbid", "=", (Object)sbbid);
        return new QFilter[]{q1, q2, q3, q4, q5, q6};
    }
}

