/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcret.common.utils.DateCheckUtils;
import kd.taxc.tcret.common.utils.YhsUtils;

public class BeforeF7FilterHelper {
    private static final String ORG = "org";
    private static final String DECLARETYPE = "declaretype";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TAX_ITEM = "taxitem";
    private static final String DEDUCTIONCODE = "deductioncode";
    private static final String SUB_TAX_ITEM = "subtaxitem";
    private static final String ACCOUNTORG = "accountorg";
    private static String[] oldTaxItem = new String[]{"001", "002", "003", "004", "005", "006", "007", "008", "009", "010", "011", "012", "013", "014"};
    private static String[] newTaxItem = new String[]{"01001", "01002", "01003", "01004", "01005", "01006", "01007", "01008", "01009", "01010", "01011", "02001", "02002", "02003", "02004", "03001"};

    public static void beforeF7(BeforeF7SelectEvent evt, IFormView view) {
        IDataModel model = view.getModel();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        DynamicObject org = (DynamicObject)model.getValue(ORG);
        String name = evt.getProperty().getName();
        String declaretype = (String)model.getValue(DECLARETYPE);
        Date skssqq = (Date)model.getValue(SKSSQQ);
        Date skssqz = (Date)model.getValue(SKSSQZ);
        switch (name) {
            case "org": {
                TaxResult listTaxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
                listFilterParameter.setFilter(new QFilter("id", "in", listTaxResult.getData()));
                break;
            }
            case "accountorg": {
                BeforeF7FilterHelper.accountOrgFilter(evt, view, org);
                break;
            }
            case "taxitem": {
                BeforeF7FilterHelper.taxItemFilter(evt, view, org, declaretype, skssqq, skssqz);
                break;
            }
            case "subtaxitem": {
                DynamicObject taxitem = (DynamicObject)model.getValue(TAX_ITEM);
                BeforeF7FilterHelper.subTaxItemFilter(evt, view, taxitem);
                break;
            }
            case "deductioncode": {
                BeforeF7FilterHelper.deductionCodeFilter(listFilterParameter, skssqq);
                break;
            }
        }
    }

    public static void accountOrgFilter(BeforeF7SelectEvent evt, IFormView view, DynamicObject org) {
        if (null == org) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7", (String)"BeforeF7FilterHelper_0", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Date now = new Date();
        List accountOrgs = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(org.getLong("id")), (Date)now, (Date)now);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)accountOrgs));
    }

    public static void taxItemFilter(BeforeF7SelectEvent evt, IFormView view, DynamicObject org, String declaretype, Date skssqq, Date skssqz) {
        if (null == org) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7", (String)"BeforeF7FilterHelper_0", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DateProp skssqqProp = (DateProp)view.getModel().getProperty(SKSSQQ);
        boolean mustInput = skssqqProp.isMustInput();
        if (mustInput && (null == skssqq || null == skssqz)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u7a0e\u671f", (String)"BeforeF7FilterHelper_1", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if ("aqsb".equals(declaretype)) {
            if (!DateCheckUtils.checkDate(skssqq, skssqz, view)) {
                evt.setCancel(true);
                return;
            }
            List<DynamicObject> taxList = YhsUtils.queryYhsEntity(org.getLong("id"), skssqq, skssqz, declaretype);
            if (EmptyCheckUtils.isEmpty(taxList)) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u672a\u7ef4\u62a4\u5370\u82b1\u7a0e\u7a0e\u76ee\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"BeforeF7FilterHelper_2", (String)"taxc-tcret", (Object[])new Object[0]), org.getString("name")));
                evt.setCancel(true);
            } else {
                List taxRateIdList = taxList.stream().map(v -> v.getDynamicObject("taxrate").getLong("id")).collect(Collectors.toList());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", taxRateIdList));
            }
        } else {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            if (skssqq != null && Objects.requireNonNull(YhsUtils.YHS_NEW_VERSION_DATE).compareTo(skssqq) > 0) {
                listFilterParameter.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("number", "in", (Object)oldTaxItem)}));
            } else {
                listFilterParameter.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("number", "in", (Object)newTaxItem)}));
            }
        }
    }

    public static void subTaxItemFilter(BeforeF7SelectEvent evt, IFormView view, DynamicObject taxitem) {
        if (taxitem == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u76ee", (String)"BeforeF7FilterHelper_3", (String)"taxc-tcret", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("parent.number", "=", (Object)taxitem.getString("number")));
    }

    public static void deductionCodeFilter(ListFilterParameter listFilterParameter, Date skssqq) {
        if (skssqq != null && Objects.requireNonNull(YhsUtils.YHS_NEW_VERSION_DATE).compareTo(skssqq) < 0) {
            listFilterParameter.getQFilters().add(new QFilter("number", "!=", (Object)"09129906"));
        }
    }
}

