/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcret.business.taxsource.detail.TaxSourceDetailService;
import kd.taxc.tcret.business.taxsource.detail.TaxSourceDetailServiceFactory;
import kd.taxc.tcret.common.enums.TcretTaxTypeEnum;

public class CcxwsTaxSourceDetailServiceHelper {
    public static Map<String, List<Map<String, Object>>> getTaxSourceDetailBySbbId(Long sbbId) {
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>();
        DynamicObjectCollection tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid,taxtype", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(sbbId))});
        Set taxTypeSet = tcretCcxwsZbs.stream().map(a -> a.getString("taxtype")).collect(Collectors.toSet());
        for (String taxType : taxTypeSet) {
            String key = TcretTaxTypeEnum.getTaxtypeByCategoryName(taxType);
            TaxSourceDetailService taxSourceDetailService = TaxSourceDetailServiceFactory.createService(key);
            if (taxSourceDetailService == null) continue;
            Map<String, List<Map<String, Object>>> listMap = taxSourceDetailService.queryTaxSourceDetailBySbbId(sbbId);
            data.putAll(listMap);
        }
        return data;
    }
}

