/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class TcwatSourceServiceHelper {
    private static BigDecimal zero = BigDecimal.ZERO;
    private static BigDecimal max = new BigDecimal(Long.MAX_VALUE);

    public static BigDecimal calculateYnseForA(DynamicObject taxsource, BigDecimal sqljqsl, BigDecimal bqqsl) {
        List<DynamicObject> objects = TcwatSourceServiceHelper.calculateWaterResourceDetails(0L, taxsource, sqljqsl, bqqsl);
        BigDecimal ynse = BigDecimal.ZERO;
        for (DynamicObject object : objects) {
            ynse = BigDecimalUtil.addObject((Object)ynse, (Object)object.getBigDecimal("gqjse"));
        }
        return ynse;
    }

    public static BigDecimal calculateYnseForB(DynamicObject zszmConfig, BigDecimal bqqsl) {
        BigDecimal syse = zszmConfig != null ? zszmConfig.getBigDecimal("taxamount") : BigDecimal.ZERO;
        BigDecimal lossrate = zszmConfig != null ? zszmConfig.getBigDecimal("lossrate") : BigDecimal.ZERO;
        BigDecimal calsource = BigDecimalUtil.multiplyObject((Object)bqqsl, (Object)BigDecimalUtil.subtractObject((Object)BigDecimal.ONE, (Object)lossrate), (int)2, (int)4);
        return BigDecimalUtil.multiplyObject((Object)calsource, (Object)syse, (int)2, (int)4);
    }

    public static List<DynamicObject> calculateWaterResourceDetails(Long sbbid, DynamicObject taxsource, BigDecimal sqljqsl, BigDecimal bqqsl) {
        BigDecimal sysl = taxsource.getBigDecimal("sysl");
        ArrayList<DynamicObject> details = new ArrayList<DynamicObject>();
        if ("0".equals(taxsource.getString("qsxkzt"))) {
            DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"tcwat_source_detail_tp");
            detail.set("sbbid", (Object)sbbid);
            detail.set("qslqjxx", (Object)zero);
            detail.set("qslqjsx", (Object)zero);
            detail.set("sysl", (Object)sysl);
            BigDecimal wblqszjs = taxsource.getBigDecimal("wblqszjs");
            detail.set("wblbsjs", (Object)wblqszjs);
            detail.set("bqqsqgjl", (Object)bqqsl);
            detail.set("gqjse", (Object)BigDecimalUtil.setScale((Object)sysl.multiply(wblqszjs).multiply(bqqsl), (int)2));
            details.add(detail);
        } else {
            BigDecimal qslStart = zero;
            BigDecimal jhnqsl = taxsource.getBigDecimal("jhnqsl");
            BigDecimal bqljqsl = BigDecimalUtil.addObject((Object)sqljqsl, (Object)bqqsl);
            BigDecimal qslEnd = jhnqsl;
            BigDecimal bqqsqgjl = TcwatSourceServiceHelper.calBqqsqgjl(qslStart, qslEnd, sqljqsl, bqljqsl);
            BigDecimal bl = BigDecimal.ONE;
            details.add(TcwatSourceServiceHelper.createDetailRow(sbbid, qslStart, qslEnd, sysl, bl, bqqsqgjl));
            DynamicObjectCollection entryentity = taxsource.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                BigDecimal cjhbbs1 = entry.getBigDecimal("cjhbbs1");
                BigDecimal qslcjhbl = entry.getBigDecimal("qslcjhbl");
                bl = entry.getBigDecimal("cjhbbs2");
                qslStart = qslEnd;
                qslEnd = BigDecimalUtil.addObject((Object)jhnqsl.multiply(qslcjhbl), (Object)jhnqsl);
                bqqsqgjl = TcwatSourceServiceHelper.calBqqsqgjl(qslStart, qslEnd, sqljqsl, bqljqsl);
                details.add(TcwatSourceServiceHelper.createDetailRow(sbbid, qslStart, qslEnd, sysl, cjhbbs1, bqqsqgjl));
            }
            bqqsqgjl = TcwatSourceServiceHelper.calBqqsqgjl(qslEnd, max, sqljqsl, bqljqsl);
            details.add(TcwatSourceServiceHelper.createDetailRow(sbbid, qslEnd, zero, sysl, bl, bqqsqgjl));
        }
        return details;
    }

    public static List<DynamicObject> calculateWaterResourceDetails(Long sbbid, DynamicObject waterResource) {
        DynamicObject taxsource = BusinessDataServiceHelper.loadSingle((Object)waterResource.getLong("taxsource_id"), (String)"tdm_water_source_dj");
        BigDecimal sqljqsl = waterResource.getBigDecimal("sqljqsl");
        BigDecimal bqqsl = waterResource.getBigDecimal("bqqsl");
        return TcwatSourceServiceHelper.calculateWaterResourceDetails(sbbid, taxsource, sqljqsl, bqqsl);
    }

    private static DynamicObject createDetailRow(Long sbbid, BigDecimal qslqjxx, BigDecimal qslqjsx, BigDecimal sysl, BigDecimal wblbsjs, BigDecimal bqqsqgjl) {
        DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"tcwat_source_detail_tp");
        detail.set("sbbid", (Object)sbbid);
        detail.set("qslqjxx", (Object)qslqjxx);
        detail.set("qslqjsx", (Object)qslqjsx);
        detail.set("sysl", (Object)sysl);
        detail.set("wblbsjs", (Object)wblbsjs);
        detail.set("bqqsqgjl", (Object)bqqsqgjl);
        detail.set("gqjse", (Object)BigDecimalUtil.setScale((Object)sysl.multiply(wblbsjs).multiply(bqqsqgjl), (int)2));
        return detail;
    }

    private static BigDecimal calBqqsqgjl(BigDecimal qslStart, BigDecimal qslEnd, BigDecimal sqljqsl, BigDecimal bqljqsl) {
        if (qslEnd.compareTo(sqljqsl) < 0 || qslStart.compareTo(bqljqsl) > 0) {
            return zero;
        }
        BigDecimal start = BigDecimalUtil.max((Object)qslStart, (Object)sqljqsl);
        BigDecimal end = BigDecimalUtil.min((Object)qslEnd, (Object)bqljqsl);
        return BigDecimalUtil.subtractObject((Object)end, (Object)start);
    }

    public static DynamicObject getZszmConfig(DynamicObject zszm, DynamicObject taxsource) {
        if (zszm != null && taxsource != null) {
            taxsource = BusinessDataServiceHelper.loadSingle((Object)taxsource.getPkValue(), (String)taxsource.getDataEntityType().getName());
            DynamicObjectCollection entryentity1 = taxsource.getDynamicObjectCollection("entryentity1");
            for (DynamicObject object : entryentity1) {
                if (zszm.getLong("id") != object.getDynamicObject("zszm").getLong("id")) continue;
                return object;
            }
        }
        return null;
    }
}

