/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.detail.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.admindivision.AdminDivisionDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.taxsource.detail.impl.AbstractTaxSourceDetailServiceImpl;
import org.apache.commons.collections4.CollectionUtils;

public class FcsTaxSourceDetailServiceImpl
extends AbstractTaxSourceDetailServiceImpl {
    private static Log logger = LogFactory.getLog(FcsTaxSourceDetailServiceImpl.class);
    private static final String TCRET_PBT_FCS_HIRE_SUM = "tcret_pbt_fcs_hire_sum";
    private static final String TCRET_PBT_FCS_HIRE_SUM_COMBINE = "tcret_pbt_fcs_hire_sum_combine";
    private static final String TCRET_PBT_FCS_PRICE_SUM = "tcret_pbt_fcs_price_sum";
    private static final String TCRET_PBT_FCS_PRICE_SUM_COMBINE = "tcret_pbt_fcs_price_sum_combine";
    private static final String FCS_HIRE_ENTRYENTITY = "rententryentity,entryentity";
    private static final String FCS_PRICE_ENTRYENTITY = "entryentity";
    private static final String FCS_HIRE_FIELDS = "taxauthority.name";
    private static final String FCS_PRICE_FIELDS = "sourceid.location,sourceid.detailaddr,sourceid.changedate,taxauthority.name";
    private static final String ENTITYFIELDS = "jmcode.name,jmcode.number,jmcode.secondcode";

    @Override
    public Map<String, List<Map<String, Object>>> queryTaxSourceDetailBySbbId(Long sbbId) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(8);
        if (sbbId == null || sbbId == 0L) {
            return map;
        }
        DynamicObjectCollection fcsCzCollectionIds = QueryServiceHelper.query((String)TCRET_PBT_FCS_HIRE_SUM, (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        DynamicObject[] fcsCzCollection = BusinessDataServiceHelper.load((Object[])fcsCzCollectionIds.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCRET_PBT_FCS_HIRE_SUM));
        this.queryFcsCzDetail(map, fcsCzCollection);
        DynamicObjectCollection fcsCjCollectionIds = QueryServiceHelper.query((String)TCRET_PBT_FCS_PRICE_SUM, (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        DynamicObject[] fcsCjCollection = BusinessDataServiceHelper.load((Object[])fcsCjCollectionIds.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCRET_PBT_FCS_PRICE_SUM));
        this.queryFcsCjDetail(map, fcsCjCollection, fcsCzCollection);
        logger.info("\u623f\u4ea7\u7a0e\u7a0e\u6e90\u660e\u7ec6\uff1a" + SerializationUtils.toJsonString(map));
        return map;
    }

    private void queryFcsCjDetail(Map<String, List<Map<String, Object>>> map, DynamicObject[] fcsCjCollection, DynamicObject[] fcsCzCollection) {
        if (fcsCjCollection.length > 0) {
            List fcsCjDetailList = Arrays.stream(fcsCjCollection).filter(c -> !c.getBoolean("isxgm")).collect(Collectors.toList());
            List xgmfcsCjDetailList = Arrays.stream(fcsCjCollection).filter(c -> c.getBoolean("isxgm")).collect(Collectors.toList());
            Map<String, BigDecimal> xgmfcsCjDetailMap = Arrays.stream(fcsCjCollection).filter(c -> c.getBoolean("isxgm")).collect(Collectors.toMap(k -> k.getString("number") + DateUtils.format((Date)k.getDate("skssqq")) + DateUtils.format((Date)k.getDate("skssqz")), v -> v.getBigDecimal("currentjmamount")));
            List locationIds = fcsCjDetailList.stream().map(a -> a.getLong("sourceid.location")).collect(Collectors.toList());
            Map locationMap = new HashMap();
            TaxResult taxResult = AdminDivisionDataServiceHelper.getPathNameByIds(locationIds);
            if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                locationMap = (Map)taxResult.getData();
            }
            ArrayList<HashMap<String, Object>> fcsCjData = new ArrayList<HashMap<String, Object>>(8);
            for (DynamicObject obj : fcsCjDetailList) {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                this.putPropertyMap(obj, temp, FCS_PRICE_ENTRYENTITY, FCS_PRICE_FIELDS, ENTITYFIELDS);
                if (!xgmfcsCjDetailMap.isEmpty()) {
                    BigDecimal jmamount = obj.getBigDecimal("currentjmamount");
                    jmamount = jmamount.add(xgmfcsCjDetailMap.getOrDefault(obj.getString("number") + DateUtils.format((Date)obj.getDate("skssqq")) + DateUtils.format((Date)obj.getDate("skssqz")), BigDecimal.ZERO));
                    temp.put("currentjmamount", jmamount.toPlainString());
                }
                BigDecimal hireArea = this.getFcsHireArea(fcsCzCollection, obj.getString("number"), obj.getDate("skssqq"), obj.getDate("skssqz"));
                temp.put("rentalarea", hireArea.toPlainString());
                fcsCjData.add(temp);
            }
            map.put(TCRET_PBT_FCS_PRICE_SUM, fcsCjData);
            Map<String, List<DynamicObject>> fcsCjMapByNumber = fcsCjDetailList.stream().collect(Collectors.groupingBy(a -> a.getString("number")));
            Map<String, List<DynamicObject>> xgmfcsCjMapByNumber = xgmfcsCjDetailList.stream().collect(Collectors.groupingBy(a -> a.getString("number")));
            ArrayList<HashMap<String, Object>> fcsCjSumData = new ArrayList<HashMap<String, Object>>(8);
            for (Map.Entry<String, List<DynamicObject>> entry : fcsCjMapByNumber.entrySet()) {
                List<DynamicObject> dynamicObjects = entry.getValue();
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                if (!CollectionUtils.isNotEmpty(dynamicObjects)) continue;
                this.putPropertyMap(dynamicObjects.get(0), temp, FCS_PRICE_ENTRYENTITY, FCS_PRICE_FIELDS, ENTITYFIELDS);
                if (locationMap.get(dynamicObjects.get(0).getLong("sourceid.location")) != null) {
                    List list = (List)locationMap.get(dynamicObjects.get(0).getLong("sourceid.location"));
                    if (list != null) {
                        temp.put("locationxzqh", list.size() > 3 ? list.subList(0, 3).stream().collect(Collectors.joining()) : list.stream().collect(Collectors.joining()));
                        temp.put("locationscjx", list.size() > 3 ? list.get(3) : "");
                    } else {
                        temp.put("locationxzqh", "");
                        temp.put("locationscjx", "");
                    }
                }
                BigDecimal currentpayable = BigDecimal.ZERO;
                BigDecimal currentjmamount = BigDecimal.ZERO;
                BigDecimal paidtaxes = BigDecimal.ZERO;
                BigDecimal ybtse = BigDecimal.ZERO;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    currentpayable = currentpayable.add(dynamicObject.getBigDecimal("currentpayable"));
                    currentjmamount = currentjmamount.add(dynamicObject.getBigDecimal("currentjmamount"));
                    paidtaxes = paidtaxes.add(dynamicObject.getBigDecimal("paidtaxes"));
                    ybtse = ybtse.add(dynamicObject.getBigDecimal("ybtse"));
                }
                List skssqqList = dynamicObjects.stream().filter(a -> a.getDate("skssqq") != null).map(a -> a.getDate("skssqq")).collect(Collectors.toList());
                List skssqzList = dynamicObjects.stream().filter(a -> a.getDate("skssqz") != null).map(a -> a.getDate("skssqz")).collect(Collectors.toList());
                temp.put("skssqq", Collections.min(skssqqList));
                temp.put("skssqz", Collections.max(skssqzList));
                BigDecimal xgmjmamountsum = xgmfcsCjMapByNumber.get(dynamicObjects.get(0).getString("number")) != null ? xgmfcsCjMapByNumber.get(dynamicObjects.get(0).getString("number")).stream().map(a -> a.getBigDecimal("currentjmamount")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                currentjmamount = currentjmamount.add(xgmjmamountsum);
                temp.put("currentpayable", currentpayable.toPlainString());
                temp.put("currentjmamount", currentjmamount.toPlainString());
                temp.put("paidtaxes", paidtaxes.toPlainString());
                temp.put("ybtse", ybtse.toPlainString());
                fcsCjSumData.add(temp);
            }
            map.put(TCRET_PBT_FCS_PRICE_SUM_COMBINE, fcsCjSumData);
        }
    }

    private void queryFcsCzDetail(Map<String, List<Map<String, Object>>> map, DynamicObject[] fcsCzCollection) {
        List<String> numberList = Arrays.stream(fcsCzCollection).map(a -> a.getString("number")).collect(Collectors.toList());
        ArrayList<Long> locationIdList = new ArrayList<Long>();
        Map<String, Map<String, Object>> fcsInfoNumberMap = this.getFcsInfoMapByNumber(numberList, locationIdList);
        if (fcsCzCollection.length > 0) {
            List fcsCzDetailList = Arrays.stream(fcsCzCollection).filter(c -> !c.getBoolean("isxgm")).collect(Collectors.toList());
            List xgmfcsCzDetailList = Arrays.stream(fcsCzCollection).filter(c -> c.getBoolean("isxgm")).collect(Collectors.toList());
            Map<String, BigDecimal> xgmfcsCzDetailMap = Arrays.stream(fcsCzCollection).filter(c -> c.getBoolean("isxgm")).collect(Collectors.toMap(k -> k.getString("number") + DateUtils.format((Date)k.getDate("skssqq")) + DateUtils.format((Date)k.getDate("skssqz")), v -> v.getBigDecimal("currentjmamount")));
            Map locationMap = new HashMap();
            TaxResult taxResult = AdminDivisionDataServiceHelper.getPathNameByIds(locationIdList);
            if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                locationMap = (Map)taxResult.getData();
            }
            ArrayList<HashMap<String, Object>> fcsCzData = new ArrayList<HashMap<String, Object>>(8);
            for (DynamicObject obj : fcsCzDetailList) {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                this.putPropertyMap(obj, temp, FCS_HIRE_ENTRYENTITY, FCS_HIRE_FIELDS, ENTITYFIELDS);
                Map<String, Object> objectMap = fcsInfoNumberMap.get(obj.getString("number"));
                if (objectMap != null) {
                    temp.put("sourceidfixassertnumber", objectMap.get("sourceidfixassertnumber"));
                    temp.put("sourceidassertvalue", objectMap.get("sourceidassertvalue"));
                    temp.put("sourceidlocation", objectMap.get("sourceidlocation"));
                    temp.put("sourceiddetailaddr", objectMap.get("sourceiddetailaddr"));
                    temp.put("rentalvalue", objectMap.get("sourceidhireassertvalue"));
                }
                if (xgmfcsCzDetailMap != null) {
                    BigDecimal jmamount = obj.getBigDecimal("currentjmamount");
                    jmamount = jmamount.add(xgmfcsCzDetailMap.getOrDefault(obj.getString("number") + DateUtils.format((Date)obj.getDate("skssqq")) + DateUtils.format((Date)obj.getDate("skssqz")), BigDecimal.ZERO));
                    temp.put("currentjmamount", jmamount.toPlainString());
                }
                fcsCzData.add(temp);
            }
            map.put(TCRET_PBT_FCS_HIRE_SUM, fcsCzData);
            Map<String, List<DynamicObject>> fcsCzMapByNumber = fcsCzDetailList.stream().collect(Collectors.groupingBy(a -> a.getString("number")));
            Map<String, List<DynamicObject>> xgmfcsCzMapByNumber = xgmfcsCzDetailList.stream().collect(Collectors.groupingBy(a -> a.getString("number")));
            ArrayList<HashMap<String, Object>> fcsCzSumData = new ArrayList<HashMap<String, Object>>(8);
            for (Map.Entry<String, List<DynamicObject>> entry : fcsCzMapByNumber.entrySet()) {
                List<DynamicObject> dynamicObjects = entry.getValue();
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                if (!EmptyCheckUtils.isNotEmpty(dynamicObjects)) continue;
                this.putPropertyMap(dynamicObjects.get(0), temp, FCS_HIRE_ENTRYENTITY, FCS_HIRE_FIELDS, ENTITYFIELDS);
                BigDecimal currentpayable = BigDecimal.ZERO;
                BigDecimal currentjmamount = BigDecimal.ZERO;
                BigDecimal currental = BigDecimal.ZERO;
                BigDecimal paidtaxes = BigDecimal.ZERO;
                BigDecimal ybtse = BigDecimal.ZERO;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    currentpayable = currentpayable.add(dynamicObject.getBigDecimal("currentpayable"));
                    currentjmamount = currentjmamount.add(dynamicObject.getBigDecimal("currentjmamount"));
                    currental = currental.add(dynamicObject.getBigDecimal("currental"));
                    paidtaxes = paidtaxes.add(dynamicObject.getBigDecimal("paidtaxes"));
                    ybtse = ybtse.add(dynamicObject.getBigDecimal("ybtse"));
                }
                List skssqqList = dynamicObjects.stream().filter(a -> a.getDate("skssqq") != null).map(a -> a.getDate("skssqq")).collect(Collectors.toList());
                List skssqzList = dynamicObjects.stream().filter(a -> a.getDate("skssqz") != null).map(a -> a.getDate("skssqz")).collect(Collectors.toList());
                temp.put("skssqq", Collections.min(skssqqList));
                temp.put("skssqz", Collections.max(skssqzList));
                BigDecimal xgmjmamountsum = xgmfcsCzMapByNumber.get(dynamicObjects.get(0).getString("number")) != null ? xgmfcsCzMapByNumber.get(dynamicObjects.get(0).getString("number")).stream().map(a -> a.getBigDecimal("currentjmamount")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add) : BigDecimal.ZERO;
                currentjmamount = currentjmamount.add(xgmjmamountsum);
                temp.put("currentpayable", currentpayable.toPlainString());
                temp.put("currentjmamount", currentjmamount.toPlainString());
                temp.put("currental", currental.toPlainString());
                temp.put("paidtaxes", paidtaxes.toPlainString());
                temp.put("ybtse", ybtse.toPlainString());
                Map<String, Object> objectMap = fcsInfoNumberMap.get(dynamicObjects.get(0).getString("number"));
                if (objectMap != null) {
                    List list = (List)locationMap.get(objectMap.get("sourceidlocation"));
                    if (list != null) {
                        temp.put("locationxzqh", list.size() > 3 ? list.subList(0, 3).stream().collect(Collectors.joining()) : list.stream().collect(Collectors.joining()));
                        temp.put("locationscjx", list.size() > 3 ? list.get(3) : "");
                    } else {
                        temp.put("locationxzqh", "");
                        temp.put("locationscjx", "");
                    }
                    temp.put("rentalvalue", objectMap.get("sourceidhireassertvalue"));
                    temp.put("sourceidfixassertnumber", objectMap.get("sourceidfixassertnumber"));
                    temp.put("sourceidassertvalue", objectMap.get("sourceidassertvalue"));
                    temp.put("sourceidlocation", objectMap.get("sourceidlocation"));
                    temp.put("sourceiddetailaddr", objectMap.get("sourceiddetailaddr"));
                }
                fcsCzSumData.add(temp);
            }
            map.put(TCRET_PBT_FCS_HIRE_SUM_COMBINE, fcsCzSumData);
        }
    }

    @Override
    protected void dealField(DynamicObject obj, Map<String, Object> temp, String fields) {
        String[] fieldList;
        for (String field : fieldList = fields.split(",")) {
            if (!obj.containsProperty(field.split("\\.")[0])) continue;
            if ("sourceid.changedate".equals(field)) {
                temp.put(field.replace(".", ""), DateUtils.format((Date)obj.getDate(field)));
                continue;
            }
            temp.put(field.replace(".", ""), obj.getString(field));
        }
    }

    private Map<String, Map<String, Object>> getFcsInfoMapByNumber(List<String> numberList, List<Long> locationIdList) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(8);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tdm_fcs_basic_info", (String)"number,fixassertnumber,assertvalue,location,detailaddr,hireassertvalue,bgentryentity,bgentryentity.bgdate,bgentryentity.bghireassertvalue", (QFilter[])new QFilter[]{new QFilter("number", "in", numberList)});
        List locationIds = Arrays.stream(dynamicObjects).map(a -> a.getLong("location")).collect(Collectors.toList());
        locationIdList.addAll(locationIds);
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>(8);
            objectMap.put("sourceidfixassertnumber", dynamicObject.getString("fixassertnumber"));
            objectMap.put("sourceidassertvalue", dynamicObject.getBigDecimal("assertvalue").toPlainString());
            objectMap.put("sourceidlocation", dynamicObject.getLong("location"));
            objectMap.put("sourceiddetailaddr", dynamicObject.getString("detailaddr"));
            DynamicObjectCollection bgentryentity = dynamicObject.getDynamicObjectCollection("bgentryentity");
            if (bgentryentity.size() > 0) {
                List bgdateList = bgentryentity.stream().sorted(Comparator.comparing(s -> s.getDate("bgdate")).reversed()).collect(Collectors.toList());
                objectMap.put("sourceidhireassertvalue", ((DynamicObject)bgdateList.get(0)).getBigDecimal("bghireassertvalue").toPlainString());
            } else {
                objectMap.put("sourceidhireassertvalue", dynamicObject.getBigDecimal("hireassertvalue").toPlainString());
            }
            map.put(dynamicObject.getString("number"), objectMap);
        }
        return map;
    }

    private BigDecimal getFcsHireArea(DynamicObject[] fcsCzCollection, String number, Date skssqq, Date skssqz) {
        List fcsObjs;
        BigDecimal result = BigDecimal.ZERO;
        if (number != null && (fcsObjs = Arrays.stream(fcsCzCollection).filter(s -> number.equals(s.getString("number"))).collect(Collectors.toList())).size() > 0) {
            for (DynamicObject fcsCzObj : fcsObjs) {
                BigDecimal fcsCzObjResult = BigDecimal.ZERO;
                DynamicObjectCollection rententryentity = fcsCzObj.getDynamicObjectCollection("rententryentity");
                if (rententryentity.size() <= 0 || skssqq == null) continue;
                fcsCzObjResult = rententryentity.stream().filter(a -> a.getDate("startdate") != null && !DateUtils.checkTimeRepeat((Date)a.getDate("startdate"), (Date)a.getDate("enddate"), (Date)skssqq, (Date)skssqz)).map(a -> a.getBigDecimal("hirearea")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                result = result.add(fcsCzObjResult);
            }
        }
        return result;
    }
}

