/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.egine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcret.business.taxsource.HouseRentServiceHelper;
import kd.taxc.tcret.business.taxsource.task.AccountDetailTask;
import kd.taxc.tcret.common.utils.HouseRentEngineUtils;

public class HouseRentAutoCollectEngine
implements IEngine<EngineModel> {
    private static final String TDM_HOUSE_RENTAL_INFO = "tdm_house_rental_info";
    private static final String TCRET_ZJCJ_ACCDET = "tcret_zjcj_accdet";
    private static final String MONTH = "month";
    private static final String SEASON = "season";
    private static final String YEAR = "year";
    private static final String HALF_YEAR = "halfyear";
    private static final int MONTH_VALUE = 1;
    private static final int SEASON_VALUE = 3;
    private static final int YEAR_VALUE = 12;
    private static final int HALF_YEAR_VALUE = 6;
    private static final int DEFAULT_VALUE = 0;
    private static final int HALF_MONTH_VALUE = 15;
    private static final int MINUS_HALF_MONTH_VALUE = -15;
    private static Log logger = LogFactory.getLog(HouseRentAutoCollectEngine.class);

    public void deleteData(EngineModel model) {
    }

    public void runEngine(EngineModel engineModel) {
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u623f\u4ea7\u51fa\u79df\u53f0\u8d26\u5f15\u64ce");
            long start = System.currentTimeMillis();
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            ConcurrentHashMap<String, Map<String, Object>> errorMap = new ConcurrentHashMap<String, Map<String, Object>>();
            ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
            this.calSummaryAccountList(summaryList, summaryAccountingList, errorMap, dataMap, engineModel);
            SaveServiceHelper.save((DynamicObject[])summaryAccountingList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
            logger.info("\u7ed3\u675f\u6267\u884c\u623f\u4ea7\u51fa\u79df\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void calSummaryAccountList(List<DynamicObject> summaryList, List<DynamicObject> summaryAccountingList, Map<String, Map<String, Object>> errorMap, Map<String, String> dataMap, EngineModel engineModel) throws Exception {
        Date startdate = DateUtils.stringToDate((String)engineModel.getStartDate());
        Date enddate = DateUtils.stringToDate((String)engineModel.getEndDate());
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(engineModel.getOrgId()));
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        QFilter q3 = null;
        if (EmptyCheckUtils.isNotEmpty(engineModel.getCustom().get("taxauthority"))) {
            q3 = new QFilter("taxauthority", "=", engineModel.getCustom().get("taxauthority"));
        }
        List houseRentalIds = QueryServiceHelper.queryPrimaryKeys((String)TDM_HOUSE_RENTAL_INFO, (QFilter[])new QFilter[]{q1, q2, q3}, null, (int)-1);
        DynamicObject[] summarys = BusinessDataServiceHelper.load((Object[])houseRentalIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TDM_HOUSE_RENTAL_INFO));
        Map<Long, List<DynamicObject>> ruleMap = HouseRentServiceHelper.fetchRules(houseRentalIds, Long.parseLong(engineModel.getOrgId()));
        for (int i = 0; i < summarys.length; ++i) {
            DynamicObject dynamicObject;
            DynamicObject summary = summarys[i];
            Long fcsRentalId = summary.getLong("id");
            int gatherStatus = HouseRentServiceHelper.getGatherStatus(ruleMap, fcsRentalId, startdate, enddate);
            if (gatherStatus != 0) continue;
            long rentid = DBUtils.getLongId((String)"t_tdm_house_rental_entity");
            DynamicObjectCollection rententryentityCollection = summary.getDynamicObjectCollection("rententryentity");
            DynamicObject rententryentity = rententryentityCollection.addNew();
            rententryentity.set("id", (Object)rentid);
            rententryentity.set("modifiername", (Object)RequestContext.get().getCurrUserId());
            rententryentity.set("modifydatetime", (Object)new Date());
            rententryentity.set("hirearea", (Object)this.findarea(fcsRentalId, DateUtils.stringToDate((String)engineModel.getStartDate())));
            rententryentity.set("startdate", (Object)startdate);
            rententryentity.set("enddate", (Object)enddate);
            String operateName = ResManager.loadKDString((String)"\u786e\u5b9a", (String)"HouseRentAutoCollectEngine_0", (String)"taxc-tdm-formplugin", (Object[])new Object[0]);
            String operateDescription = String.format(ResManager.loadKDString((String)"\u5c5e\u671f%1$s\u81f3%2$s,\u623f\u4ea7\u7f16\u53f7%3$s,\u79df\u8d41\u9879\u76ee\u7f16\u53f7%4$s\u79df\u91d1\u91c7\u96c6\u6210\u529f", (String)"HouseRentAutoCollectEngine_1", (String)"taxc-tdm-formplugin", (Object[])new Object[0]), DateUtils.format((Date)startdate), DateUtils.format((Date)enddate), summary.getString("number"), summary.getString("leasecontractno"));
            OperatorDialogUtils.operateDialog((String)"ccxws", (String)"tcret_house_autocollect", (String)operateName, (String)operateDescription);
            rententryentity.set("houserentalinfo", (Object)fcsRentalId);
            rententryentity.set("accountorg", (Object)Long.valueOf(engineModel.getOrgId()));
            List<DynamicObject> rules = ruleMap.get(summary.getLong("id"));
            for (DynamicObject rule : rules) {
                AccountDetailTask ruleSettingTask = new AccountDetailTask(dataMap, errorMap, rule, engineModel, (DynamicObjectCollection)rule.get("entryentity"), fcsRentalId.toString(), TCRET_ZJCJ_ACCDET, String.valueOf(rentid), rule.getDataEntityType().getName(), null, DeclareTaxType.FCS.getBaseTaxId(), null);
                List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                List accountingList = EngineTask.getFutureList((List)futures);
                summaryAccountingList.addAll(accountingList);
                BigDecimal amount = this.getAccountingAmount(accountingList);
                BigDecimal sumAmount = rententryentity.getBigDecimal("rentincome").add(amount);
                rententryentity.set("rentincome", (Object)sumAmount);
            }
            BigDecimal rentincome = rententryentity.getBigDecimal("rentincome");
            String limit = summary.getString("fcsbyhirelimit");
            int taxLimitNo = this.getTaxLimitNo(limit);
            int monthNo = this.getMonthNo(startdate, enddate);
            BigDecimal eachincome = BigDecimal.ZERO;
            if (rentincome.compareTo(BigDecimal.ZERO) > 0 && taxLimitNo > 0) {
                eachincome = HouseRentEngineUtils.getEachIncome(rentincome, monthNo, taxLimitNo);
            }
            rententryentity.set("rentmonth", (Object)monthNo);
            rententryentity.set("eachrentincome", (Object)eachincome);
            DynamicObjectCollection subentryentityCollection = rententryentity.getDynamicObjectCollection("subentryentity");
            List<String> allSkssq = HouseRentEngineUtils.getAllSkssq(limit, startdate, enddate);
            if (allSkssq.size() == 1) {
                dynamicObject = subentryentityCollection.addNew();
                dynamicObject.set("skperiod", (Object)allSkssq.get(0));
                dynamicObject.set("rental", (Object)eachincome);
            } else if (allSkssq.size() == 2) {
                dynamicObject = subentryentityCollection.addNew();
                BigDecimal firstPeriodMonth = BigDecimal.valueOf(HouseRentEngineUtils.getFirstMonthNum(limit, startdate));
                BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)rentincome.multiply(firstPeriodMonth), (Object)monthNo, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)rentincome.multiply(firstPeriodMonth), (Object)monthNo, (int)2);
                dynamicObject.set("skperiod", (Object)allSkssq.get(0));
                dynamicObject.set("rental", (Object)firstPeriodAmount);
                dynamicObject = subentryentityCollection.addNew();
                dynamicObject.set("skperiod", (Object)allSkssq.get(1));
                dynamicObject.set("rental", (Object)rentincome.subtract(firstPeriodAmount));
            } else {
                for (int row = 0; row < allSkssq.size(); ++row) {
                    BigDecimal eachIncome;
                    DynamicObject dynamicObject2 = subentryentityCollection.addNew();
                    if (row == allSkssq.size() - 1) {
                        BigDecimal lastPeriodAmount;
                        BigDecimal firstPeriodMonth = BigDecimal.valueOf(HouseRentEngineUtils.getFirstMonthNum(limit, startdate));
                        BigDecimal firstPeriodAmount = BigDecimalUtil.divideObject((Object)rentincome.multiply(firstPeriodMonth), (Object)monthNo, (int)2) == null ? BigDecimal.ZERO : BigDecimalUtil.divideObject((Object)rentincome.multiply(firstPeriodMonth), (Object)monthNo, (int)2);
                        eachIncome = eachincome != null ? (lastPeriodAmount = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.subtractObject((Object)rentincome, (Object)eachincome.multiply(new BigDecimal(allSkssq.size() - 2))), (Object)firstPeriodAmount)) : BigDecimal.ZERO;
                        ((DynamicObject)subentryentityCollection.get(0)).set("rental", (Object)firstPeriodAmount);
                    } else {
                        eachIncome = eachincome;
                    }
                    dynamicObject2.set("skperiod", (Object)allSkssq.get(row));
                    dynamicObject2.set("rental", (Object)eachIncome);
                }
            }
            summaryList.add(summary);
        }
    }

    private String findarea(Long id, Date startdate) {
        QFilter dateFilter = new QFilter("rententryentity.enddate", "<=", (Object)startdate);
        QFilter pkFilter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection object = QueryServiceHelper.query((String)TDM_HOUSE_RENTAL_INFO, (String)"rententryentity.hirearea,rententryentity.startdate,rententryentity.enddate", (QFilter[])new QFilter[]{dateFilter, pkFilter}, (String)"rententryentity.enddate desc", (int)1);
        if (null != object && !object.isEmpty()) {
            return ((DynamicObject)object.get(0)).getString("rententryentity.hirearea");
        }
        return "0";
    }

    private BigDecimal getAccountingAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : accountingList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal("amount"));
        }
        return totalAmount;
    }

    private int getTaxLimitNo(Object taxLimit) {
        if (null == taxLimit) {
            return 0;
        }
        switch ((String)taxLimit) {
            case "month": {
                return 1;
            }
            case "season": {
                return 3;
            }
            case "year": {
                return 12;
            }
            case "halfyear": {
                return 6;
            }
        }
        return 0;
    }

    private int getMonthNo(Date start, Date end) {
        int dateNo = HouseRentEngineUtils.getLocalDate(end).getDayOfMonth() - HouseRentEngineUtils.getLocalDate(start).getDayOfMonth();
        dateNo = dateNo > 15 ? 1 : (dateNo < -15 ? -1 : 0);
        int monthNo = (DateUtils.getYearOfDate((Date)end) - DateUtils.getYearOfDate((Date)start)) * 12 + (DateUtils.getMonthOfDate((Date)end) - DateUtils.getMonthOfDate((Date)start)) + dateNo;
        if (monthNo >= 0) {
            return monthNo;
        }
        return 0;
    }
}

