/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.egine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.account.service.YhsTaxAccountDataService;
import kd.taxc.tcret.business.account.service.YhsTaxAccountDataServiceFactory;
import kd.taxc.tcret.business.dimension.ProvisionDimensionHelper;
import kd.taxc.tcret.common.utils.RuleUtils;

public class YhsTaxSourceGatherEngine
implements IEngine<EngineModel> {
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String TCRET_YSH_TAX_SOURCE_DE = "tcret_ysh_tax_source_de";
    public static final String TCSD_RULE_YSHTPZ = "tcsd_rule_yshtpz";
    public static final String TCSD_RULE_CQZYSJ = "tcsd_rule_cqzysj";
    public static final String TCSD_RULE_ZJZB = "tcsd_rule_zjzb";
    private static final ArrayList<String> RULE_TYPES = Lists.newArrayList((Object[])new String[]{"tcsd_rule_yshtpz", "tcsd_rule_cqzysj", "tcsd_rule_zjzb"});
    public static final String TAX_ITEM = "taxitem";
    public static final String SUB_TAX_ITEM = "subtaxitem";
    public static final String AQHZ = "aqhz";
    public static final String HDZS = "hdzs";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    private static final String ORG = "org";
    private static Log logger = LogFactory.getLog(YhsTaxSourceGatherEngine.class);
    private static final HashMap<String, String> ruleTypeMap = new HashMap();

    public void deleteData(EngineModel model) {
        String orgId = model.getOrgId();
        QFilter orgFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter skssqqzFilter = new QFilter(SKSSQQ, "=", (Object)startDate).and(new QFilter(SKSSQZ, "=", (Object)endDate));
        QFilter datasourceFilter = new QFilter("datasource", "=", (Object)"system");
        Object validcard = model.getCustom().get("validcard");
        if (validcard == null) {
            return;
        }
        List validCards = (List)validcard;
        validCards.forEach(a -> {
            QFilter taxitemFilter = new QFilter(TAX_ITEM, "=", a.get(TAX_ITEM));
            QFilter verifyrateFilter = new QFilter("verifyrate", "=", a.get("hdrate"));
            QFilter taxofficeFilter = new QFilter("taxoffice", "=", a.get("taxoffice"));
            QFilter paytypeFilter = new QFilter("paytype", "=", (Object)"bdjn");
            DynamicObjectCollection query = QueryServiceHelper.query((String)TCRET_YHS_TAX_ACCOUNT, (String)"org,skssqq,skssqz,serialno,taxitem", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, datasourceFilter, taxitemFilter, verifyrateFilter, taxofficeFilter, paytypeFilter});
            if (query.size() > 0) {
                List serialnos = query.stream().map(b -> b.getString("serialno")).collect(Collectors.toList());
                QFilter serialnoQFilter = new QFilter("serialno", "in", serialnos);
                DeleteServiceHelper.delete((String)TCRET_YSH_TAX_SOURCE_DE, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, serialnoQFilter});
                DeleteServiceHelper.delete((String)"tcret_sycj_adjust_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, serialnoQFilter});
            }
            DeleteServiceHelper.delete((String)TCRET_YHS_TAX_ACCOUNT, (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, taxofficeFilter, datasourceFilter, taxitemFilter, verifyrateFilter, paytypeFilter});
        });
    }

    public void runEngine(EngineModel engineModel) {
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u5e94\u7a0e\u53f0\u8d26\u5f15\u64ce");
            long start = System.currentTimeMillis();
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> accountDetailList = new ArrayList<DynamicObject>();
            String orgId = engineModel.getOrgId();
            Object validcard = engineModel.getCustom().get("validcard");
            if (validcard == null) {
                return;
            }
            List validCards = (List)validcard;
            List<DynamicObject> allRules = this.getAllRule(validCards, RULE_TYPES, orgId);
            TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId));
            if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData()) || EmptyCheckUtils.isEmpty((Object)validCards)) {
                return;
            }
            long taxOfficeId = ((DynamicObject)taxResult.getData()).getLong("taxoffice.id");
            engineModel.addCustom("taxoffice", (Object)taxOfficeId);
            String type = ProvisionDimensionHelper.getDimensionType(orgId, DeclareTaxType.YHS.getBaseTaxId(), DateUtils.stringToDate2((String)engineModel.getStartDate()), DateUtils.stringToDate2((String)engineModel.getEndDate()));
            YhsTaxAccountDataService yhsTaxAccountDataService = YhsTaxAccountDataServiceFactory.getService(type);
            Map<String, List<DynamicObject>> taxitemGroup = allRules.stream().collect(Collectors.groupingBy(a -> String.join((CharSequence)"-", a.getString("taxitem.id"), a.getString("taxation"))));
            ConcurrentHashMap<String, Map<String, Object>> errorMap = new ConcurrentHashMap<String, Map<String, Object>>();
            ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
            for (DynamicObject yhsCardItem : validCards) {
                String tation = yhsCardItem.getBoolean("isverify") ? HDZS : AQHZ;
                String join = String.join((CharSequence)"-", yhsCardItem.getString(TAX_ITEM), tation);
                List<DynamicObject> ruleTaxItemList = taxitemGroup.get(join);
                if (CollectionUtils.isEmpty(ruleTaxItemList)) continue;
                for (DynamicObject rule : ruleTaxItemList) {
                    yhsTaxAccountDataService.calculateTaxAccount(errorMap, dataMap, summaryList, accountDetailList, engineModel, rule, TCRET_YSH_TAX_SOURCE_DE, yhsCardItem, DeclareTaxType.YHS.getBaseTaxId());
                }
            }
            SaveServiceHelper.save((DynamicObject[])accountDetailList.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
            logger.info("\u7ed3\u675f\u6267\u884c\u5e94\u7a0e\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<DynamicObject> getAllRule(List<DynamicObject> validCards, ArrayList<String> ruleTypes, String orgId) {
        ArrayList<DynamicObject> allRules = new ArrayList<DynamicObject>(validCards.size() * 4);
        List collect = validCards.stream().map(s -> {
            String taxation = s.getBoolean("isverify") ? HDZS : AQHZ;
            return s.getString("tnumber") + taxation;
        }).collect(Collectors.toList());
        for (String ruleType : ruleTypes) {
            DynamicObjectCollection ruleList = RuleUtils.getRuleList(orgId, "private", ruleType, "nssb");
            ruleList.addAll((Collection)RuleUtils.getPublicRules(orgId, ruleTypeMap.get(ruleType), "nssb"));
            List ids = ruleList.stream().filter(a -> StringUtil.equals((CharSequence)a.getString("enable"), (CharSequence)"1")).filter(a -> {
                String key = a.getString("tnumber") + a.getString("taxation");
                return collect.contains(key);
            }).map(s -> s.getLong("id")).collect(Collectors.toList());
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.stream().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ruleType));
            allRules.addAll(Arrays.stream(load).collect(Collectors.toList()));
        }
        return allRules;
    }

    static {
        ruleTypeMap.put(TCSD_RULE_YSHTPZ, "yshtpz");
        ruleTypeMap.put(TCSD_RULE_CQZYSJ, "cqzysj");
        ruleTypeMap.put(TCSD_RULE_ZJZB, "zjzb");
    }
}

