/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.fcs;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class CjfcyzftConvertBusinessService {
    public static final String ORG = "org";
    public static final String CURRENTPERIOD = "currentperiod";
    public static final String NEXTPERIOD = "nextperiod";
    public static final String MONTHBYMONTH = "monthbymonth";
    public static final List<String> OPERATEKEYS = Arrays.asList("currentperiod", "nextperiod", "monthbymonth");
    public static final int REMARKMAXLENGTH = 50;
    private static final Map<String, String> OPERATEKEYNAME = new HashMap<String, String>(16){
        {
            this.put(CjfcyzftConvertBusinessService.CURRENTPERIOD, ResManager.loadKDString((String)"\u9002\u7528\u5f53\u671f\u8ba1\u7a0e\u4e0b\u63a8", (String)"CjfcyzftConvertPlugin_19", (String)"taxc-tcret", (Object[])new Object[0]));
            this.put(CjfcyzftConvertBusinessService.NEXTPERIOD, ResManager.loadKDString((String)"\u9002\u7528\u4e0b\u671f\u8ba1\u7a0e\u4e0b\u63a8", (String)"CjfcyzftConvertPlugin_20", (String)"taxc-tcret", (Object[])new Object[0]));
            this.put(CjfcyzftConvertBusinessService.MONTHBYMONTH, ResManager.loadKDString((String)"\u9002\u7528\u9010\u6708\u8ba1\u7a0e\u4e0b\u63a8", (String)"CjfcyzftConvertPlugin_21", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    };

    public static String getOperateNameByKey(String operateKey) {
        return OPERATEKEYNAME.getOrDefault(operateKey, "");
    }

    public static void dataPushDown(DynamicObjectCollection dynamicObjectCollection, Date convertdate, Date startdate, Date enddate, DynamicObject cjfcobj, DynamicObject fcsobj, StringBuilder showMsg, String operateType) {
        DynamicObject dynamicObject = null;
        boolean isNewData = true;
        String bgtype = "";
        String remark = "";
        String successMsg = "";
        for (DynamicObject object : dynamicObjectCollection) {
            String s;
            Date fcsbgdate = (Date)object.get("bgdate");
            if (!DateUtils.format((Date)convertdate, (String)"yyyy-MM").equals(DateUtils.format((Date)fcsbgdate, (String)"yyyy-MM"))) continue;
            dynamicObject = object;
            bgtype = dynamicObject.getString("bgtype");
            remark = dynamicObject.getString("remark");
            if (StringUtil.isNotBlank((CharSequence)bgtype) && !bgtype.endsWith(",")) {
                bgtype = bgtype + ",";
            }
            if (StringUtil.isNotBlank((CharSequence)remark) && !remark.endsWith("\uff1b") && (remark + "\uff1b").length() <= 50) {
                remark = remark + "\uff1b";
            }
            if (CURRENTPERIOD.equals(operateType)) {
                s = ResManager.loadKDString((String)"\u9002\u7528\u5f53\u671f\u8ba1\u7a0e\u4e0b\u63a8\u8986\u76d6", (String)"CjfcyzftConvertPlugin_22", (String)"taxc-tcret", (Object[])new Object[0]);
                String string = remark = (remark + s).length() > 50 ? dynamicObject.getString("remark") : remark + s;
            }
            if (NEXTPERIOD.equals(operateType)) {
                s = ResManager.loadKDString((String)"\u9002\u7528\u4e0b\u671f\u8ba1\u7a0e\u4e0b\u63a8\u8986\u76d6", (String)"CjfcyzftConvertPlugin_23", (String)"taxc-tcret", (Object[])new Object[0]);
                remark = (remark + s).length() > 50 ? dynamicObject.getString("remark") : remark + s;
            }
            successMsg = ResManager.loadKDString((String)"\u5143\u4e0b\u63a8\u8986\u76d6\u6210\u529f\u3002", (String)"CjfcyzftConvertPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]);
            isNewData = false;
            break;
        }
        if (dynamicObject == null) {
            dynamicObject = dynamicObjectCollection.addNew();
            bgtype = "fcyz,czfcyz";
            dynamicObject.set("bgdate", (Object)convertdate);
            CjfcyzftConvertBusinessService.setHouseValue(fcsobj, dynamicObject, dynamicObjectCollection, convertdate);
            successMsg = ResManager.loadKDString((String)"\u5143\u4e0b\u63a8\u6210\u529f\u3002", (String)"CjfcyzftConvertPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]);
        }
        dynamicObject.set("bgdate", (Object)convertdate);
        dynamicObject.set("bgassertvalue", (Object)cjfcobj.getString("adjustedvalue"));
        dynamicObject.set("bghireassertvalue", (Object)cjfcobj.getString("adjustedrentvalue"));
        dynamicObject.set("bgmodifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("bgmodifydate", (Object)new Date());
        if (!bgtype.contains("fcyz")) {
            bgtype = bgtype + "fcyz,";
        }
        if (!bgtype.contains("czfcyz")) {
            bgtype = bgtype + "czfcyz,";
        }
        dynamicObject.set("bgtype", (Object)bgtype);
        if (CURRENTPERIOD.equals(operateType) && isNewData) {
            remark = ResManager.loadKDString((String)"\u9002\u7528\u5f53\u671f\u8ba1\u7a0e\u4e0b\u63a8", (String)"CjfcyzftConvertPlugin_19", (String)"taxc-tcret", (Object[])new Object[0]);
        }
        if (NEXTPERIOD.equals(operateType) && isNewData) {
            remark = ResManager.loadKDString((String)"\u9002\u7528\u4e0b\u671f\u8ba1\u7a0e\u4e0b\u63a8", (String)"CjfcyzftConvertPlugin_20", (String)"taxc-tcret", (Object[])new Object[0]);
        }
        dynamicObject.set("remark", (Object)remark);
        dynamicObject.set("datasource", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fcsobj});
        BigDecimal adjustedcjjzvalue = (BigDecimal)cjfcobj.get("adjustedcjjzvalue");
        showMsg.append(cjfcobj.getString("billno")).append("\t").append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"CjfcyzftConvertPlugin_4", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject(ORG).getString("name")).append("\t").append(ResManager.loadKDString((String)"\u623f\u4ea7\uff1a", (String)"CjfcyzftConvertPlugin_5", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getString("name")).append("\t").append(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a", (String)"CjfcyzftConvertPlugin_6", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject("number").getString("number")).append("\n").append(ResManager.loadKDString((String)"\u5c5e\u671f\uff1a", (String)"CjfcyzftConvertPlugin_7", (String)"taxc-tcret", (Object[])new Object[0])).append(DateUtils.format((Date)startdate, (String)DateUtils.YYYYMMDD_CHINESE)).append("-").append(DateUtils.format((Date)enddate, (String)DateUtils.YYYYMMDD_CHINESE)).append("\t").append(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4ece\u4ef7\u623f\u4ea7\u8ba1\u5f81\u539f\u503c", (String)"CjfcyzftConvertPlugin_8", (String)"taxc-tcret", (Object[])new Object[0])).append(adjustedcjjzvalue.setScale(2, RoundingMode.HALF_UP)).append(successMsg);
        showMsg.append("\n");
    }

    public static StringBuilder getComonMsg(DynamicObject cjfcobj) {
        return new StringBuilder().append(cjfcobj.getString("billno")).append("\t").append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"CjfcyzftConvertPlugin_4", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject(ORG).getString("name")).append("\t").append(ResManager.loadKDString((String)"\u623f\u4ea7\uff1a", (String)"CjfcyzftConvertPlugin_5", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getString("name")).append("\t").append(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a", (String)"CjfcyzftConvertPlugin_6", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject("number").getString("number")).append("\n").append(ResManager.loadKDString((String)"\u5c5e\u671f\uff1a", (String)"CjfcyzftConvertPlugin_7", (String)"taxc-tcret", (Object[])new Object[0])).append(DateUtils.format((Date)cjfcobj.getDate("startdate"), (String)DateUtils.YYYYMMDD_CHINESE)).append("-").append(DateUtils.format((Date)cjfcobj.getDate("enddate"), (String)DateUtils.YYYYMMDD_CHINESE)).append("\t");
    }

    public static boolean checkDuplicateData(DynamicObject fcsobj, DynamicObject cjfcobj) {
        DynamicObjectCollection dynamicObjectCollection = fcsobj.getDynamicObjectCollection("bgentryentity");
        DynamicObjectCollection cjmjftCollection = cjfcobj.getDynamicObjectCollection("entryentity");
        if (dynamicObjectCollection == null || cjmjftCollection == null) {
            return true;
        }
        for (DynamicObject obj : cjmjftCollection) {
            Date period = obj.getDate("period");
            Date lastMonthDate = DateUtils.addMonth((Date)period, (int)-1);
            String lastMonth = DateUtils.formatMonth((Date)lastMonthDate);
            DynamicObject dynamicObject = null;
            if (dynamicObjectCollection == null || (dynamicObject = (DynamicObject)dynamicObjectCollection.stream().filter(e -> DateUtils.formatMonth((Date)e.getDate("bgdate")).equals(lastMonth)).findFirst().orElse(null)) == null) continue;
            return false;
        }
        return true;
    }

    public static StringBuilder dataPushDownByMonth(DynamicObject fcsobj, DynamicObject cjfcobj, StringBuilder showMsg, boolean updateData, List<DynamicObject> updateDataList) {
        Date startdate = (Date)cjfcobj.get("startdate");
        Date enddate = (Date)cjfcobj.get("enddate");
        showMsg.append(cjfcobj.getString("billno")).append("\t").append(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a", (String)"CjfcyzftConvertPlugin_4", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject(ORG).getString("name")).append("\t").append(ResManager.loadKDString((String)"\u623f\u4ea7\uff1a", (String)"CjfcyzftConvertPlugin_5", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getString("name")).append("\t").append(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a", (String)"CjfcyzftConvertPlugin_6", (String)"taxc-tcret", (Object[])new Object[0])).append(cjfcobj.getDynamicObject("number").getString("number")).append("\n");
        DynamicObjectCollection cjmjftCollection = cjfcobj.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dynamicObjectCollection = fcsobj.getDynamicObjectCollection("bgentryentity");
        if (cjmjftCollection == null) {
            return null;
        }
        ArrayList<DynamicObject> currentDataList = new ArrayList<DynamicObject>(16);
        boolean isNewData = true;
        for (DynamicObject obj : cjmjftCollection) {
            String s;
            Date period = obj.getDate("period");
            Date lastMonthDate = DateUtils.addMonth((Date)period, (int)-1);
            String lastMonth = DateUtils.formatMonth((Date)lastMonthDate);
            BigDecimal cjjzassertvalue = obj.getBigDecimal("cjjzassertvalue");
            DynamicObject dynamicObject = null;
            String bgtype = "";
            String remark = "";
            String successMsg = "";
            int collectionSize = 0;
            if (dynamicObjectCollection != null) {
                collectionSize = dynamicObjectCollection.size();
                dynamicObject = dynamicObjectCollection.stream().filter(e -> DateUtils.formatMonth((Date)e.getDate("bgdate")).equals(lastMonth)).findFirst().orElse(null);
                if (dynamicObject != null) {
                    currentDataList.add(dynamicObject);
                    isNewData = false;
                    if (!updateData) {
                        return showMsg.append(ResManager.loadKDString((String)"\u5c5e\u671f\uff1a", (String)"CjfcyzftConvertPlugin_7", (String)"taxc-tcret", (Object[])new Object[0])).append(DateUtils.format((Date)startdate, (String)DateUtils.YYYYMMDD_CHINESE)).append("-").append(DateUtils.format((Date)enddate, (String)DateUtils.YYYYMMDD_CHINESE)).append("\t").append(ResManager.loadKDString((String)"\u4e0e\u623f\u4ea7\u7a0e\u6e90\u53d8\u66f4\u53f0\u8d26\u5b58\u5728\u91cd\u590d\u5c5e\u671f\u7684\u6570\u636e", (String)"CjfcyzftConvertPlugin_13", (String)"taxc-tcret", (Object[])new Object[0])).append("\uff0c").append(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\u3002", (String)"CjfcyzftConvertPlugin_16", (String)"taxc-tcret", (Object[])new Object[0])).append("\n");
                    }
                    bgtype = dynamicObject.getString("bgtype");
                    remark = dynamicObject.getString("remark");
                    if (StringUtil.isNotBlank((CharSequence)bgtype) && !bgtype.endsWith(",")) {
                        bgtype = bgtype + ",";
                    }
                    if (StringUtil.isNotBlank((CharSequence)remark) && !remark.endsWith("\uff1b") && (remark + "\uff1b").length() <= 50) {
                        remark = remark + "\uff1b";
                    }
                    s = ResManager.loadKDString((String)"\u9002\u7528\u9010\u6708\u8ba1\u7a0e\u4e0b\u63a8\u8986\u76d6", (String)"CjfcyzftConvertPlugin_24", (String)"taxc-tcret", (Object[])new Object[0]);
                    remark = (remark + s).length() <= 50 ? remark + s : dynamicObject.getString("remark");
                    successMsg = ResManager.loadKDString((String)"\u5143\u4e0b\u63a8\u8986\u76d6\u6210\u529f\u3002", (String)"CjfcyzftConvertPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]);
                }
            }
            if (dynamicObject == null) {
                dynamicObject = dynamicObjectCollection.addNew();
                s = ResManager.loadKDString((String)"\u9002\u7528\u9010\u6708\u8ba1\u7a0e\u4e0b\u63a8", (String)"CjfcyzftConvertPlugin_21", (String)"taxc-tcret", (Object[])new Object[0]);
                remark = remark + s;
                Object bghousevalue = fcsobj.get("housevalue");
                Object bgequipmentvalue = fcsobj.get("equipmentvalue");
                Object bgvalue = fcsobj.get("value");
                DynamicObject newDynamicObject = null;
                String nearstOneDate = "";
                if (collectionSize > 0) {
                    for (DynamicObject obj1 : dynamicObjectCollection) {
                        String currentDate;
                        if (obj1.getDate("bgdate") == null || (currentDate = DateUtils.formatMonth((Date)obj1.getDate("bgdate"))).compareTo(lastMonth) > 0 || !StringUtil.isBlank((CharSequence)nearstOneDate) && currentDate.compareTo(nearstOneDate) < 0) continue;
                        newDynamicObject = obj1;
                        nearstOneDate = currentDate;
                    }
                }
                if (newDynamicObject != null) {
                    bghousevalue = newDynamicObject.get("bghousevalue");
                    bgequipmentvalue = newDynamicObject.get("bgequipmentvalue");
                    bgvalue = newDynamicObject.get("bgvalue");
                }
                dynamicObject.set("bghousevalue", bghousevalue);
                dynamicObject.set("bgequipmentvalue", bgequipmentvalue);
                dynamicObject.set("bgvalue", bgvalue);
                successMsg = ResManager.loadKDString((String)"\u5143\u4e0b\u63a8\u6210\u529f\u3002", (String)"CjfcyzftConvertPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]);
            }
            dynamicObject.set("bgdate", (Object)DateUtils.getLastDateOfMonth((Date)lastMonthDate));
            if (!bgtype.contains("fcyz")) {
                bgtype = bgtype + "fcyz,";
            }
            if (!bgtype.contains("czfcyz")) {
                bgtype = bgtype + "czfcyz,";
            }
            dynamicObject.set("bgtype", (Object)bgtype);
            dynamicObject.set("bgassertvalue", obj.get("assertvalue"));
            dynamicObject.set("bghireassertvalue", (Object)obj.getBigDecimal("assertvalue").subtract(cjjzassertvalue));
            dynamicObject.set("remark", (Object)remark);
            dynamicObject.set("bgmodifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("bgmodifydate", (Object)new Date());
            dynamicObject.set("datasource", (Object)"1");
            cjjzassertvalue = cjjzassertvalue.setScale(2, 4);
            showMsg.append(ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"CjfcyzftConvertPlugin_25", (String)"taxc-tcret", (Object[])new Object[0])).append(DateUtils.formatMonth((Date)period)).append(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u4ece\u4ef7\u8ba1\u5f81\u623f\u4ea7\u539f\u503c", (String)"CjfcyzftConvertPlugin_26", (String)"taxc-tcret", (Object[])new Object[0])).append(cjjzassertvalue).append(successMsg).append("\n");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fcsobj});
        return showMsg;
    }

    private static void setHouseValue(DynamicObject fcsDynamicObject, DynamicObject bgentity, DynamicObjectCollection bgentryentity, Date converdate) {
        Boolean assertvalueform;
        if (fcsDynamicObject != null && (assertvalueform = (Boolean)SystemParamUtil.getAppParameter((String)"tcret", (String)"assertvalueform", (long)fcsDynamicObject.getLong("org.id"))).booleanValue()) {
            if (!bgentryentity.isEmpty()) {
                List modifytimeList = bgentryentity.stream().filter(s -> s.getDate("bgdate").before(converdate)).sorted(Comparator.comparing(s -> s.getDate("bgdate")).reversed()).collect(Collectors.toList());
                if (modifytimeList.size() > 0) {
                    bgentity.set("bghousevalue", (Object)((DynamicObject)modifytimeList.get(0)).getBigDecimal("bghousevalue"));
                    bgentity.set("bgequipmentvalue", (Object)((DynamicObject)modifytimeList.get(0)).getBigDecimal("bgequipmentvalue"));
                    bgentity.set("bgvalue", (Object)((DynamicObject)modifytimeList.get(0)).getBigDecimal("bgvalue"));
                } else {
                    bgentity.set("bghousevalue", (Object)fcsDynamicObject.getBigDecimal("housevalue"));
                    bgentity.set("bgequipmentvalue", (Object)fcsDynamicObject.getBigDecimal("equipmentvalue"));
                    bgentity.set("bgvalue", (Object)fcsDynamicObject.getBigDecimal("value"));
                }
            } else {
                bgentity.set("bghousevalue", (Object)fcsDynamicObject.getBigDecimal("housevalue"));
                bgentity.set("bgequipmentvalue", (Object)fcsDynamicObject.getBigDecimal("equipmentvalue"));
                bgentity.set("bgvalue", (Object)fcsDynamicObject.getBigDecimal("value"));
            }
        }
    }
}

