/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.taxsource.task;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BdAccountVO;
import kd.taxc.tcret.common.utils.YhsAccrualUtils;
import kd.taxc.tcret.common.utils.YhsUtils;
import org.apache.commons.lang.StringUtils;

public class AccountDetailTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(AccountDetailTask.class);
    private int batchSize = 5;
    private static final String key_isMapping = "isMapping";
    private static final String key_fieldkey = "fieldkey";
    private static final String key_mappingList = "mappingList";
    private Map<String, String> dataMap;
    private Map<String, Map<String, Object>> errorMap;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private String type;
    private BigDecimal jmrate;
    private DynamicObject yhsCardItem;
    public static final String TCSD_RULE_YSHTPZ = "tcsd_rule_yshtpz";
    public static final String TCSD_RULE_CQZYSJ = "tcsd_rule_cqzysj";
    public static final String TCSD_RULE_ZJZB = "tcsd_rule_zjzb";
    private static final HashMap<String, String> ruleTypeMap = new HashMap();
    private Long taxCategoryId = 0L;

    public AccountDetailTask(Map<String, String> dataMap, Map<String, Map<String, Object>> errorMap, DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String type, DynamicObject yhsCardItem, Long taxCategoryId, BigDecimal jmrate) {
        this.dataMap = dataMap;
        this.errorMap = errorMap;
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.type = type;
        this.yhsCardItem = yhsCardItem;
        this.taxCategoryId = taxCategoryId;
        this.jmrate = jmrate;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long startTime = System.currentTimeMillis();
        String startDate = this.model.getStartDate();
        String endDate = this.model.getEndDate();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Long orgId = Long.valueOf(this.model.getOrgId());
        Map fiBdAccounts = GetGLBalanceCommonUtil.create((Long)orgId);
        ArrayList<DynamicObject> yhsEntityList = new ArrayList();
        if ("tcret_yhs_sjjt_detail".equals(this.entityType)) {
            yhsEntityList = YhsUtils.queryYhsEntityList(orgId);
        }
        for (DynamicObject setting : settings) {
            this.fetchData(yhsEntityList, fiBdAccounts, startDate, endDate, setting, filterList, list);
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + ":" + list.size());
        return list;
    }

    private void fetchData(List<DynamicObject> yhsEntityList, Map<String, BdAccountVO> fiBdAccounts, String startDate, String endDate, DynamicObject setting, List<QFilter> filterList, List<DynamicObject> list) {
        String selectFieldwithid;
        Date start = DateUtils.stringToDate2((String)startDate);
        Date end = DateUtils.stringToDate2((String)endDate);
        DynamicObject detailDynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
        detailDynamicObject.set("ruleid", (Object)String.valueOf(this.rule.get("id")));
        detailDynamicObject.set("serialno", (Object)this.taxaccountserialno);
        detailDynamicObject.set("skssqq", (Object)start);
        detailDynamicObject.set("skssqz", (Object)end);
        detailDynamicObject.set("taxperiod", (Object)this.composeTaxPeriod(startDate, endDate));
        DynamicObject amountfield = setting.getDynamicObject("amountfield");
        detailDynamicObject.set("amountfield", (Object)amountfield.getLong("id"));
        detailDynamicObject.set("datatype", setting.get("datatype"));
        detailDynamicObject.set("bizname", setting.get("bizname"));
        detailDynamicObject.set("datadirection", setting.get("datadirection"));
        detailDynamicObject.set("filtercondition", setting.get("filtercondition"));
        ArrayList idList = new ArrayList(8);
        Map<String, Object> dataSourceMapping = null;
        String bussinessname = null;
        if ("tcret_zjcj_accdet".equals(this.entityType)) {
            detailDynamicObject.set("org", (Object)Long.parseLong(this.model.getOrgId()));
            detailDynamicObject.set("rentid", (Object)this.taxRate);
        } else if ("tcret_tdzzs_yj_det_tp".equals(this.entityType)) {
            detailDynamicObject.set("org", (Object)this.model.getOrgId());
            String sbbid = (String)this.model.getCustom().get("sbbid");
            detailDynamicObject.set("sbbid", (Object)Long.parseLong(sbbid));
            detailDynamicObject.set("yjxm", this.rule.get("yjxm"));
            detailDynamicObject.set("buildingtype", this.rule.get("buildingtype"));
            detailDynamicObject.set("subbuildingtype", this.rule.get("subbuildingtype"));
            detailDynamicObject.set("incometype", this.rule.get("incometype"));
            detailDynamicObject.set("declaretype", this.rule.get("declaretype"));
        } else {
            detailDynamicObject.set("type", (Object)ruleTypeMap.get(this.type));
            detailDynamicObject.set("org", (Object)this.model.getOrgId());
        }
        List orglist = Collections.singletonList(Long.parseLong(this.model.getOrgId()));
        Map orgRelationMap = (Map)this.model.getCustom().get("OrgRelationMap");
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        DynamicObject table = setting.getDynamicObject("table");
        String amountField = setting.getDynamicObject("amountfield").getString("fieldname");
        String fieldsubname = setting.getDynamicObject("amountfield").getString("fieldsubname");
        String advancedconf = setting.getString("advancedconfjson");
        String conditionjson = setting.getString("conditionjson");
        BigDecimal taxRate1 = setting.getBigDecimal("vatrate");
        BigDecimal yzvatrate = null;
        String datatype = setting.getString("datatype");
        if ("yjjsflqs".equals(datatype)) {
            yzvatrate = setting.getBigDecimal("yzvatrate");
        }
        DynamicObjectCollection accountingList = null;
        boolean isBalance = false;
        detailDynamicObject.set("table", (Object)table);
        String entryName = table.getString("name");
        Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
        String org = (String)fieldMap.get("orgstate");
        QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)this.taxCategoryId, (Long)table.getLong("id"), orglist, (Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        if (mappingQfilter != null) {
            filterList.add(mappingQfilter);
            dataSourceMapping = this.fetchdataSourceMapping(table.getLong("id"), orglist, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
            Map orgMapping = (Map)dataSourceMapping.get(key_mappingList);
            orgMapping.values().forEach(a -> idList.addAll(a));
            bussinessname = (String)dataSourceMapping.get(key_fieldkey);
        }
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orglist = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, orglist, (String)entryName, (String)entityKey, (String)orgFieldName);
            filterList.add(new QFilter(org, "in", (Object)orglist));
        }
        boolean isBeginOrEnd = (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"GlBalanceService", (String)"financeBeginEnd", (Object[])new Object[]{fieldsubname, advancedconf});
        RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(advancedconf, start, end, filterList, fieldsubname, fieldMap, entryName);
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setRuleConfigTimeFilter", (Object[])new Object[]{ruleTimeFilterDto});
        boolean isEntityField = false;
        String selectField = amountField;
        if (!entryName.equals(fieldsubname)) {
            isEntityField = true;
            selectField = fieldsubname + "." + amountField;
            selectFieldwithid = fieldsubname + ".id as id," + fieldsubname + "." + amountField;
        } else {
            selectFieldwithid = "id," + amountField;
        }
        if (null != bussinessname) {
            selectFieldwithid = selectFieldwithid + "," + bussinessname;
        }
        if (!"tdm_finance_main".equals(entryName)) {
            if (StringUtils.isNotBlank((String)conditionjson)) {
                if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                    conditionjson = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setAssgrpConditionJson", (Object[])new Object[]{conditionjson});
                }
                QFilter qFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)("tdm_finance_main".equalsIgnoreCase(entryName) ? "tdm_finance_lrb" : entryName));
                qFilters = GetGLBalanceCommonUtil.parseQFilter((Long)Long.valueOf(this.model.getOrgId()), (String)entryName, (QFilter)qFilters, fiBdAccounts);
                if (qFilters != null) {
                    filterList.add(qFilters);
                }
            }
            if (entryName.equals("tdm_invoice_output") || entryName.equals("sim_vatinvoice")) {
                filterList.add(new QFilter("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"})));
            } else if ("tcret_yhs_tax_source_info".equals(entryName)) {
                filterList.add(new QFilter("isxgm", "=", (Object)"0"));
                if (this.rule.containsProperty("taxitem")) {
                    filterList.add(new QFilter("taxitem", "=", (Object)this.rule.getLong("taxitem.id")));
                }
                if (this.rule.containsProperty("subtaxitem")) {
                    filterList.add(new QFilter("subtaxitem", "=", (Object)this.rule.getLong("subtaxitem.id")));
                }
            }
            if (isBeginOrEnd) {
                accountingList = GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)advancedconf, (String)amountField, (String)this.model.getStartDate(), (String)this.model.getEndDate(), filterList);
            } else {
                accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
                isBeginOrEnd = (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"GlBalanceService", (String)"tdmBalanceNew", (Object[])new Object[]{fieldsubname, advancedconf});
            }
        } else {
            QFilter skssqzFilter;
            QFilter skssqqFilter;
            QFilter orgFilter;
            DynamicObjectCollection fidCollection;
            QFilter tableid = new QFilter("id", "=", (Object)table.getLong("id"));
            QFilter[] filters = new QFilter[]{tableid};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,subname,ischild,entryentity.id,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
            DynamicObject orgstate = null;
            DynamicObject datastate = null;
            for (DynamicObject d : collection) {
                if ("true".equals(d.getString("entryentity.orgstate"))) {
                    orgstate = d;
                }
                if (!"true".equals(d.getString("entryentity.datastate"))) continue;
                datastate = d;
            }
            if (orgstate != null && datastate != null && (fidCollection = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])new QFilter[]{orgFilter = new QFilter(orgstate.getString("entryentity.fieldname"), "in", (Object)orglist), skssqqFilter = new QFilter(datastate.getString("entryentity.fieldname"), ">=", (Object)DateUtils.stringToDate((String)startDate)), skssqzFilter = new QFilter(datastate.getString("entryentity.fieldname"), "<=", (Object)DateUtils.getDayLast((Date)DateUtils.stringToDate((String)endDate)))})) != null && fidCollection.size() > 0) {
                QFilter q;
                List list2 = fidCollection.stream().map(a -> a.getString("id")).collect(Collectors.toList());
                QFilter filter = new QFilter("sbbid", "in", list2);
                if (StringUtils.isNotBlank((String)conditionjson) && StringUtils.isNotBlank((String)fieldsubname) && (q = FilterBuilderUtils.buildFilter((String)conditionjson, (String)fieldsubname)) != null) {
                    filter = filter.and(q);
                }
                accountingList = QueryServiceHelper.query((String)fieldsubname, (String)selectFieldwithid, (QFilter[])new QFilter[]{filter});
            }
        }
        if (accountingList != null && accountingList.size() > 0) {
            for (DynamicObject dynamicObject : accountingList) {
                String entryIdData;
                if (dynamicObject == null) continue;
                String entryId = dynamicObject.getString("id");
                String ruletype = this.rule.getDataEntityType().getName();
                String key = ruletype + entryName + entryId;
                if (isEntityField) {
                    key = ruletype + entryName + fieldsubname + entryId;
                }
                if (null != (entryIdData = this.dataMap.get(key))) {
                    Map map = this.errorMap.computeIfAbsent(key, k -> new HashMap());
                    map.put("type", this.rule.getDataEntityType().getName());
                    map.put("field", this.rule.getDataEntityType().getName());
                    Set set = (Set)map.computeIfAbsent("rulelist", k -> new HashSet());
                    set.add(entryIdData);
                    set.add(this.rule.getString("name"));
                }
                this.dataMap.put(key, this.rule.getString("name"));
                detailTotalAmount = detailTotalAmount.add(isBeginOrEnd ? dynamicObject.getBigDecimal(selectField) : this.getAbsAmount(setting, entryName.equals("tdm_finance_main") ? amountField : selectField, dynamicObject));
            }
        }
        detailTotalAmount = (isBalance = isBeginOrEnd) ? (setting.getBoolean("absolute") ? detailTotalAmount.abs() : detailTotalAmount) : detailTotalAmount;
        BigDecimal jsbl = null;
        if ("gjqs".equals(datatype)) {
            jsbl = setting.getBigDecimal("jsbl");
            detailTotalAmount = detailTotalAmount.multiply(jsbl);
        }
        detailDynamicObject.set("fetchamount", (Object)detailTotalAmount);
        String dataDirection = setting.getString("datadirection");
        BigDecimal amount = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getLvtYzAmount", (Object[])new Object[]{detailTotalAmount, dataDirection, datatype, taxRate1, yzvatrate});
        detailDynamicObject.set("amount", (Object)amount);
        if ("tcret_yhs_sjjt_detail".equals(this.entityType)) {
            DynamicObject deductioncode;
            List<String> amountList;
            BigDecimal orginAmount = BigDecimal.ZERO;
            String taxitem = this.rule.getDynamicObject("taxitem").getString("name");
            BigDecimal hdRate = YhsAccrualUtils.findHdRateInYhsEntitys(yhsEntityList, taxitem, start, end, table);
            HashMap<String, List<String>> businessmap = new HashMap<String, List<String>>();
            if (accountingList != null && accountingList.size() > 0) {
                if (idList.size() > 0) {
                    HashMap<String, BigDecimal> amountmap = new HashMap<String, BigDecimal>();
                    for (DynamicObject dynamicObject : accountingList) {
                        String bosorgid = dynamicObject.getString(bussinessname);
                        orginAmount = dynamicObject.getBigDecimal(selectField);
                        if (!isBalance) {
                            orginAmount = setting.getBoolean("absolute") ? orginAmount.abs() : orginAmount;
                            BigDecimal sjjtAmount = this.getSjjtAmount(orginAmount, dataDirection, setting, taxRate1);
                            if (amountmap.containsKey(bosorgid) && null != sjjtAmount) {
                                amountmap.put(bosorgid, ((BigDecimal)amountmap.get(bosorgid)).add(sjjtAmount));
                                continue;
                            }
                            amountmap.put(bosorgid, sjjtAmount);
                            continue;
                        }
                        if (amountmap.containsKey(bosorgid) && null != orginAmount) {
                            amountmap.put(bosorgid, ((BigDecimal)amountmap.get(bosorgid)).add(orginAmount));
                            continue;
                        }
                        amountmap.put(bosorgid, orginAmount);
                    }
                    if (isBalance) {
                        for (Map.Entry entry : amountmap.entrySet()) {
                            entry.setValue(this.setSjjtAmount((BigDecimal)entry.getValue(), dataDirection, setting, taxRate1));
                        }
                    }
                    for (Object object : idList) {
                        if (!amountmap.containsKey(String.valueOf(object))) continue;
                        List<String> amountList2 = YhsAccrualUtils.getAmountList((BigDecimal)amountmap.get(object.toString()), hdRate, jsbl, this.taxRate, this.jmrate);
                        businessmap.put(object.toString(), amountList2);
                    }
                } else {
                    amountList = YhsAccrualUtils.getAmountList(amount, hdRate, null, this.taxRate, this.jmrate);
                    businessmap.put(String.valueOf(this.model.getCustom().get("org")), amountList);
                }
            } else {
                amountList = YhsAccrualUtils.getAmountList(amount, hdRate, null, this.taxRate, this.jmrate);
                businessmap.put(String.valueOf(this.model.getCustom().get("org")), amountList);
            }
            detailDynamicObject.set("businessmap", (Object)SerializationUtils.toJsonString(businessmap));
            detailDynamicObject.set("taxitem", (Object)taxitem);
            if (this.rule.containsProperty("subtaxitem")) {
                detailDynamicObject.set("subtaxitem", (Object)this.rule.getDynamicObject("subtaxitem"));
            }
            detailDynamicObject.set("deductiontype", (Object)((deductioncode = this.rule.getDynamicObject("deductioncode")) != null ? deductioncode.getString("deductiontype") : ""));
            detailDynamicObject.set("taxlimit", (Object)YhsAccrualUtils.findPeriodInYhsEntitys(yhsEntityList, taxitem, start, end, this.rule.getString("declaretype")));
        }
        detailDynamicObject.set("absolute", (Object)setting.getString("absolute"));
        list.add(detailDynamicObject);
        filterList.clear();
    }

    private BigDecimal getSjjtAmount(BigDecimal orginAmount, String dataDirection, DynamicObject setting, BigDecimal taxRate1) {
        BigDecimal sjjtAmount = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getAmount", (Object[])new Object[]{orginAmount, dataDirection, setting.getString("datatype"), taxRate1});
        return sjjtAmount;
    }

    private BigDecimal setSjjtAmount(BigDecimal value, String dataDirection, DynamicObject setting, BigDecimal taxRate1) {
        value = setting.getBoolean("absolute") ? value.abs() : value;
        BigDecimal sjjtAmount = (BigDecimal)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleEnginService", (String)"getAmount", (Object[])new Object[]{value, dataDirection, setting.getString("datatype"), taxRate1});
        return sjjtAmount;
    }

    public String composeTaxPeriod(String startDate, String endDate) {
        String endMonth;
        String year = startDate.substring(0, 4);
        String startMonth = startDate.substring(5, 7);
        String taxPeriod = StringUtils.equals((String)startMonth, (String)(endMonth = endDate.substring(5, 7))) ? String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708", (String)"AccountDetailTask_0", (String)"taxc-tcret", (Object[])new Object[0]), year, startMonth) : String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s-%3$s\u6708", (String)"AccountDetailTask_1", (String)"taxc-tcret", (Object[])new Object[0]), year, startMonth, endMonth);
        return taxPeriod;
    }

    public BigDecimal getAbsAmount(DynamicObject setting, String amountField, DynamicObject dynamicObject) {
        BigDecimal amount = Boolean.TRUE.equals(setting.getBoolean("absolute")) ? dynamicObject.getBigDecimal(amountField).abs() : dynamicObject.getBigDecimal(amountField);
        return amount;
    }

    private Map<String, Object> fetchdataSourceMapping(Long dataSourceId, List<Long> taxorgs, Date skssqq, Date skssqz) {
        Map dataSourceMapping = EngineCalcFilterService.getMappingResult((Long)this.taxCategoryId, (Long)dataSourceId, taxorgs, (Date)skssqq, (Date)skssqz);
        return dataSourceMapping;
    }

    static {
        ruleTypeMap.put(TCSD_RULE_YSHTPZ, "1");
        ruleTypeMap.put(TCSD_RULE_CQZYSJ, "2");
        ruleTypeMap.put(TCSD_RULE_ZJZB, "3");
    }
}

