/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.zys;

import com.google.common.collect.ImmutableBiMap;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.zys.ZysCollectCalculateServiceImpl;
import org.apache.commons.lang3.ObjectUtils;

public class ZysCollectEngine {
    private static Log logger = LogFactory.getLog(ZysCollectEngine.class);
    private static Long zysTemplateId = 1667472839776709745L;

    public static RuleFetchMainDto runEngine(Long orgId, Date startDate, Date endDate, Long taxsourceId, List<Long> ids) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        if (ObjectUtils.isNotEmpty(ids)) {
            ruleFetchMainDto = ZysCollectEngine.calculateRuleAccess(orgId, taxsourceId, taxsourceId, startDate, endDate, ids);
        }
        return ruleFetchMainDto;
    }

    private static RuleFetchMainDto calculateRuleAccess(Long orgId, Long templateId, Long taxsourceId, Date startDate, Date endDate, List<Long> ids) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        QFilter accessWhereFilter = new QFilter("taxitem", "in", ids).and(new QFilter("enable", "=", (Object)Boolean.TRUE)).and(new QFilter("taxsource", "=", (Object)taxsourceId));
        RuleEngineParamDto paramDto = new RuleEngineParamDto(orgId, Long.valueOf(5L), DateUtils.getFirstDateOfYear((Date)startDate), endDate, zysTemplateId, accessWhereFilter, null, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate));
        try {
            ZysCollectCalculateServiceImpl service = new ZysCollectCalculateServiceImpl();
            List ruleFetchMainDtoList = service.calculateRuleAccess(paramDto);
            return (RuleFetchMainDto)ruleFetchMainDtoList.get(0);
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u53d6\u6570\u62a5\u9519:{}", (Object)exceptionStackTraceMessage);
            return ruleFetchMainDto;
        }
    }
}

