/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.business.zys;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.admindivision.AdminDivisionDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class ZysService {
    public static DynamicObjectCollection queryZysRegisterByTaxoffice(Long taxofficeId) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("enable", "=", (Object)"1"));
        list.add(new QFilter("taxoffice", "=", (Object)taxofficeId));
        return QueryServiceHelper.query((String)"tcret_zys_register", (String)"id", (QFilter[])list.toArray(new QFilter[0]), (String)"modifytime desc");
    }

    public static DynamicObjectCollection queryZysRegisterEnable() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"tcret_zys_register", (String)"id,org,org.number,taxoffice,taxoffice.number,number", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection queryTaxdeduction() {
        QFilter qFilter = new QFilter("taxcategory.number", "=", (Object)"005");
        return QueryServiceHelper.query((String)"tpo_taxdeduction", (String)"id,number,startdate,enddate", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection queryRule(Long orgId, Long taxsourceId, List<Long> taxitemIds) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("org", "=", (Object)orgId));
        list.add(new QFilter("taxsource", "=", (Object)taxsourceId));
        list.add(new QFilter("enable", "in", (Object)"1"));
        if (CollectionUtils.isNotEmpty(taxitemIds)) {
            list.add(new QFilter("taxitem", "in", taxitemIds));
        }
        return QueryServiceHelper.query((String)"tcret_zys_rule", (String)"id,name,taxitem,taxsubitem,taxdeduction,taxdeduction.startdate,taxdeduction.enddate", (QFilter[])list.toArray(new QFilter[0]));
    }

    public static DynamicObjectCollection queryZysTaxitem() {
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"tpo_zys_taxitem", (String)"id,admindivision", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        return objectCollection;
    }

    public static boolean isEffectiveDate(Date date1, Date date2, Date start, Date end) {
        Date enddate;
        Date startdate = new Date(start.getTime());
        Date date = enddate = end != null ? new Date(end.getTime()) : null;
        if (null == date2) {
            return startdate.equals(date1) || DateUtils.isEffectiveDate((Date)date1, (Date)startdate, (Date)enddate);
        }
        return !(!startdate.equals(date1) && !DateUtils.isEffectiveDate((Date)date1, (Date)startdate, (Date)enddate) || !date2.equals(enddate) && !DateUtils.isEffectiveDate((Date)date2, (Date)startdate, (Date)enddate));
    }

    public static DynamicObjectCollection queryZysTaxitem(Date skssqq, Date skssqz) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(new QFilter("startdate", "<=", (Object)skssqq));
        list.add(new QFilter("enddate", ">=", (Object)skssqz).or(new QFilter("enddate", "=", null)));
        list.add(new QFilter("enable", "in", (Object)"1"));
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"tpo_zys_taxitem", (String)"id,admindivision,entryentity.id", (QFilter[])list.toArray(new QFilter[0]));
        return objectCollection;
    }

    public static List<Long> findFitTaxitemIds(Date startdate, Date enddate, Long taxofficeAdmindivisionId) {
        DynamicObjectCollection zysTaxitem = ZysService.queryZysTaxitem(startdate, enddate);
        List<Long> admindivisionIds = zysTaxitem.stream().map(o -> o.getLong("admindivision")).collect(Collectors.toList());
        admindivisionIds.add(taxofficeAdmindivisionId);
        Map<Long, String> provinceMap = ZysService.dealprovinceMap(admindivisionIds);
        String dataProvince = provinceMap.get(taxofficeAdmindivisionId);
        ArrayList list = new ArrayList();
        provinceMap.forEach((key, value) -> {
            if (key != null && value != null && value.equals(dataProvince)) {
                list.add(key);
            }
        });
        List<Long> ids = zysTaxitem.stream().filter(a -> list.contains(a.getLong("admindivision"))).map(a -> a.getLong("entryentity.id")).collect(Collectors.toList());
        return ids;
    }

    public static Map<Long, String> dealprovinceMap(List<Long> admindivisionIds) {
        Map<Long, List> locationMap = new HashMap();
        HashMap<Long, String> provinceMap = new HashMap<Long, String>();
        TaxResult taxResult = AdminDivisionDataServiceHelper.getPathNameByIds(admindivisionIds);
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            locationMap = (Map)taxResult.getData();
            locationMap.forEach((key, value) -> provinceMap.put((Long)key, value != null ? (String)value.get(0) : ""));
        }
        return provinceMap;
    }
}

