/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.enums;

import java.util.ArrayList;
import java.util.List;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;

public enum CompareListEnum {
    YHS("yhs_bd", "yhs", "tcret_compare_yhs", BaseTaxCategory.YHS, 1817308264602320896L),
    FCS("fcs_bd", "fcs", "tcret_compare_fcs", BaseTaxCategory.FCS, 1818159140162529280L),
    TDS("cztdsys_bd", "cztdsys", "tcret_compare_tds", BaseTaxCategory.CZTDSYS, 1818160089794896896L);

    private String drafttype;
    private String taxcategory;
    private String entityname;
    private Long taxtype;
    private Long provistonitem;

    private CompareListEnum(String drafttype, String taxcategory, String entityname, Long taxtype, Long provistonitem) {
        this.drafttype = drafttype;
        this.taxcategory = taxcategory;
        this.entityname = entityname;
        this.taxtype = taxtype;
        this.provistonitem = provistonitem;
    }

    public String getDrafttype() {
        return this.drafttype;
    }

    public void setDrafttype(String drafttype) {
        this.drafttype = drafttype;
    }

    public String getTaxcategory() {
        return this.taxcategory;
    }

    public void setTaxcategory(String taxcategory) {
        this.taxcategory = taxcategory;
    }

    public String getEntityname() {
        return this.entityname;
    }

    public void setEntityname(String entityname) {
        this.entityname = entityname;
    }

    public Long getTaxtype() {
        return this.taxtype;
    }

    public void setTaxtype(Long taxtype) {
        this.taxtype = taxtype;
    }

    public Long getProvistonitem() {
        return this.provistonitem;
    }

    public void setProvistonitem(Long provistonitem) {
        this.provistonitem = provistonitem;
    }

    public static String getEntityNameByDraftType(String drafttype) {
        for (CompareListEnum compareListEnum : CompareListEnum.values()) {
            if (!compareListEnum.getDrafttype().equals(drafttype)) continue;
            return compareListEnum.getEntityname();
        }
        return null;
    }

    public static String getTaxCategoryByDraftType(String drafttype) {
        for (CompareListEnum compareListEnum : CompareListEnum.values()) {
            if (!compareListEnum.getDrafttype().equals(drafttype)) continue;
            return compareListEnum.getTaxcategory();
        }
        return null;
    }

    public static Long getProvistonItemByDraftType(String drafttype) {
        for (CompareListEnum compareListEnum : CompareListEnum.values()) {
            if (!compareListEnum.getDrafttype().equals(drafttype)) continue;
            return compareListEnum.getProvistonitem();
        }
        return null;
    }

    public static List<Long> getAllProvistonItems() {
        ArrayList<Long> list = new ArrayList<Long>(CompareListEnum.values().length);
        for (CompareListEnum compareListEnum : CompareListEnum.values()) {
            list.add(compareListEnum.getProvistonitem());
        }
        return list;
    }
}

