/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareShowUtils {
    public static final String ORG = "org";
    public static final String PARA_ORG = "orgid";
    public static final String TABPAGEAP1 = "tabpageap1";
    public static final String TABPAGEAP2 = "tabpageap2";
    private static final String[] tab_keys = new String[]{"tabpageap1", "tabpageap2"};

    public static String[] getTabKeys() {
        return tab_keys;
    }

    public static void initBaseData(Map<String, Object> customParams, IDataModel dataModel) {
        dataModel.setValue(ORG, customParams.get(PARA_ORG));
        dataModel.setValue("declaredate", customParams.get("declaredate"));
        dataModel.setValue("taxauthority", customParams.get("taxauthority"));
        dataModel.setValue("billno", customParams.get("billno"));
    }

    public static void setActiveTab(String tabKey, IFormView formView, Map<String, String> pageMap) {
        HashMap<String, Object> stylemap = new HashMap<String, Object>(2);
        stylemap.put("bc", "#F3F6FF");
        String linestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", linestyle);
        style.put("b", border);
        stylemap.put("s", style);
        formView.updateControlMetadata(tabKey, stylemap);
        HashMap<String, Object> stylemap1 = new HashMap<String, Object>(2);
        stylemap1.put("bc", "#ffffff");
        String linestyle1 = "0px_solid_#ffffff";
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("b", linestyle1);
        style1.put("b", border1);
        stylemap1.put("s", style1);
        Arrays.asList(tab_keys).forEach(key -> {
            if (!key.equals(tabKey)) {
                formView.updateControlMetadata(key, stylemap1);
            }
        });
        DeclareShowUtils.showTab(tabKey, formView, pageMap);
    }

    public static void showTab(String tableKey, IFormView formView, Map<String, String> pageMap) {
        String formId = pageMap.get(tableKey);
        Map customParams = formView.getFormShowParameter().getCustomParams();
        customParams.put("from", "history");
        customParams.put("btn_visible", false);
        String templatetype = (String)customParams.get("templatetype");
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(Long.valueOf(Long.parseLong(customParams.getOrDefault("sbbid", "0"))));
        requestModel.setOrgId(Long.valueOf(Long.parseLong(customParams.getOrDefault(PARA_ORG, "0"))));
        requestModel.setTemplateType(templatetype);
        requestModel.setOperation("read");
        requestModel.setSkssqq((String)customParams.get("skssqq"));
        requestModel.setSkssqz((String)customParams.get("skssqz"));
        DynamicObject object = DeclareShowUtils.queryHistoryNsrxx(templatetype, DeclareShowUtils.getParam(formView, PARA_ORG), DeclareShowUtils.getParam(formView, "skssqq"), DeclareShowUtils.getParam(formView, "skssqz"));
        if (object != null && StringUtils.isNotEmpty((CharSequence)object.getString("templateid"))) {
            customParams.put("templateid", object.getString("templateid"));
        }
        if ("bdtaxr_history_sbb".equals(customParams.get("entityid"))) {
            requestModel.setDataSource("history");
        }
        if ("bdtaxr_taxbureau_sbb".equals(customParams.get("entityid"))) {
            requestModel.setDataSource("taxBureau");
        }
        requestModel.setRefresh(Boolean.valueOf(false));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        if (!StringUtils.isEmpty((CharSequence)formId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            parameter.setCustomParams(customParams);
            parameter.setStatus(OperationStatus.VIEW);
            formView.showForm(parameter);
        }
    }

    private static DynamicObject queryHistoryNsrxx(String templateType, String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        QFilter qFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId)).and("skssqq", "=", (Object)DateUtils.stringToDate((String)startdate)).and("skssqz", "=", (Object)DateUtils.stringToDate((String)enddate)).and("type", "=", (Object)templateType);
        return QueryServiceHelper.queryOne((String)"bdtaxr_history_sbb", (String)"templateid, id,modifytime, creator, datatype", (QFilter[])qFilter.toArray());
    }

    private static String getParam(IFormView formView, String param) {
        Map customParams = formView.getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }
}

