/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.tcret.business.taxsource.egine.HouseRentAutoCollectEngine;
import kd.taxc.tcret.business.taxsource.egine.TdzzsYjAutoCollectEngine;
import kd.taxc.tcret.business.taxsource.egine.YhsTaxSourceGatherEngine;

public class EngineUtils {
    private static final Map<String, IEngine<EngineModel>> engineMap = new HashMap<String, IEngine<EngineModel>>();

    public static void execute(List<EngineModel> engineModels) {
        try (TXHandle h = TX.requiresNew();){
            try {
                for (EngineModel engineModel : engineModels) {
                    Map custom = engineModel.getCustom();
                    String fromClass = (String)custom.get("FromClass");
                    IEngine<EngineModel> engine = engineMap.get(fromClass);
                    if (engine == null) {
                        engine = engineMap.get("Default");
                    }
                    engine.deleteData(engineModel);
                    engine.runEngine(engineModel);
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    static {
        engineMap.put("Default", new YhsTaxSourceGatherEngine());
        engineMap.put("HouseRentAutoCollect", new HouseRentAutoCollectEngine());
        engineMap.put("TdzzsYjAutoCollectEngine", new TdzzsYjAutoCollectEngine());
    }
}

