/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.SourceOperateHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.EntityMappingUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.business.declare.engine.EngineService;
import kd.taxc.tcret.business.declare.engine.impl.CcsEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.FcsHireEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.FcsPriceEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.FcsTdsEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.HbsAqEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.QsEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.TdzzsEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.TdzzsQsEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.TdzzsYjEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.YhsacEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.YhsaqEngineServiceImpl;
import kd.taxc.tcret.business.declare.engine.impl.ZysAqEngineServiceImpl;
import kd.taxc.tcret.common.enums.TcretTaxTypeEnum;
import kd.taxc.tcret.common.enums.TcretTypeEnum;
import kd.taxc.tcret.common.enums.TdzzsSourceEnum;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;
import org.apache.commons.collections.CollectionUtils;

public class PbtDeclareUtil {
    private static final String PAGE_0 = "0";
    protected static final String ORGID_KEY = "org";
    private static final String ID = "id";
    protected static final String FOCUS_PAGE = "focuspage";
    protected static final String NEXT_KEY = "next";
    protected static final String FORWARD_KEY = "forward";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String SUBMIT_KEY = "submit";
    protected static final String TAX_SOURCE = "taxsource";
    protected static final String BILL_STATUS = "cache_billstatus";
    private static final String STATUS_ENTITY = "tcret_declare_main";
    public static final String MONTH = "month";
    public static final String SEASON = "season";
    public static final String YEAR = "year";
    public static final String HALF_YEAR = "halfyear";
    public static final String MONTHBEFORE = "monthbefore";
    public static final String MONTHAFTER = "monthafter";
    public static final String SEASONBEFORE = "seasonbefore";
    public static final String SEASONAFTER = "seasonafter";
    public static final String HALFYEARBEFORE = "halfyearbefore";
    public static final String HALFYEARAFTER = "halfyearafter";
    public static final String YEARBEFORE = "yearbefore";
    public static final String YEARAFTER = "yearafter";
    private static final Set<String> GTGSH = new LinkedHashSet<String>(Arrays.asList("410", "411", "412", "413"));
    private static final Map<String, EngineService> engineServiceMap = new HashMap<String, EngineService>(){
        {
            this.put("fcscj", new FcsPriceEngineServiceImpl());
            this.put("fcscz", new FcsHireEngineServiceImpl());
            this.put("cztdsys", new FcsTdsEngineServiceImpl());
            this.put("yhsac", new YhsacEngineServiceImpl());
            this.put("yhsaq", new YhsaqEngineServiceImpl());
            this.put("hbsaq", new HbsAqEngineServiceImpl());
            this.put("ccscl", new CcsEngineServiceImpl());
            this.put("ccscb", new CcsEngineServiceImpl());
            this.put("qs", new QsEngineServiceImpl());
            this.put("tdzzs", new TdzzsEngineServiceImpl());
            this.put("tdzzsyj", new TdzzsYjEngineServiceImpl());
            this.put("tdzzsqs", new TdzzsQsEngineServiceImpl());
            this.put("zysaj", new ZysAqEngineServiceImpl());
            this.put("zysay", new ZysAqEngineServiceImpl());
            this.put("zysac", new ZysAqEngineServiceImpl());
        }
    };

    public static Map<String, EngineService> getEngineServiceMap() {
        return engineServiceMap;
    }

    public static EngineService getEngineService(String taxType) {
        return engineServiceMap.get(taxType);
    }

    public static String getOrgId(IFormView getView) {
        List nodeList = OrgUtils.getAllPermNodes((String)getView.getFormShowParameter().getAppId(), (String)getView.getEntityId(), (String)"fcscztdsys");
        String currOrgId = String.valueOf(RequestContext.get().getOrgId());
        DynamicObject org = null;
        try {
            org = (DynamicObject)getView.getParentView().getModel().getValue(ORGID_KEY);
            currOrgId = org.getString(ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TreeNode defaultOrg = null;
        for (TreeNode node : nodeList) {
            if (!currOrgId.equals(node.getId())) continue;
            defaultOrg = node;
            break;
        }
        if (!nodeList.isEmpty()) {
            List roots;
            if (defaultOrg == null && EmptyCheckUtils.isNotEmpty((Object)(roots = TreeUtils.findRoot((List)nodeList)))) {
                defaultOrg = (TreeNode)roots.get(0);
            }
        } else {
            DeclareStepsUtils.resetSteps((int)TaxStepsConstant.getPbt().size(), (String)"-1", (String)PAGE_0, (IFormView)getView);
            return null;
        }
        if (defaultOrg != null) {
            return defaultOrg.getId();
        }
        return null;
    }

    public static String queryTaxOffice(String orgid) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgid));
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            return ((DynamicObject)taxResult.getData()).getString("taxoffice.id");
        }
        return PAGE_0;
    }

    public static Date initDeclareMonth(Date date, IDataModel getModel, IPageCache getPageCache) {
        getModel.setValue("declaremonth", (Object)date);
        getPageCache.put("declaremonth", DateUtils.format((Date)date, (String)"yyyy-MM-dd"));
        return date;
    }

    public static FormShowParameter createShowParameter(Map<String, DeclarePageType> declarePageMap, String focuspage, OperationStatus operationStatus) {
        DeclarePageType declarePageType = declarePageMap.get(focuspage);
        String entity = declarePageType.getEntity();
        FormShowParameter param = new FormShowParameter();
        param.setFormId(entity);
        param.setStatus(operationStatus);
        return param;
    }

    public static void lightenForStatus(Map<String, DeclarePageType> declarePageMap, String focuspage, String status, IFormView getView, IPageCache getPageCache) {
        DeclareStepsUtils.resetSteps((int)declarePageMap.size(), (String)focuspage, (String)status, (IFormView)getView);
        PbtDeclareUtil.setButtonVisible(focuspage, getView, getPageCache, declarePageMap);
        getPageCache.put(FOCUS_PAGE, focuspage);
    }

    protected static void setButtonVisible(String focuspage, IFormView getView, IPageCache getPageCache, Map<String, DeclarePageType> declarePageMap) {
        if ("1".equals(focuspage)) {
            getView.setVisible(Boolean.FALSE, new String[]{FORWARD_KEY, EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY});
            getView.setVisible(Boolean.TRUE, new String[]{NEXT_KEY});
        } else if (focuspage.equals(String.valueOf(declarePageMap.size()))) {
            getView.setVisible(Boolean.TRUE, new String[]{FORWARD_KEY});
            if ("A".equals(getPageCache.get(BILL_STATUS)) || StringUtils.isBlank((CharSequence)getPageCache.get(BILL_STATUS))) {
                getView.setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, EDIT_KEY});
            } else {
                getView.setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, EDIT_KEY});
            }
            getView.setVisible(Boolean.FALSE, new String[]{NEXT_KEY, SAVE_KEY, CANCEL_KEY, TAX_SOURCE});
        } else {
            getView.setVisible(Boolean.TRUE, new String[]{FORWARD_KEY, NEXT_KEY, TAX_SOURCE});
            getView.setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, SAVE_KEY, CANCEL_KEY});
        }
    }

    public static boolean verifyRegistertime(String orgId, String enddate) {
        boolean isSuss = true;
        if (EmptyCheckUtils.isNotEmpty((Object)orgId) && EmptyCheckUtils.isNotEmpty((Object)enddate)) {
            TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgId));
            if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData())) {
                return true;
            }
            DynamicObject dynamicObject = (DynamicObject)taxResult.getData();
            Date fregistertime = dynamicObject.getDate("registertime");
            if (Objects.nonNull(fregistertime) && fregistertime.after(DateUtils.stringToDate((String)enddate))) {
                isSuss = false;
            }
            return isSuss;
        }
        return true;
    }

    public static DynamicObject createTcretDeclareMain(String declaredate, String taxauthority, List<DynamicObject> declareItems, String orgid, String status) {
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)STATUS_ENTITY);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        String billno = DeclareServiceHelper.generateSBBNo((String)entityName, (DynamicObject)dynamicObject, (String)orgid);
        Long sbbId = DeclareServiceHelper.generateSBBId((String)"tcvat_nsrxx");
        long maindataid = DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
        Map<String, String> skssqzMap = PbtDeclareUtil.getSkssqzMap(declareItems);
        String isXxwlqy = PbtDeclareUtil.getXxwlqy(orgid, skssqzMap);
        dynamicObject.set(ID, (Object)maindataid);
        dynamicObject.set("billno", (Object)billno);
        dynamicObject.set("declaredate", (Object)DateUtils.stringToDate((String)declaredate));
        dynamicObject.set(ORGID_KEY, (Object)Long.valueOf(orgid));
        dynamicObject.set("taxauthority", (Object)taxauthority);
        dynamicObject.set("status", (Object)status);
        dynamicObject.set("billstatus", (Object)"A");
        dynamicObject.set("datatype", (Object)"1");
        dynamicObject.set("sbbid", (Object)sbbId);
        dynamicObject.set("isxxwlqy", (Object)isXxwlqy);
        Boolean detaildeclare = TcretSystemParamUtil.getDetailDeclare(Long.parseLong(orgid));
        dynamicObject.set("detaildeclare", (Object)detaildeclare);
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        declareItems.forEach(c -> {
            DynamicObject entryObject = entryentity.addNew();
            entryObject.set("taxtype", (Object)c.getString("taxtype"));
            if (StringUtils.isNotEmpty((CharSequence)c.getString("taxtype")) && c.getString("taxtype").length() == 5) {
                entryObject.set("taxtypebrief", (Object)c.getString("taxtype").substring(0, 3));
            } else {
                entryObject.set("taxtypebrief", (Object)c.getString("taxtype"));
            }
            entryObject.set("skssqq", (Object)c.getDate("skssqq"));
            entryObject.set("skssqz", (Object)c.getDate("skssqz"));
            entryObject.set("taxlimit", (Object)c.getString("taxlimit"));
            entryObject.set("taxstatus", (Object)"A");
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    private static String getXxwlqy(String orgid, Map<String, String> skssqzMap) {
        Date skssqz;
        if (skssqzMap.isEmpty()) {
            return "false";
        }
        Date skssqq = DateUtils.stringToDate((String)skssqzMap.get("skssqq"));
        DynamicObject dynamicObject = OrgChangeRecordUtil.loadChangeRecord((String)orgid, (Date)skssqq, (Date)(skssqz = DateUtils.stringToDate((String)skssqzMap.get("skssqz"))));
        if (dynamicObject != null) {
            String taxpayertype = dynamicObject.getString("taxpayertype");
            String registertype = "";
            String xxwlqy = "";
            TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.valueOf(orgid));
            if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject taxMainInfo = (DynamicObject)taxResult.getData();
                registertype = taxMainInfo.getString("registertype.number");
                xxwlqy = TaxBaseDataUtils.queryQysdsXxwlqy((Long)Long.valueOf(orgid), (Date)skssqq, (Date)skssqz, (DynamicObject)dynamicObject, (DynamicObject)taxMainInfo);
            }
            if ("ybnsr".equals(taxpayertype) && !GTGSH.contains(registertype)) {
                if ("1".equals(xxwlqy)) {
                    return "true";
                }
                if (PAGE_0.equals(xxwlqy)) {
                    return "false";
                }
                return "";
            }
        }
        return "false";
    }

    public static void updateDeclareMain(Long sbbid, DynamicObjectCollection collection, String orgid, Map<String, Object> customParams) {
        String entityName = EntityMappingUtils.getEntityName((OperationStatus)OperationStatus.EDIT, (String)STATUS_ENTITY);
        DynamicObject tcretMain = QueryServiceHelper.queryOne((String)entityName, (String)ID, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        if (tcretMain == null) {
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)tcretMain.getLong(ID), (String)entityName);
        object.set("status", customParams.get("status"));
        object.set("declarestatus", (Object)"editing");
        object.set("paystatus", (Object)"unpaid");
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("datatype", (Object)"1");
        object.set("isxxwlqy", customParams.get("isxxwlqy"));
        object.set("detaildeclare", EmptyCheckUtils.isEmpty((Object)customParams.get("detaildeclare")) ? "false" : customParams.get("detaildeclare"));
        DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        DynamicObjectCollection entryCollection = new DynamicObjectCollection();
        collection.forEach(c -> {
            DynamicObject entryObject = entryentity.addNew();
            entryObject.set("taxtype", (Object)c.getString("taxtype"));
            if (StringUtils.isNotEmpty((CharSequence)c.getString("taxtype")) && c.getString("taxtype").length() == 5) {
                entryObject.set("taxtypebrief", (Object)c.getString("taxtype").substring(0, 3));
            } else {
                entryObject.set("taxtypebrief", (Object)c.getString("taxtype"));
            }
            entryObject.set("skssqq", (Object)c.getDate("skssqq"));
            entryObject.set("skssqz", (Object)c.getDate("skssqz"));
            entryObject.set("taxlimit", (Object)c.getString("taxlimit"));
            entryObject.set("taxstatus", (Object)"A");
            entryCollection.add((Object)entryObject);
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public static DynamicObjectCollection queryAllRecord(OperationStatus operationStatus, String orgid, String declaremonth, String taxoffice) {
        QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)(StringUtils.isBlank((CharSequence)orgid) ? 0L : Long.parseLong(orgid)));
        QFilter taxofficeFilter = new QFilter("taxauthority", "=", (Object)Long.valueOf(taxoffice));
        Date declareDate = DateUtils.stringToDate((String)declaremonth);
        Date startDate = DateUtils.getFirstDateOfMonth((Date)declareDate);
        Date endDate = DateUtils.getLastDateOfMonth((Date)declareDate);
        QFilter declareMonthFilter = new QFilter("declaredate", ">=", (Object)DateUtils.getDayFirst((Date)startDate)).and(new QFilter("declaredate", "<=", (Object)DateUtils.getDayLast((Date)endDate)));
        return QueryServiceHelper.query((String)EntityMappingUtils.getEntityName((OperationStatus)operationStatus, (String)STATUS_ENTITY), (String)"id,sbbid,entryentity.taxtype as taxtype, entryentity.skssqq as skssqq, entryentity.skssqz as skssqz, entryentity.taxlimit as taxlimit, entryentity.taxstatus as taxstatus,billstatus, status", (QFilter[])new QFilter[]{orgFilter, taxofficeFilter, declareMonthFilter});
    }

    public static void taxSourceHyperLink(DynamicObject selectedRow, IFormView getView, IFormPlugin plugin) {
        String taxType = selectedRow.getString("taxType");
        Map params = getView.getFormShowParameter().getCustomParams();
        params.put("skssqq", selectedRow.getDate("skssqq"));
        params.put("skssqz", selectedRow.getDate("skssqz"));
        params.put("taxlimit", selectedRow.getString("taxlimit"));
        params.put("taxType", taxType);
        String sourceEntity = TcretTaxTypeEnum.getSourceEntity(taxType);
        if (EmptyCheckUtils.isNotEmpty((Object)sourceEntity)) {
            TdzzsSourceEnum tdzzsSourceEnum = TdzzsSourceEnum.valueOfTaxType(taxType);
            if (tdzzsSourceEnum != null) {
                params.put("taxtype", "latyj,latqs,latwp");
                params.put("querytype", tdzzsSourceEnum.getTemplateType());
            }
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)sourceEntity, (IFormView)getView, (Map)params);
        } else {
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"hbs_source_info_dialog", (IFormView)getView, (Map)params, (IFormPlugin)plugin);
        }
    }

    public static boolean isSubmitOrAudit(IPageCache getPagecache, IFormView getView) {
        String billstatus = "A";
        getPagecache.put(BILL_STATUS, billstatus);
        String sbbid = getPagecache.get("sbbid");
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)(EmptyCheckUtils.isNotEmpty((Object)sbbid) ? Long.parseLong(sbbid) : 0L))});
        if (nsrxx != null) {
            billstatus = nsrxx.getString("billstatus");
            getPagecache.put(BILL_STATUS, billstatus);
            DynamicObject declareObject = QueryServiceHelper.queryOne((String)STATUS_ENTITY, (String)"status", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)Long.valueOf(sbbid))});
            if (declareObject != null) {
                getPagecache.put("status", declareObject.getString("status"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
            DynamicObject org = (DynamicObject)getView.getModel().getValue("orgid");
            String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"PbtDeclareUtil_1", (String)"taxc-tcret", (Object[])new Object[0]);
            if ("C".equals(billstatus)) {
                statusName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"PbtDeclareUtil_2", (String)"taxc-tcret", (Object[])new Object[0]);
            }
            String msg = String.format(ResManager.loadKDString((String)"\u8be5\u8d22\u4ea7\u548c\u884c\u4e3a\u7a0e\u7533\u62a5\u8868\u5df2%s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"PbtDeclareUtil_3", (String)"taxc-tcret", (Object[])new Object[0]), statusName);
            getView.showTipNotification(msg, Integer.valueOf(5000));
            return true;
        }
        return false;
    }

    public static Map<String, Date> getDateMap(Date date, String taxLimit, String taxtimepoint, int endmonth) {
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        Date skssqq = null;
        Date skssqz = null;
        switch (taxLimit) {
            case "month": {
                if (MONTHBEFORE.equals(taxtimepoint)) {
                    skssqq = DateUtils.getFirstDateOfMonth((Date)date);
                    skssqz = DateUtils.getLastDateOfMonth((Date)date);
                    break;
                }
                if (!MONTHAFTER.equals(taxtimepoint)) break;
                Date lastMonth = DateUtils.addMonth((Date)date, (int)-1);
                skssqq = DateUtils.getFirstDateOfMonth((Date)lastMonth);
                skssqz = DateUtils.getLastDateOfMonth((Date)lastMonth);
                break;
            }
            case "season": {
                if (SEASONBEFORE.equals(taxtimepoint)) {
                    skssqq = DateUtils.getFirstDateOfSeason((Date)date);
                    skssqz = DateUtils.getLastDateOfSeason((Date)date);
                    break;
                }
                if (!SEASONAFTER.equals(taxtimepoint)) break;
                Date lastSeason = DateUtils.addMonth((Date)date, (int)-3);
                skssqq = DateUtils.getFirstDateOfSeason((Date)lastSeason);
                skssqz = DateUtils.getLastDateOfSeason((Date)lastSeason);
                break;
            }
            case "halfyear": {
                if (HALFYEARBEFORE.equals(taxtimepoint)) {
                    skssqq = DateUtils.getFirstDateOfHalfYear((Date)date);
                    skssqz = DateUtils.getLastDateOfHalfYear((Date)date);
                    break;
                }
                if (!HALFYEARAFTER.equals(taxtimepoint)) break;
                Date lastHalfYear = DateUtils.addMonth((Date)date, (int)-6);
                skssqq = DateUtils.getFirstDateOfHalfYear((Date)lastHalfYear);
                skssqz = DateUtils.getLastDateOfHalfYear((Date)lastHalfYear);
                break;
            }
            case "year": {
                if (YEARBEFORE.equals(taxtimepoint)) {
                    if (DateUtils.getMonthOfDate((Date)date) <= 12 - endmonth) break;
                    skssqq = DateUtils.getFirstDateOfYear((Date)date);
                    skssqz = DateUtils.getLastDateOfYear((Date)date);
                    break;
                }
                if (!YEARAFTER.equals(taxtimepoint)) break;
                Date lastYear = DateUtils.addYear((Date)date, (int)-1);
                skssqq = DateUtils.getFirstDateOfYear((Date)lastYear);
                skssqz = DateUtils.getLastDateOfYear((Date)lastYear);
            }
        }
        dateMap.put("skssqq", skssqq);
        if (skssqz != null) {
            dateMap.put("skssqz", DateUtils.getDayFirst((Date)skssqz));
        }
        return dateMap;
    }

    public static void setBtnVisible(IFormView view, Map<String, List<String>> btnMap, String focuspage, OperationStatus operationStatus) {
        HashSet totalBtns = new HashSet();
        btnMap.forEach((key, value) -> totalBtns.addAll(value));
        List<String> stepBtns = btnMap.get(focuspage + "-" + operationStatus.name());
        for (String btn : totalBtns) {
            view.setVisible(Boolean.valueOf(stepBtns.contains(btn)), new String[]{btn});
        }
    }

    public static Map<String, List<Long>> runDraftEngine(List<DynamicObject> declareItems, Map<String, Object> customParams) {
        HashMap<String, List<Long>> draftIdMap = new HashMap<String, List<Long>>(8);
        String orgid = (String)customParams.get("orgid");
        long sbbid = Long.parseLong((String)customParams.get("sbbid"));
        EngineModel deleteModel = new EngineModel(orgid, null, null);
        deleteModel.addCustom("sbbid", (Object)sbbid);
        deleteModel.addCustom("OperationStatus", (Object)OperationStatus.EDIT);
        SourceOperateHelper.deleteSourceTpEntity((String)"ccxws", (Long)sbbid, (String)"tcret_declare_main_tp");
        if (CollectionUtils.isNotEmpty(declareItems)) {
            DynamicObjectCollection objects = new DynamicObjectCollection();
            for (DynamicObject declareItem : declareItems) {
                Date skssqq = declareItem.getDate("skssqq");
                Date skssqz = declareItem.getDate("skssqz");
                String taxlimit = declareItem.getString("taxlimit");
                PbtDeclareUtil.mappingDraftSourceDetail(customParams, (String)declareItem.get("taxtype"), skssqq, skssqz, draftIdMap);
                EntityType entityType = (EntityType)EntityMetadataCache.getDataEntityType((String)"tcret_declare_main_tp").getAllEntities().get("entryentity");
                DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
                object.set("taxtype", declareItem.get("taxtype"));
                object.set("skssqq", (Object)skssqq);
                object.set("skssqz", (Object)skssqz);
                object.set("taxlimit", (Object)taxlimit);
                objects.add((Object)object);
            }
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("status", "2");
            custom.put("isxxwlqy", customParams.get("isxxwlqy"));
            custom.put("detaildeclare", customParams.get("detaildeclare"));
            PbtDeclareUtil.updateDeclareMain(sbbid, objects, orgid, custom);
        }
        return draftIdMap;
    }

    private static void mappingDraftSourceDetail(Map<String, Object> customParams, String taxtype, Date skssqq, Date skssqz, Map<String, List<Long>> draftIdMap) {
        DynamicObjectCollection draftList;
        String orgid = (String)customParams.get("orgid");
        Long taxoffice = Long.parseLong((String)customParams.get("taxoffice"));
        String declaremonth = (String)customParams.get("declaremonth");
        long sbbid = Long.parseLong((String)customParams.get("sbbid"));
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter q1 = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgid));
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxoffice);
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate2((String)declaremonth));
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate2((String)declaremonth));
        QFilter q3 = new QFilter("collectiondate", ">=", (Object)firstDateOfMonth).and(new QFilter("collectiondate", "<=", (Object)lastDateOfMonth));
        filters.add(q1);
        filters.add(q2);
        filters.add(q3);
        String selectFiled = "id,entryentity.sourcedetailid,entryentity.xgmsourcedetailid";
        if (taxtype.startsWith("ccs")) {
            QFilter q4 = new QFilter("sourcetype", "=", (Object)taxtype);
            filters.add(q4);
            selectFiled = "id,entryentity.sourcedetailid";
        }
        if (StringUtil.isNotBlank((CharSequence)TcretTypeEnum.getDraftByType(taxtype)) && CollectionUtils.isNotEmpty((Collection)(draftList = QueryServiceHelper.query((String)TcretTypeEnum.getDraftByType(taxtype), (String)selectFiled, (QFilter[])filters.toArray(new QFilter[0]))))) {
            DynamicObject[] load;
            ArrayList<DynamicObject> newSourceObjList = new ArrayList<DynamicObject>(8);
            ArrayList<Long> ids = new ArrayList<Long>(8);
            for (DynamicObject draft : draftList) {
                List<Long> draftIds = draftIdMap.get(taxtype);
                if (draftIds == null) {
                    draftIds = new ArrayList<Long>(6);
                    draftIds.add(draft.getLong(ID));
                    draftIdMap.put(taxtype, draftIds);
                } else {
                    draftIds.add(draft.getLong(ID));
                    draftIdMap.put(taxtype, draftIds);
                }
                long sourcedetailid = draft.getLong("entryentity.sourcedetailid");
                ids.add(sourcedetailid);
                if (taxtype.startsWith("ccs")) continue;
                long xgmsourcedetailid = draft.getLong("entryentity.xgmsourcedetailid");
                ids.add(xgmsourcedetailid);
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)TcretTypeEnum.getEntityNameTpByType(taxtype));
            for (DynamicObject object : load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType)) {
                DynamicObject nrxxObj = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_nsrxx");
                nrxxObj.set(ID, (Object)sbbid);
                object.set("sbbid", (Object)nrxxObj);
                DynamicObject newScource = BeanCopyUtils.copyDataExcludePKId((DynamicObject)object);
                newScource.set("draftid", (Object)0L);
                newSourceObjList.add(newScource);
            }
            SaveServiceHelper.save((DynamicObject[])newSourceObjList.toArray(new DynamicObject[0]));
        }
    }

    public static void runEngine(List<DynamicObject> declareItems, Map<String, Object> customParams) {
        String orgid = (String)customParams.get("orgid");
        long sbbid = Long.parseLong((String)customParams.get("sbbid"));
        EngineModel deleteModel = new EngineModel(orgid, null, null);
        deleteModel.addCustom("sbbid", (Object)sbbid);
        deleteModel.addCustom("OperationStatus", (Object)OperationStatus.EDIT);
        SourceOperateHelper.deleteSourceTpEntity((String)"ccxws", (Long)sbbid, (String)"tcret_declare_main_tp");
        if (CollectionUtils.isNotEmpty(declareItems)) {
            Map<String, String> skssqzMap = PbtDeclareUtil.getSkssqzMap(declareItems);
            String reliefPolicyType = TaxBaseDataUtils.getReliefPolicyType((Long)Long.parseLong(orgid), (Date)DateUtils.stringToDate((String)skssqzMap.get("skssqq")), (Date)DateUtils.stringToDate((String)skssqzMap.get("skssqz")), (boolean)true);
            Boolean changeEffectCurrentMonth = TcretSystemParamUtil.getChangeEffectCurrentMonth(Long.parseLong(orgid));
            DynamicObjectCollection objects = new DynamicObjectCollection();
            declareItems.forEach(c -> {
                Date skssqq = c.getDate("skssqq");
                Date skssqz = c.getDate("skssqz");
                String taxlimit = c.getString("taxlimit");
                EngineModel engineModel = new EngineModel(orgid, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz));
                engineModel.addCustom("changeeffectcurrentmonth", (Object)changeEffectCurrentMonth);
                engineModel.addCustom("taxlimit", (Object)taxlimit);
                engineModel.addCustom("sbbid", (Object)sbbid);
                engineModel.addCustom("declaremonth", (Object)DateUtils.stringToDate((String)((String)customParams.get("declaremonth"))));
                engineModel.addCustom("taxoffice", customParams.get("taxoffice"));
                engineModel.addCustom("declarestatus", customParams.get("declarestatus"));
                engineModel.addCustom("sbbbillstatus", customParams.get("sbbbillstatus"));
                engineModel.addCustom("sbbbillno", customParams.get("declarenumber"));
                engineModel.addCustom("taxtype", c.get("taxtype"));
                engineModel.addCustom("skssqz", c.get("skssqz"));
                if ("true".equals(customParams.get("isxxwlqy"))) {
                    engineModel.addCustom("reliefPolicy", (Object)"xxwlqy");
                } else if (("false".equals(customParams.get("isxxwlqy")) || "".equals(customParams.get("isxxwlqy"))) && "xxwlqy".equals(reliefPolicyType)) {
                    engineModel.addCustom("reliefPolicy", (Object)"");
                } else {
                    engineModel.addCustom("reliefPolicy", (Object)reliefPolicyType);
                }
                EngineService engineService = PbtDeclareUtil.getEngineService(c.getString("taxtype"));
                engineService.runEngine(engineModel);
                EntityType entityType = (EntityType)EntityMetadataCache.getDataEntityType((String)"tcret_declare_main_tp").getAllEntities().get("entryentity");
                DynamicObject object = new DynamicObject((DynamicObjectType)entityType);
                object.set("taxtype", c.get("taxtype"));
                object.set("skssqq", (Object)skssqq);
                object.set("skssqz", (Object)skssqz);
                object.set("taxlimit", (Object)taxlimit);
                objects.add((Object)object);
            });
            HashMap<String, Object> custom = new HashMap<String, Object>();
            custom.put("status", "2");
            custom.put("isxxwlqy", customParams.get("isxxwlqy"));
            custom.put("detaildeclare", customParams.get("detaildeclare"));
            PbtDeclareUtil.updateDeclareMain(sbbid, objects, orgid, custom);
        }
    }

    public static Map<String, String> getSkssqzMap(List<DynamicObject> collection) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(collection)) {
            Date skssqq = null;
            Date skssqz = null;
            for (DynamicObject object : collection) {
                if (null == skssqq || null == skssqz) {
                    skssqq = object.getDate("skssqq");
                    skssqz = object.getDate("skssqz");
                }
                if (skssqq.compareTo(object.getDate("skssqq")) > 0) {
                    skssqq = object.getDate("skssqq");
                }
                if (skssqz.compareTo(object.getDate("skssqz")) >= 0) continue;
                skssqz = object.getDate("skssqz");
            }
            map.put("skssqq", DateUtils.format(skssqq));
            map.put("skssqz", DateUtils.format(skssqz));
        }
        return map;
    }

    public static BigDecimal ajustJmse(String reliefPolicyType, DynamicObject changeRecord, Date skssqq, Date skssqz, BigDecimal jmhse) {
        Date taxstartdate = changeRecord.getDate("taxstartdate");
        if (StringUtil.isBlank((CharSequence)reliefPolicyType) && taxstartdate != null && taxstartdate.compareTo(skssqq) > 0 && taxstartdate.compareTo(skssqz) < 0) {
            int monthLength = DateUtils.getMonthDiff((Date)skssqz, (Date)skssqq) + 1;
            int count = DateUtils.getMonthDiff((Date)skssqz, (Date)taxstartdate) + 1;
            return BigDecimalUtil.divideObject((Object)BigDecimalUtil.multiplyObject((Object)jmhse, (Object)count, (int)2, (int)4), (Object)monthLength, (int)2);
        }
        return jmhse;
    }

    public static List<Long> getLicenseCheckSuccessOrgList(Map<Long, Boolean> licenseMap) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        for (Map.Entry<Long, Boolean> entry : licenseMap.entrySet()) {
            if (!Boolean.FALSE.equals(entry.getValue())) continue;
            orgList.add(entry.getKey());
        }
        return orgList;
    }
}

