/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class YhsUtils {
    public static final Date YHS_NEW_VERSION_DATE = DateUtils.stringToDate2((String)"2022-07-01");

    public static String getSbbBillStatus(Long org, Date skssqq, Date skssqz, DynamicObject taxoffice) {
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        QFilter typeFilter = new QFilter("type", "=", (Object)"ccxws");
        if (taxoffice != null) {
            qFilter.and(new QFilter("taxauthority", "=", (Object)taxoffice.getLong("id")));
        }
        DynamicObjectCollection sbbList = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter, typeFilter});
        List sbbids = sbbList.stream().map(a -> a.getString("id")).collect(Collectors.toList());
        Map<String, String> idTobillstatus = sbbList.stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b.getString("billstatus"), (m, n) -> n));
        QFilter taxtypeQfilter = new QFilter("taxtype", "=", (Object)ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"YhsUtils_1", (String)"taxc-tcret", (Object[])new Object[0]));
        QFilter sbbidQfilter = new QFilter("sbbid", "in", sbbids);
        QFilter qFilter3 = new QFilter("startdate", "=", (Object)DateUtils.getFirstDateOfMonth((Date)skssqq)).and("enddate", "=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
        DynamicObject zbHbObject = QueryServiceHelper.queryOne((String)"tcret_ccxws_zb_hb", (String)"sbbid", (QFilter[])new QFilter[]{sbbidQfilter, taxtypeQfilter, qFilter3});
        if (zbHbObject != null) {
            return idTobillstatus.get(zbHbObject.getString("sbbid"));
        }
        return null;
    }

    public static Map<String, String> getSbbBillStatus(Long org, Date skssqq, Date skssqz, String key, DynamicObject[] sy) {
        DynamicObjectCollection zbHbObject;
        HashMap<String, String> map = new HashMap<String, String>(10);
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        QFilter typeFilter = new QFilter("type", "=", (Object)"ccxws");
        DynamicObjectCollection sbbList = QueryServiceHelper.query((String)"tctb_declare_main", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter, typeFilter});
        List sbbids = sbbList.stream().map(a -> a.getString("id")).collect(Collectors.toList());
        Map<String, String> idTobillstatus = sbbList.stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b.getString("billstatus"), (m, n) -> n));
        List acsbSkssqzList = Arrays.stream(sy).filter(a -> "acsb".equals(a.getString("declaretype"))).map(b -> b.getDate("skssqz")).collect(Collectors.toList());
        QFilter taxtypeQfilter = new QFilter("taxtype", "=", (Object)ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"YhsUtils_1", (String)"taxc-tcret", (Object[])new Object[0]));
        QFilter sbbidQfilter = new QFilter("sbbid", "in", sbbids);
        QFilter skssqQfilter = new QFilter("startdate", "=", (Object)DateUtils.getFirstDateOfMonth((Date)skssqq)).and("enddate", "=", (Object)DateUtils.getLastDateOfMonth2((Date)skssqz));
        if ("count".equals(key)) {
            skssqQfilter = new QFilter("startdate", "in", acsbSkssqzList).and("enddate", "in", acsbSkssqzList);
        }
        if ((zbHbObject = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"sbbid,sm,startdate,enddate", (QFilter[])new QFilter[]{sbbidQfilter, taxtypeQfilter, skssqQfilter})) != null) {
            for (DynamicObject object : zbHbObject) {
                String mapKey = object.getString("sm") + "_" + DateUtils.format((Date)object.getDate("startdate")) + "_" + DateUtils.format((Date)object.getDate("enddate"));
                map.put(mapKey, idTobillstatus.get(object.getString("sbbid")));
            }
        }
        return map;
    }

    public static boolean isExistTaxItem(DynamicObject taxitem, DynamicObject org, Date skssqq, Date skssqz) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(org.getLong("id")));
        if (!taxResult.isSuccess() || EmptyCheckUtils.isEmpty((Object)taxResult.getData())) {
            return false;
        }
        DynamicObjectCollection yhsentity = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity");
        String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        Optional<DynamicObject> first = yhsentity.stream().filter(d -> d.getLong("taxrate.id") == taxitem.getLong("id") && YhsUtils.isValidate(d, skssqq, skssqz, "aqsb", taxLimit)).findFirst();
        return first.isPresent();
    }

    public static List<DynamicObject> queryYhsEntity(Long orgid, Date skssqq, Date skssqz, String declaretype) {
        if (orgid == null || skssqq == null || skssqz == null) {
            return new ArrayList<DynamicObject>();
        }
        String period = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgid));
        if (!result.isSuccess() || EmptyCheckUtils.isEmpty((Object)result.getData())) {
            return new ArrayList<DynamicObject>();
        }
        DynamicObject taxMain = (DynamicObject)((List)result.getData()).get(0);
        DynamicObjectCollection yhsEntitys = taxMain.getDynamicObjectCollection("yhsentity");
        return yhsEntitys.stream().filter(s -> YhsUtils.isValidate(s, skssqq, skssqz, declaretype, period)).collect(Collectors.toList());
    }

    public static boolean isValidate(DynamicObject yhsEntity, Date skssqq, Date skssqz, String declaretype, String period) {
        return yhsEntity.getDate("effectivedate").compareTo(skssqq) <= 0 && (yhsEntity.getDate("expirydate") == null || yhsEntity.getDate("expirydate").compareTo(skssqz) >= 0) && YhsUtils.filter(yhsEntity, "declaretype", declaretype) && YhsUtils.filter(yhsEntity, "period", period);
    }

    private static boolean filter(DynamicObject yhsEntity, String key, String value) {
        if (EmptyCheckUtils.isNotEmpty((Object)value)) {
            return value.equals(yhsEntity.getString(key));
        }
        return true;
    }

    public static DynamicObject getTaxItem(DynamicObject org, String taxitemNumber) {
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(org.getLong("id")));
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObjectCollection yhsentity = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity");
            Optional<DynamicObject> dynamicObject = yhsentity.stream().filter(d -> d.getString("taxrate.number").equals(taxitemNumber)).findFirst();
            return dynamicObject.orElse(null);
        }
        return null;
    }

    public static List<DynamicObject> queryYhsEntityList(Long orgId) {
        TaxResult taxResult;
        DynamicObjectCollection yhsEntityList = new ArrayList();
        Boolean yhsEnable = (Boolean)TaxcMainDataServiceHelper.isTaxcMainYhsEnableByOrgId((Long)orgId).getData();
        if (yhsEnable.booleanValue() && (taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgId))).isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            yhsEntityList = ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity");
        }
        return yhsEntityList;
    }
}

