/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeductTZDetailFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String ORGID = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SERIALNO = "serialno";
    private static final String RENTID = "rentid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    public static final String CLOSECALLBACK_KEY = "closecallback";
    public static final String TOTAL_RESULT_KEY = "adjustsumamount";
    private static final String WSJTS = "entryentity1";
    private static final String QSMS = "flexpanelap2";
    private static final String TCRET_ZJCJ_ACCDET = "tcret_zjcj_accdet";
    private static boolean ENABLE = true;

    public void initialize() {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.showRightFlex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONObject data = (JSONObject)customParams.get("data");
        String rentid = null != data ? data.getString("id") : (String)customParams.get(RENTID);
        boolean modify = this.isModify(rentid);
        boolean modifyAgain = this.isModifyAgain(rentid);
        DynamicObject[] adjustDetails = this.getAdjustData(customParams, modify, modifyAgain);
        DynamicObject[] genericObjects = this.loadDetailData(customParams);
        if (genericObjects.length == 0) {
            this.appendCard(customParams, rentid, adjustDetails, null);
            return;
        }
        this.getPageCache().put("existaccount", "true");
        Map<String, List<DynamicObject>> map = Arrays.stream(genericObjects).sorted(Comparator.comparing(d -> d.getDynamicObject("org").getLong("id"))).collect(Collectors.groupingBy(s -> s.getDynamicObject("org").getLong("id") + "_" + s.getDynamicObject("ruleid").getLong("id")));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
            DynamicObject rule = entry.getValue().get(0).getDynamicObject("ruleid");
            rule = BusinessDataServiceHelper.loadSingleFromCache((Object)rule.getLong("id"), (String)rule.getDataEntityType().getName());
            this.getModel().setValue("ruleid", (Object)rule.getLong("id"), rowIndex);
            this.getModel().setValue("titlename", (Object)rule.getString("name"), rowIndex);
            this.getModel().setValue("itemname", (Object)rule.getString("name"), rowIndex);
            Object orgid = customParams.get(ORGID);
            this.getModel().setValue("taxorg", orgid, rowIndex);
            this.getModel().setValue(RENTID, (Object)rentid, rowIndex);
            this.getModel().setValue("amount", (Object)this.getAmount(rule, entry.getValue()), rowIndex);
            this.getModel().setValue("adjustamount", (Object)this.getAdjustamount(rule.getLong("id"), adjustDetails), rowIndex);
            this.getModel().setValue("totalamount", (Object)this.getTotalamount(rule, adjustDetails, entry.getValue()), rowIndex);
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
            this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
        }
        this.appendCard(customParams, rentid, adjustDetails, genericObjects);
        Map.Entry first = (Map.Entry)map.entrySet().stream().findFirst().get();
        this.clearEntry(ENTRYENTITY_LIST);
        String ruleid = ((String)first.getKey()).split("_")[1];
        this.setEntryentitylist(Long.valueOf(ruleid));
    }

    private void showRightFlex() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String righttype = (String)customParams.get("righttype");
        this.getView().setVisible(Boolean.FALSE, new String[]{WSJTS, QSMS});
        if (righttype != null) {
            switch (righttype) {
                case "1": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{WSJTS});
                    this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY_LIST, QSMS});
                    break;
                }
                case "2": {
                    this.getView().setVisible(Boolean.TRUE, new String[]{QSMS});
                    this.getView().setVisible(Boolean.FALSE, new String[]{ENTRYENTITY_LIST, WSJTS});
                    this.getModel().setValue("qsy", customParams.get("qsy"));
                    this.getModel().setValue("sjlx", customParams.get("sjlx"));
                    this.getModel().setValue("jslj", customParams.get("jslj"));
                }
            }
        }
        this.getView().updateView("flexpanelap4");
    }

    private DynamicObject[] getAdjustData(Map<String, Object> customParams, Boolean modify, Boolean modifyagain) {
        String selectPrope = "ruleid,adjustamount,totalamount";
        QFilter[] filters = null;
        QFilter rentidFilter = null;
        JSONObject data = (JSONObject)customParams.get("data");
        String rentid = null != data ? data.getString("id") : (String)customParams.get(RENTID);
        rentidFilter = modify.booleanValue() ? (modifyagain.booleanValue() ? new QFilter(RENTID, "=", (Object)(rentid + "_modifyagain")) : new QFilter(RENTID, "=", (Object)(rentid + "_modify"))) : new QFilter(RENTID, "=", (Object)rentid);
        filters = new QFilter[]{rentidFilter};
        return BusinessDataServiceHelper.load((String)"tcret_adjust_detail", (String)selectPrope, (QFilter[])filters);
    }

    private DynamicObject[] loadDetailData(Map<String, Object> customParams) {
        String selectProperties = "org,skssqq,table,amountfield,datadirection,amount,fetchamount,filtercondition,ruleid";
        Object orgid = customParams.get(ORGID);
        JSONObject data = (JSONObject)customParams.get("data");
        String rentid = null != data ? data.getString("id") : (String)customParams.get(RENTID);
        QFilter rentidFilter = new QFilter(RENTID, "=", (Object)rentid);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String itemid = (String)customParams.get("pkid");
        QFilter itemidFilter = new QFilter(SERIALNO, "=", (Object)itemid);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, itemidFilter, rentidFilter};
        return BusinessDataServiceHelper.load((String)TCRET_ZJCJ_ACCDET, (String)selectProperties, (QFilter[])filters);
    }

    private Object calcAdjustsumamount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal totalamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalamount;
    }

    private void appendCard(Map<String, Object> customParams, String rentid, DynamicObject[] adjustDetails, DynamicObject[] genericObjects) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("ruleid") == 0L).findFirst();
        DynamicObject dynamicObject = optional.isPresent() ? optional.get() : null;
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        String ruleid = (String)customParams.get("ruleid");
        try {
            this.getModel().setValue("ruleid", (Object)Long.parseLong(ruleid), rowIndex);
        }
        catch (Exception e) {
            this.getModel().setValue("ruleid", (Object)0L, rowIndex);
        }
        this.getModel().setValue("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"DeductTZDetailFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), rowIndex);
        this.getModel().setValue(RENTID, (Object)rentid, rowIndex);
        this.getModel().setValue("amount", (Object)0, rowIndex);
        this.getModel().setValue("totalamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("totalamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("adjustamount", (Object)(dynamicObject != null ? dynamicObject.getBigDecimal("adjustamount") : BigDecimal.ZERO), rowIndex);
        this.getModel().setValue("sumamount", (Object)this.calcSumAmount(genericObjects));
        this.getModel().setValue(TOTAL_RESULT_KEY, this.calcAdjustsumamount());
        this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"adjustamount"});
        this.getView().setEnable(Boolean.valueOf(ENABLE), rowIndex, new String[]{"totalamount"});
    }

    private BigDecimal getTotalamount(DynamicObject rule, DynamicObject[] adjustDetails, List<DynamicObject> genericObjects) {
        BigDecimal result = BigDecimal.ZERO;
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("ruleid") == rule.getLong("id")).findFirst();
        result = optional.isPresent() ? optional.get().getBigDecimal("totalamount") : this.getAmount(rule, genericObjects);
        return result;
    }

    private BigDecimal getAdjustamount(Long ruleid, DynamicObject[] adjustDetails) {
        Optional<DynamicObject> optional = Arrays.stream(adjustDetails).filter(s -> s.getLong("ruleid") == ruleid.longValue()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calcSumAmount(DynamicObject[] genericObjects) {
        if (genericObjects == null || genericObjects.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = Arrays.stream(genericObjects).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAmount(DynamicObject rule, List<DynamicObject> genericObjects) {
        BigDecimal sum = genericObjects.stream().filter(s -> s.getDynamicObject("ruleid").getLong("id") == rule.getLong("id")).map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name) || "otheradjustamount".equals(name)) {
            BigDecimal amount;
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            }
            if ("totalamount".equals(name)) {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("adjustamount", (Object)totalamount.subtract(amount), rowIndex);
            }
            this.refreshAdjustSumAmount();
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue(TOTAL_RESULT_KEY, (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            boolean modify = false;
            Object orgid = customParams.get(ORGID);
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
            String itemid = (String)customParams.get("pkid");
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                String rentid = ((DynamicObject)entryentitycard.get(0)).getString(RENTID);
                modify = this.isModify(rentid);
                BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue(TOTAL_RESULT_KEY);
                if (BigDecimal.ZERO.compareTo(adjustsumamount) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5408\u8ba1\u91d1\u989d\u4e0d\u53ef\u4e3a\u8d1f\u6570", (String)"DeductTZDetailFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject dynamicObject : entryentitycard) {
                    DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcret_adjust_detail"));
                    object.set("ruleid", (Object)dynamicObject.getLong("ruleid"));
                    object.set("titlename", (Object)dynamicObject.getString("titlename"));
                    object.set("itemname", (Object)dynamicObject.getString("itemname"));
                    if (modify) {
                        this.deleteModifyagainDetail(orgid, skssqq, skssqz, rentid);
                        object.set(RENTID, (Object)(rentid + "_modifyagain"));
                    } else {
                        object.set(RENTID, (Object)(rentid + "_modify"));
                    }
                    object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                    object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                    object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                    object.set("org", orgid);
                    object.set(SKSSQQ, (Object)skssqq);
                    object.set(SKSSQZ, (Object)skssqz);
                    object.set("itemid", (Object)itemid);
                    datas.add(object);
                }
            }
            SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            Map parentCustomParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
            parentCustomParams.put(TOTAL_RESULT_KEY, this.getModel().getValue(TOTAL_RESULT_KEY));
            String existaccount = this.getPageCache().get("existaccount");
            if (null != existaccount) {
                parentCustomParams.put("existaccount", existaccount);
            }
            if (null != entryentitycard) {
                if (modify) {
                    parentCustomParams.put("modifyagain", "modifyagain");
                }
                parentCustomParams.put("modify", "modify");
            }
            this.getView().getParentView().updateView();
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        CardEntry cardEntry = (CardEntry)evt.getSource();
        List rows = evt.getNewRows();
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        if (entryentitycard.size() - 1 == (Integer)rows.get(0)) {
            return;
        }
        if (rows.isEmpty()) {
            return;
        }
        this.clearEntry(ENTRYENTITY_LIST);
        Long ruleid = (Long)cardEntry.getModel().getValue("ruleid");
        if (ruleid != null) {
            this.setEntryentitylist(ruleid);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private void setEntryentitylist(Long ruleid) {
        QFilter ruleFilter = new QFilter("ruleid", "=", (Object)ruleid);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object orgid = customParams.get(ORGID);
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong((String)orgid));
        Date skssqq = DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ)));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ)));
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        String selectProperties = "skssqq,skssqz,absolute,bizname,table,amountfield,datadirection,fetchamount,amount,filtercondition,ruleid";
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, ruleFilter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TCRET_ZJCJ_ACCDET, (String)selectProperties, (QFilter[])filters);
        for (DynamicObject object : collection) {
            int endyear;
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            int startyear = DateUtils.getYearOfDate((Date)object.getDate(SKSSQQ));
            String yearmsg = startyear == (endyear = DateUtils.getYearOfDate((Date)object.getDate(SKSSQZ))) ? String.valueOf(startyear) : startyear + "-" + endyear;
            this.getModel().setValue("date", (Object)String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"DeductTZDetailFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]), yearmsg), rowIndex);
            this.getModel().setValue("bizname", (Object)object.getString("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("amount"), rowIndex);
            this.getModel().setValue("filtercondition", object.get("filtercondition"), rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        CardEntry entryentitycard = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        entryentitycard.selectCard(Integer.valueOf(0));
        entryentitycard.selectRowsChanged(Collections.singletonList(0), null);
    }

    private boolean isModify(String rentid) {
        QFilter rentidFilter = new QFilter(RENTID, "=", (Object)(rentid + "_modify"));
        return QueryServiceHelper.exists((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
    }

    private boolean isModifyAgain(String rentid) {
        QFilter rentidFilter = new QFilter(RENTID, "=", (Object)(rentid + "_modifyagain"));
        return QueryServiceHelper.exists((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{rentidFilter});
    }

    private void deleteModifyagainDetail(Object orgid, Object skssqq, Object skssqz, String rentid) {
        QFilter rentidFilter = new QFilter(RENTID, "=", (Object)(rentid + "_modifyagain"));
        DeleteServiceHelper.delete((String)"tcret_adjust_detail", (QFilter[])new QFilter[]{new QFilter(SKSSQQ, "=", skssqq).and(new QFilter(SKSSQZ, "=", skssqz)).and(new QFilter("org", "=", (Object)Long.valueOf(orgid.toString()))).and(rentidFilter)});
    }
}

