/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import com.google.common.primitives.Longs;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.taxsource.HouseRentServiceHelper;
import kd.taxc.tcret.common.utils.EngineUtils;
import org.apache.commons.lang.StringUtils;

public class HouseRentAutoCollect
extends AbstractLicenseCheckFormPlugin {
    private static final String ORGID = "orgid";
    private static final String ORG = "org";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flexpanelap2", STARTDATE, ENDDATE, SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String org = (String)customParams.get(ORGID);
        if (StringUtils.isNotEmpty((String)org)) {
            this.getModel().setValue(ORG, (Object)Long.valueOf(org));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        if (ORG.equals(args.getProperty().getName())) {
            this.getGatherList();
        } else if (STARTDATE.equals(args.getProperty().getName()) || ENDDATE.equals(args.getProperty().getName())) {
            Date startdate = (Date)this.getModel().getValue(STARTDATE);
            Date enddate = (Date)this.getModel().getValue(ENDDATE);
            if (null == startdate || null == enddate) {
                this.getModel().deleteEntryData(ENTRYENTITY);
            }
            if (STARTDATE.equals(args.getProperty().getName()) && startdate != null && !startdate.equals(DateUtils.getFirstDateOfMonth((Date)startdate))) {
                this.getModel().setValue(STARTDATE, (Object)DateUtils.getFirstDateOfMonth((Date)startdate));
                return;
            }
            if (ENDDATE.equals(args.getProperty().getName()) && enddate != null && !enddate.equals(DateUtils.getLastDateOfMonth2((Date)enddate))) {
                this.getModel().setValue(ENDDATE, (Object)DateUtils.getLastDateOfMonth2((Date)enddate));
                return;
            }
            if (startdate != null && enddate != null && enddate.before(startdate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u79df\u8d41\u671f\u8d77\u5fc5\u987b\u5c0f\u4e8e\u6240\u5c5e\u79df\u8d41\u671f\u6b62", (String)"HouseRentAutoCollect_2", (String)"taxc-tcret", (Object[])new Object[0]));
                this.getModel().deleteEntryData(ENTRYENTITY);
                return;
            }
            this.getGatherList();
        }
    }

    private void getGatherList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Object startdate = this.getModel().getValue(STARTDATE);
        Object enddate = this.getModel().getValue(ENDDATE);
        if (org == null || startdate == null || enddate == null) {
            return;
        }
        long orgId = org.getLong("id");
        QFilter orgIdFilter = new QFilter(ORG, "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection result = QueryServiceHelper.query((String)"tdm_house_rental_info", (String)"id,org.name,fcsbasicinfo.number,buildingname,taxauthority.name,leasecontractno,fcsbyhirelimit,taxtimepoint", (QFilter[])new QFilter[]{orgIdFilter, enableFilter});
        this.updateFormEntity(result);
    }

    private void updateFormEntity(DynamicObjectCollection result) {
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        long orgId = org.getLong("id");
        this.getModel().deleteEntryData(ENTRYENTITY);
        Date startdate = (Date)this.getModel().getValue(STARTDATE);
        Date enddate = (Date)this.getModel().getValue(ENDDATE);
        Map<Long, List<DynamicObject>> rulesMap = HouseRentServiceHelper.fetchRules(result.stream().map(r -> r.get("id")).collect(Collectors.toList()), orgId);
        for (DynamicObject object : result) {
            int index = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("id", (Object)object.getString("id"), index);
            this.getModel().setValue("orgname", (Object)object.getString("org.name"), index);
            this.getModel().setValue("fcsbasicinfo", object.get("fcsbasicinfo.number"), index);
            this.getModel().setValue("buildingname", object.get("buildingname"), index);
            this.getModel().setValue("taxauthority", object.get("taxauthority.name"), index);
            this.getModel().setValue("leasecontractno", object.get("leasecontractno"), index);
            this.getModel().setValue("fcsbyhirelimit", object.get("fcsbyhirelimit"), index);
            this.getModel().setValue("taxtimepoint", object.get("taxtimepoint"), index);
            int gatherStatus = HouseRentServiceHelper.getGatherStatus(rulesMap, object.getLong("id"), startdate, enddate);
            this.getModel().setValue("failurereason", (Object)gatherStatus, index);
            this.getModel().setValue("iscreateaccount", (Object)(gatherStatus != 0 ? "fail" : "success"), index);
        }
        this.getView().updateView(ENTRYENTITY);
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject orgdyo = (DynamicObject)this.getModel().getValue(ORG);
        if (orgdyo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"HouseRentAutoCollect_3", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        Date startdate = (Date)this.getModel().getValue(STARTDATE);
        Date enddate = (Date)this.getModel().getValue(ENDDATE);
        if (null == startdate || null == enddate) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7533\u62a5\u79df\u91d1\u5c5e\u671f", (String)"HouseRentAutoCollect_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        if (enddate.before(startdate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u79df\u8d41\u671f\u8d77\u5fc5\u987b\u5c0f\u4e8e\u6240\u5c5e\u79df\u8d41\u671f\u6b62", (String)"HouseRentAutoCollect_2", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        if (SAVE.equals(itemKey)) {
            if (!TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)orgdyo.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"HouseRentAutoCollect_5", (String)"taxc-tcret", (Object[])new Object[0]));
                return;
            }
            EngineModel engineModel = new EngineModel(orgdyo.getString("id"), DateUtils.format((Date)startdate), DateUtils.format((Date)enddate));
            engineModel.getCustom().put("FromClass", "HouseRentAutoCollect");
            List orgid = Longs.asList((long[])new long[]{orgdyo.getLong("id")});
            Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs((List)orgid, (Date)DateUtils.trunc((Date)startdate), (Date)DateUtils.trunc((Date)enddate));
            engineModel.addCustom("OrgRelationMap", (Object)orgRelationMap);
            EngineUtils.execute(Collections.singletonList(engineModel));
            this.getView().close();
        }
    }
}

