/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcret.business.taxsource.YhsAccountServiceHelper;

public class YhsTaxAccountDetailFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String TCRET_YHS_TAX_ACCOUNT = "tcret_yhs_tax_account";
    private static final String TCRET_YHS_PREPAY_DETA = "tcret_yhs_prepay_deta";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String serialno = (String)customParams.get("serialno");
        String orgId = (String)customParams.get("org");
        String startdate = (String)customParams.get("skssqq");
        String enddate = (String)customParams.get("skssqz");
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView().getParentView(), (String)"4715a0df000000ac")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnok"});
        }
        DynamicObject accountDetail = YhsAccountServiceHelper.queryYhsAccountDetails(serialno, orgId, startdate, enddate);
        if (EmptyCheckUtils.isEmpty((Object)accountDetail)) {
            return;
        }
        this.getModel().beginInit();
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        this.getModel().setValue("serialno", (Object)accountDetail.getString("taxaccountserialno"), rowIndex);
        this.getModel().setValue("prepayitem", (Object)accountDetail.getString("prepayitem"), rowIndex);
        this.getModel().setValue("taxorg", (Object)accountDetail.getLong("taxorg"), rowIndex);
        this.getModel().setValue("amount", (Object)accountDetail.getBigDecimal("amount"), rowIndex);
        this.getModel().setValue("adjustamount", (Object)accountDetail.getBigDecimal("adjustamount"), rowIndex);
        this.getModel().setValue("totalamount", (Object)accountDetail.getBigDecimal("amount").add(accountDetail.getBigDecimal("adjustamount")), rowIndex);
        this.getModel().setValue("tzsm", (Object)accountDetail.getString("tzsm"), rowIndex);
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY_CARD);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name)) {
            BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
            this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String orgid = (String)customParams.get("org");
            String serialno = (String)customParams.get("serialno");
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            Date skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
            ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
            if (!CollectionUtils.isEmpty((Collection)entryentitycard)) {
                DynamicObject dynamicObject = (DynamicObject)entryentitycard.get(0);
                DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCRET_YHS_PREPAY_DETA));
                object.set("taxaccountserialno", (Object)dynamicObject.getString("serialno"));
                object.set("prepayitem", (Object)dynamicObject.getString("prepayitem"));
                object.set("amount", (Object)dynamicObject.getBigDecimal("amount"));
                object.set("adjustamount", (Object)dynamicObject.getBigDecimal("adjustamount"));
                object.set("totalamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                object.set("tzsm", (Object)dynamicObject.getString("tzsm"));
                object.set("taxorg", (Object)orgid);
                object.set("org", (Object)orgid);
                object.set("skssqq", (Object)skssqq);
                object.set("skssqz", (Object)skssqz);
                datas.add(object);
                DynamicObject summaryObject = BusinessDataServiceHelper.loadSingle(customParams.get("pkid"), (String)TCRET_YHS_TAX_ACCOUNT);
                summaryObject.set("calctaxamount", (Object)dynamicObject.getBigDecimal("totalamount"));
                try (TXHandle h = TX.required();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{summaryObject});
                        this.deleteDetail(serialno, orgid, skssqq, skssqz);
                        SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable t) {
                        h.markRollback();
                        throw new RuntimeException(t);
                    }
                }
            }
            this.getView().close();
        }
    }

    private void deleteDetail(String serialno, String orgId, Object skssqq, Object skssqz) {
        DeleteServiceHelper.delete((String)TCRET_YHS_PREPAY_DETA, (QFilter[])new QFilter[]{new QFilter("skssqq", "=", skssqq).and(new QFilter("skssqz", "=", skssqz)).and(new QFilter("org", "=", (Object)Long.valueOf(orgId))).and(new QFilter("taxaccountserialno", "=", (Object)serialno))});
    }
}

