/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.account;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcret.common.utils.YhsUtils;

public class YhsTaxImportPlugin
extends BatchImportPlugin {
    public static final Long YHS = 8L;
    private static final String tabLine = "\n";

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private void validBillData(ImportBillData data, StringBuilder message) {
        Optional<DynamicObject> exists;
        DynamicObjectCollection deductioncodeentity;
        JSONObject deductioncode;
        JSONObject subtaxitem;
        Optional<DynamicObject> exists2;
        Optional<DynamicObject> exists3;
        String declaretype;
        String vouchernum;
        boolean isexist;
        JSONObject taxoffice;
        JSONObject org = data.getData().getJSONObject("org");
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString("number"));
        if (!taxResult.isSuccess()) {
            YhsTaxImportPlugin.errorMsg(message, taxResult.getMessage());
            return;
        }
        DynamicObject orgObject = (DynamicObject)taxResult.getData();
        long orgId = orgObject.getDynamicObject("taxorg").getLong("id");
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter((String)"tcret", (String)"zerodeclare", (long)orgId);
        if (zeroDeclare) {
            String orgname = OrgUtils.getOrgNameById((String)orgObject.getDynamicObject("orgid").getString("id"));
            YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u4e0d\u80fd\u751f\u6210\u53f0\u8d26", (String)"YhsTaxImportPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]), orgname));
        }
        if ((taxoffice = data.getData().getJSONObject("taxoffice")) != null && !(isexist = QueryServiceHelper.exists((String)"bastax_taxorgan", (QFilter[])new QFilter[]{new QFilter("number", "=", taxoffice.get((Object)"number")).and(new QFilter("enable", "=", (Object)"1"))}))) {
            YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7a0e\u52a1\u673a\u5173\u4e0d\u5b58\u5728", (String)"YhsTaxImportPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (!StringUtils.isNumeric((CharSequence)(vouchernum = data.getData().getString("vouchernum")))) {
            YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u5e94\u7a0e\u51ed\u8bc1\u6570\u91cf\uff1a\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a\u81ea\u7136\u6570", (String)"YhsTaxImportPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if (StringUtil.isBlank((CharSequence)(declaretype = data.getData().getString("declaretype")))) {
            YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u7533\u62a5\u671f\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxImportPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        JSONObject taxitem = data.getData().getJSONObject("taxitem");
        DynamicObjectCollection yhsEntity = YhsTaxImportPlugin.getYhsEntity(orgId);
        if (yhsEntity != null && "aqsb".equals(declaretype) && !(exists3 = yhsEntity.stream().filter(s -> s.getDynamicObject("taxrate").get("number").equals(taxitem.get((Object)"number"))).findFirst()).isPresent()) {
            YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\u5728\u5370\u82b1\u7a0e\u7a0e\u79cd\u5361\u7247\u4e2d\u4e0d\u5b58\u5728", (String)"YhsTaxImportPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), taxitem.get((Object)"number")));
        }
        String skssqq = data.getData().getString("skssqq");
        String skssqz = data.getData().getString("skssqz");
        Date startDate = this.checkDate(skssqq, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77", (String)"YhsTaxImportPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]), message);
        Date endDate = this.checkDate(skssqz, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62", (String)"YhsTaxImportPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]), message);
        if ("aqsb".equals(declaretype) && startDate != null && endDate != null && yhsEntity != null && (exists2 = yhsEntity.stream().filter(s -> s.getDynamicObject("taxrate").get("number").equals(taxitem.get((Object)"number"))).findFirst()).isPresent()) {
            DynamicObject object = exists2.get();
            boolean include = this.includeTime(startDate, endDate, (Date)object.get("effectivedate"), (Date)object.get("expirydate"));
            boolean temp = DateUtils.validDateRange((String)object.get("period").toString(), (Date)startDate, (Date)endDate);
            if (!include || !temp) {
                YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u6b3e\u6240\u5c5e\u671f\u5370\u82b1\u7a0e\u7a0e\u76ee\u4fe1\u606f%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u7ef4\u62a4\u7a0e\u79cd\u4fe1\u606f\u3002", (String)"YhsTaxImportPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]), ((DynamicObject)object.get("taxrate")).getString("name")));
            }
        }
        if ((subtaxitem = data.getData().getJSONObject("subtaxitem")) != null) {
            DynamicObject[] yhssubitementity = BusinessDataServiceHelper.load((String)"tpo_tcsd_bizdef_entry", (String)"id,parent", (QFilter[])new QFilter[0]);
            if (yhssubitementity != null) {
                Optional<DynamicObject> exists4 = Arrays.stream(yhssubitementity).filter(s -> s.get("number").equals(subtaxitem.get((Object)"number"))).findFirst();
                if (!exists4.isPresent()) {
                    YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\u5728\u5370\u82b1\u7a0e\u5b50\u76ee\u8868\u4e2d\u4e0d\u5b58\u5728", (String)"YhsTaxImportPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]), subtaxitem.get((Object)"number")));
                } else if (!exists4.get().getDynamicObject("parent").get("number").equals(taxitem.get((Object)"number"))) {
                    YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u5b50\u76ee\u4e0e\u7a0e\u76ee\u4e0d\u5339\u914d\uff0c\u5b50\u76ee%1$s\u4e0d\u5c5e\u4e8e\u7a0e\u76ee%2$s", (String)"YhsTaxImportPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]), subtaxitem.get((Object)"number"), taxitem.get((Object)"number")));
                }
            }
        } else if (YhsUtils.YHS_NEW_VERSION_DATE.compareTo(startDate) < 0 && taxitem.get((Object)"number").equals("02001")) {
            YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u4ea7\u6743\u8f6c\u79fb\u4e66\u636e\u7684\u5b50\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (String)"YhsTaxImportPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        String voucherdate = data.getData().getString("voucherdate");
        if (voucherdate != null) {
            this.checkDate(voucherdate, ResManager.loadKDString((String)"\u5e94\u7a0e\u51ed\u8bc1\u4e66\u7acb\u65e5\u671f", (String)"YhsTaxImportPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]), message);
        }
        String calctaxamount = data.getData().getString("calctaxamount");
        this.checkNumeric(calctaxamount, ResManager.loadKDString((String)"\u8ba1\u7a0e\u91d1\u989d", (String)"YhsTaxImportPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]), message);
        if ("acsb".equals(declaretype)) {
            if (BigDecimal.ZERO.compareTo(new BigDecimal(calctaxamount)) >= 0) {
                YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u65f6\uff0c\u8ba1\u7a0e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxImportPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!skssqq.equals(voucherdate)) {
                YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u7a0e\u6e90\u6570\u636e\u7684\u5e94\u7a0e\u51ed\u8bc1\u4e66\u7acb\u65e5\u671f\u9700\u8981\u4e0e\u6240\u5c5e\u7a0e\u671f\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxImportPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if (!skssqq.equals(skssqz)) {
                YhsTaxImportPlugin.errorMsg(message, ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u9700\u8981\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539", (String)"YhsTaxImportPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
        if ((deductioncode = data.getData().getJSONObject("deductioncode")) != null && (deductioncodeentity = QueryServiceHelper.query((String)"tpo_taxdeduction", (String)"id,number,taxcategory", (QFilter[])new QFilter[]{new QFilter("taxcategory", "=", (Object)YHS)})) != null && !(exists = deductioncodeentity.stream().filter(s -> s.get("number").equals(deductioncode.get((Object)"number"))).findFirst()).isPresent()) {
            YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"\u51cf\u514d\u653f\u7b56\u4ee3\u7801%s\u4e0d\u5b58\u5728", (String)"YhsTaxImportPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]), deductioncode.get((Object)"number")));
        }
        if (StringUtils.isBlank((CharSequence)message.toString())) {
            this.setDefaultData(data, taxitem, subtaxitem, org, taxoffice, startDate, endDate, orgObject.getDynamicObject("orgid"));
        }
    }

    private static DynamicObjectCollection getYhsEntity(Long orgid) {
        if (orgid == null) {
            return null;
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(orgid));
        if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
            return ((DynamicObject)((List)taxResult.getData()).get(0)).getDynamicObjectCollection("yhsentity");
        }
        return null;
    }

    private Date checkDate(String dateStr, String fieldName, StringBuilder message) {
        Date date;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        String format = "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            date = df.parse(dateStr);
        }
        catch (ParseException e) {
            YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"YhsTaxImportPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]), fieldName));
            return null;
        }
        YhsTaxImportPlugin.checkLeapYear(dateStr, format, fieldName, message);
        return date;
    }

    private static void checkLeapYear(String dateStr, String format, String fieldName, StringBuilder message) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
            LocalDate localDate = LocalDate.parse(dateStr, dateTimeFormatter);
            if (!localDate.isLeapYear() && dateStr.endsWith("-02-29")) {
                YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"YhsTaxImportPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]), fieldName));
            }
        }
        catch (Exception e) {
            YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s:\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a: YYYY-MM-DD", (String)"YhsTaxImportPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]), fieldName));
        }
    }

    private boolean checkNumeric(String value, String fieldName, StringBuilder message) {
        if (value == null) {
            return true;
        }
        if (!(value = value.replaceAll(",", "")).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            YhsTaxImportPlugin.errorMsg(message, String.format(ResManager.loadKDString((String)"%s\uff1a\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"YhsTaxImportPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]), fieldName));
            return false;
        }
        return true;
    }

    private boolean includeTime(Date effectivestart, Date effectiveend, Date validfrom, Date expired) {
        LocalDate startDate1 = this.formatDate(DateUtils.format((Date)effectivestart));
        LocalDate endDate1 = this.formatDate(DateUtils.format((Date)effectiveend));
        LocalDate startDate2 = this.formatDate(DateUtils.format((Date)validfrom));
        LocalDate endDate2 = this.formatDate(DateUtils.format((Date)expired));
        if (Objects.isNull(startDate1) || Objects.isNull(startDate2)) {
            return true;
        }
        if (Objects.isNull(endDate2)) {
            return startDate1.isAfter(startDate2) || startDate1.isEqual(startDate2);
        }
        if (Objects.isNull(endDate1) && Objects.nonNull(endDate2)) {
            return false;
        }
        return !(!startDate1.isAfter(startDate2) && !startDate1.isEqual(startDate2) || !endDate2.isAfter(endDate1) && !endDate1.isEqual(endDate2));
    }

    private LocalDate formatDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDate.parse(date);
    }

    private void setDefaultData(ImportBillData data, JSONObject taxitem, JSONObject subtaxitem, JSONObject org, JSONObject taxoffice, Date startDate, Date endDate, DynamicObject orgId) {
        String declaretype;
        DynamicObject taxResult;
        data.getData().put("datasource", (Object)"import");
        DynamicObject taxitemObject = QueryServiceHelper.queryOne((String)"tpo_tcsd_taxrateentry", (String)"id,taxrate", (QFilter[])new QFilter[]{new QFilter("number", "=", taxitem.get((Object)"number"))});
        if (taxitem.get((Object)"number").equals("02001")) {
            DynamicObject subtaxitemObject = QueryServiceHelper.queryOne((String)"tpo_tcsd_bizdef_entry", (String)"id,value", (QFilter[])new QFilter[]{new QFilter("number", "=", subtaxitem.get((Object)"number"))});
            data.getData().put("taxrate", (Object)subtaxitemObject.getString("value"));
        } else {
            data.getData().put("taxrate", (Object)taxitemObject.getString("taxrate"));
        }
        if (startDate != null && endDate != null) {
            data.getData().put("taxlimit", (Object)DateUtils.getTaxLimit((Date)startDate, (Date)endDate));
        }
        if ((taxResult = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgNum((String)org.getString("number")).getData()) != null) {
            if (taxResult.getString("taxoffice.number").equals(taxoffice.getString("number"))) {
                data.getData().put("paytype", (Object)"bdjn");
            } else {
                data.getData().put("paytype", (Object)"ydjn");
            }
        }
        if (StringUtil.equals((CharSequence)"acsb", (CharSequence)(declaretype = data.getData().getString("declaretype")))) {
            data.getData().put("taxation", (Object)"aqhz");
            data.getData().put("verifyrate", (Object)BigDecimal.ZERO);
        } else {
            DynamicObject object = YhsUtils.getTaxItem(orgId, taxitem.getString("number"));
            if (object != null) {
                data.getData().put("taxation", (Object)(object.getBoolean("isverify") ? "hdzs" : "aqhz"));
                data.getData().put("verifyrate", (Object)object.getBigDecimal("hdrate"));
            }
        }
    }

    private static void errorMsg(StringBuilder errors, String msg) {
        errors.append(msg).append(tabLine);
    }
}

