/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcret.formplugin.accrual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcret.business.accrual.AccrualCalcService;
import kd.taxc.tcret.business.accrual.AccrualCalcServiceFactory;
import kd.taxc.tcret.business.accrual.AccrualServiceHelper;
import kd.taxc.tcret.common.constant.TcretAccrualConstant;
import kd.taxc.tcret.common.utils.TcretSystemParamUtil;

public class AccrualDraftFormPlugin
extends AbstractLicenseCheckFormPlugin
implements TcretAccrualConstant,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(AccrualDraftFormPlugin.class);
    private List<String> paramKeys = Arrays.asList("org", "accrualdate", "skssqq", "skssqz");
    private List<String> attachKey = Arrays.asList("yhs", "ccs", "hjbhs", "szys");

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.doSetTitle(e);
    }

    private void doSetTitle(PreOpenFormEventArgs e) {
        String draftType = (String)e.getFormShowParameter().getCustomParam("drafttype");
        if (null == draftType) {
            FormShowParameter showParameter = (FormShowParameter)e.getSource();
            Object pkid = ((BillShowParameter)showParameter).getPkId();
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcret_fcs_accrual_draft", (String)"drafttype", (QFilter[])new QFilter[]{new QFilter("id", "=", pkid)});
            draftType = dynamicObject.getString("drafttype");
        }
        switch (draftType) {
            case "fcs": {
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"AccrualDraftFormPlugin_0", (String)"taxc-tcret", (Object[])new Object[0]));
                break;
            }
            case "cztdsys": {
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u571f\u5730\u4f7f\u7528\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"AccrualDraftFormPlugin_1", (String)"taxc-tcret", (Object[])new Object[0]));
                break;
            }
            case "yhs": {
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5370\u82b1\u7a0e\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"AccrualDraftFormPlugin_2", (String)"taxc-tcret", (Object[])new Object[0]));
            }
        }
    }

    private void doCalcAccrualDetails() {
        DynamicObject accrualDraftObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection detailList = accrualDraftObj.getDynamicObjectCollection("entryentity");
        detailList.clear();
        long start = System.currentTimeMillis();
        AccrualCalcService service = AccrualCalcServiceFactory.getService(this.getAccrualDraftType());
        service.doCalcAccrualDetails(accrualDraftObj);
        long end = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u8ba1\u63d0\u5e95\u7a3f\u660e\u7ec6\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (end - start));
        this.getView().updateView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"accrualplan"});
        BasedataEdit accountorgBase = (BasedataEdit)this.getView().getControl("accountorg");
        accountorgBase.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit base = (BasedataEdit)this.getView().getControl("org");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "org": {
                this.doTaxOrgChanged(e);
                break;
            }
            case "accrualdate": {
                DynamicObject plan = (DynamicObject)this.getModel().getValue("accrualplan");
                if (plan != null) {
                    this.doSetTaxPeriod(plan.getString("cycle"), false);
                    break;
                }
                this.doSetAccrualItem();
                break;
            }
            case "skssqq": {
                this.doAccrualDateChanged();
                break;
            }
            case "skssqz": {
                this.doAccrualDateChanged();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseMutex();
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        for (String paramKey : this.paramKeys) {
            if (params.get(paramKey) == null) continue;
            this.getModel().setValue(paramKey, params.get(paramKey));
        }
        this.doSetBaseField();
        this.loadData();
    }

    public void afterBindData(EventObject e) {
        this.showWhileEdit(this.getModel().getDataEntity());
        this.setBtnStatus(AccrualServiceHelper.queryAccrualById(this.getModel().getDataEntity().getLong("id")), this.getAccrualDraftType());
        if (this.getView().getFormShowParameter().getCustomParams().get("isFormViewFlow") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tbmain"});
        }
        this.setDimensionField();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!"tcret_fcs_accrual_draft".equals(formId)) {
            boolean bl = this.addMutex();
        }
    }

    private boolean addMutex() {
        return AccrualDraftFormPlugin.addMutexLock(this.getView(), String.valueOf(this.getModel().getValue("id")), "tcret_fcs_accrual_draft", "modify");
    }

    public static boolean addMutexLock(IFormView view, String billId, String entity, String operateKey) {
        if ("0".equals(billId)) {
            return false;
        }
        try {
            DynamicObject dynamicObject;
            MutexServiceImpl mutexService = new MutexServiceImpl();
            HashMap<String, String> customparam = new HashMap<String, String>();
            customparam.put("dataObjId", billId);
            customparam.put("entityKey", entity);
            customparam.put("operationKey", operateKey);
            customparam.put("groupId", "declare_edit");
            mutexService.setMutexLockInfo(customparam);
            boolean isSuccessLock = mutexService.setMutexLock();
            logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entity, entity, isSuccessLock});
            if (!isSuccessLock && (dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)billId))) != null && !Objects.equals(String.valueOf(RequestContext.get().getCurrUserId()), dynamicObject.getString("user.id"))) {
                String user = dynamicObject.getString("user.name");
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AccrualDraftFormPlugin_3", (String)"taxc-tcret", (Object[])new Object[0]), user));
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return false;
    }

    private void setDimensionField() {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("org");
        if (taxorg != null) {
            TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)((DynamicObject)this.getModel().getValue("taxtype")).getLong("id"), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz"));
            if (EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                DynamicObject entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
                boolean isdimprovision = entry.getBoolean("ruleentity.rule.isdimprovision");
                String provisiondimension = entry.getString("ruleentity.rule.provisiondimension");
                if (isdimprovision && provisiondimension.contains("accountorg")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accorg"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"accorg"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"accountorg"});
                }
                if (isdimprovision && provisiondimension.contains("businessdimension")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bizdimensiontype", "bizdimensionname"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountorg", "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    private void doSetBaseField() {
        if (this.getModel().getValue("org") == null) {
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            this.doSetTaxOrg(hasPermOrgs);
        }
        this.doSetAccountOrg();
        this.doSetDefaultValue();
        Long taxtypeId = AccrualListEnum.getBaseTaxIdByCategory((String)this.getAccrualDraftType());
        QFilter q1 = new QFilter("id", "=", (Object)taxtypeId);
        QFilter q2 = new QFilter("enable", "=", (Object)"1");
        DynamicObject taxcategory = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"enable", (QFilter[])new QFilter[]{q1, q2});
        if (taxcategory != null) {
            this.getModel().setValue("taxtype", (Object)taxtypeId);
        }
        this.doSetAccrualItem();
        this.doSetIsxxwlqy();
    }

    private void doSetIsxxwlqy() {
        if ("yhs".equals(this.getAccrualDraftType())) {
            DynamicObject taxorg = (DynamicObject)this.getModel().getValue("org");
            Date skssqq = (Date)this.getModel().getValue("skssqq");
            Date skssqz = (Date)this.getModel().getValue("skssqz");
            if (taxorg != null && skssqq != null && skssqz != null) {
                String isxxwlqy = TaxBaseDataUtils.isXxwlqy((String)taxorg.getString("id"), (Date)skssqq, (Date)skssqz);
                this.getModel().setValue("isxxwlqy", (Object)isxxwlqy);
            }
        }
    }

    private void doSetDefaultValue() {
        this.getModel().setValue("taxsystem", (Object)AccrualConstant.TAXSYSTEM_CHINA);
        this.getModel().setValue("taxareagroup", (Object)AccrualConstant.TAXAREAGROUP_CHINA);
        this.getModel().setValue("accountsettype", (Object)"");
        this.getModel().setValue("billstatus", (Object)"A");
        this.getModel().setValue("pzhc", (Object)"0");
        this.getModel().setValue("drafttype", (Object)this.getAccrualDraftType());
    }

    private void doSetAccountOrg() {
        Long taxOrg = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(null);
        if (taxOrg == null) {
            return;
        }
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        List<Long> orgs = this.setDefaultAccountOrg(taxOrg, startDate, endDate);
        Long defaultAccountOrg = orgs.get(0);
        this.getModel().setValue("accountorg", (Object)defaultAccountOrg);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("org".equals(beforeF7SelectEvent.getProperty().getName())) {
            HasPermOrgResult permOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            if (EmptyCheckUtils.isNotEmpty((Object)permOrgResult) && !permOrgResult.hasAllOrgPerm()) {
                List orgList = permOrgResult.getHasPermOrgs();
                List customQFilters = beforeF7SelectEvent.getCustomQFilters();
                customQFilters.add(new QFilter("id", "in", (Object)orgList));
            }
            OrgUtils.addFilterByConditionBeforeF7Select((Object)beforeF7SelectEvent, (IFormView)this.getView(), null, null, null);
        } else if ("accountorg".equals(beforeF7SelectEvent.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            Long taxOrg = org.getLong("id");
            Date startDate = (Date)this.getModel().getValue("skssqq");
            Date endDate = (Date)this.getModel().getValue("skssqz");
            List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            customQFilters.add(new QFilter("id", "in", (Object)orgRelations));
        }
    }

    private void doSetTaxOrg(HasPermOrgResult hasPermOrgs) {
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
        if (orgid != null) {
            int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgid, (String)"tcret", (String)((String)this.getView().getFormShowParameter().getCustomParams().get("formId")), (String)"47156aff000000ac");
            if (permission == 1) {
                this.getModel().setValue("org", (Object)orgid);
            } else {
                hasPermOrgs.getHasPermOrgs().remove(orgid);
                this.doSetTaxOrg(hasPermOrgs);
            }
        }
    }

    private List<Long> setDefaultAccountOrg(Long taxOrg, Date startDate, Date endDate) {
        List orgRelations = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxOrg), (Date)startDate, (Date)endDate);
        return !CollectionUtils.isEmpty((Collection)orgRelations) ? orgRelations.stream().distinct().collect(Collectors.toList()) : Lists.newArrayList((Object[])new Long[]{0L});
    }

    private void doSetAccrualItem() {
        DynamicObjectCollection dynamicObjectCollection;
        Long taxOrg = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
        Long taxtype = AccrualListEnum.getBaseTaxIdByCategory((String)this.getAccrualDraftType());
        if (this.getModel().getValue("org") == null) {
            return;
        }
        Boolean parameter = TcretSystemParamUtil.getInTaxPeriodJT(taxOrg);
        Date date = this.getModel().getDataEntity().getDate("accrualdate");
        if (!parameter.booleanValue()) {
            date = DateUtils.addMonth((Date)date, (int)-1);
        }
        if ((dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{taxOrg}), (Long)taxtype, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)date, (Date)date).getData()).size() == 0 || ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.enable").equals("0")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AccrualDraftFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("accrualplan", ((DynamicObject)dynamicObjectCollection.get(0)).get("ruleentity.rule"));
        String accrualCycle = ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.cycle");
        this.doSetTaxPeriod(accrualCycle, true);
    }

    private void doSetTaxPeriod(String cycle, Boolean needCheckSkssqq) {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        Date accrualDate = (Date)this.getModel().getValue("accrualdate");
        if (taxOrg == null || accrualDate == null) {
            return;
        }
        Long orgId = taxOrg.getLong("id");
        Boolean parameter = TcretSystemParamUtil.getInTaxPeriodJT(orgId);
        Date startDate = null;
        Date endDate = null;
        switch (cycle) {
            case "month": {
                if (parameter.booleanValue()) {
                    startDate = DateUtils.getMinDateBeforeSomeMonth((Date)accrualDate, (int)0);
                    endDate = DateUtils.getMaxDateBeforeSomeMonth((Date)accrualDate, (int)0);
                    break;
                }
                startDate = DateUtils.getMinDateBeforeSomeMonth((Date)accrualDate, (int)-1);
                endDate = DateUtils.getMaxDateBeforeSomeMonth((Date)accrualDate, (int)-1);
                break;
            }
            case "season": {
                if (!DateUtils.isFirstMonthWithinSeason((Date)accrualDate) && !parameter.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8ba1\u63d0\u65b9\u6848\u662f\u6309\u5b63\u4e14\u9ed8\u8ba4\u4e3a\u5c5e\u671f\u7ec8\u4e86\u540e\u8ba1\u63d0\uff0c\u8bf7\u9009\u62e91\u30014\u30017\u300110\u6708\u4efd\uff0c\u6216\u624b\u52a8\u9009\u62e9\u6240\u5c5e\u7a0e\u671f\u8d77\u6b62\u65e5\u671f", (String)"AccrualDraftFormPlugin_5", (String)"taxc-tcret", (Object[])new Object[0]));
                    break;
                }
                if (!AccrualDraftFormPlugin.isInPeriodParamWithinSeason(accrualDate) && parameter.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8ba1\u63d0\u65b9\u6848\u662f\u6309\u5b63\u4e14\u9ed8\u8ba4\u4e3a\u5c5e\u671f\u5185\u8ba1\u63d0\uff0c\u8bf7\u9009\u62e93\u30016\u30019\u300112\u6708\u4efd\uff0c\u6216\u624b\u52a8\u9009\u62e9\u6240\u5c5e\u7a0e\u671f\u8d77\u6b62\u65e5\u671f", (String)"AccrualDraftFormPlugin_6", (String)"taxc-tcret", (Object[])new Object[0]));
                    break;
                }
                if (!parameter.booleanValue()) {
                    startDate = DateUtils.getMinDateBeforeSomeMonth((Date)accrualDate, (int)-3);
                    endDate = DateUtils.getMaxDateBeforeSomeMonth((Date)accrualDate, (int)-1);
                    break;
                }
                startDate = DateUtils.getMinDateBeforeSomeMonth((Date)accrualDate, (int)-2);
                endDate = DateUtils.getMaxDateBeforeSomeMonth((Date)accrualDate, (int)0);
                break;
            }
            case "year": {
                if (!DateUtils.isFirstMonthWithinYear((Date)accrualDate) && !parameter.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8ba1\u63d0\u65b9\u6848\u662f\u6309\u5e74\u4e14\u9ed8\u8ba4\u4e3a\u5c5e\u671f\u7ec8\u4e86\u540e\u8ba1\u63d0\uff0c\u8bf7\u9009\u62e91\u6708\u4efd\uff0c\u6216\u624b\u52a8\u9009\u62e9\u6240\u5c5e\u7a0e\u671f\u8d77\u6b62\u65e5\u671f", (String)"AccrualDraftFormPlugin_7", (String)"taxc-tcret", (Object[])new Object[0]));
                    break;
                }
                if (!AccrualDraftFormPlugin.isInPeriodParamWithinYear(accrualDate) && parameter.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8ba1\u63d0\u65b9\u6848\u662f\u6309\u5e74\u4e14\u9ed8\u8ba4\u4e3a\u5c5e\u671f\u5185\u8ba1\u63d0\uff0c\u8bf7\u9009\u62e912\u6708\u4efd\uff0c\u6216\u624b\u52a8\u9009\u62e9\u6240\u5c5e\u7a0e\u671f\u8d77\u6b62\u65e5\u671f", (String)"AccrualDraftFormPlugin_8", (String)"taxc-tcret", (Object[])new Object[0]));
                    break;
                }
                if (!parameter.booleanValue()) {
                    startDate = DateUtils.getMinDateBeforeSomeMonth((Date)accrualDate, (int)-12);
                    endDate = DateUtils.getMaxDateBeforeSomeMonth((Date)accrualDate, (int)-1);
                    break;
                }
                startDate = DateUtils.getMinDateBeforeSomeMonth((Date)accrualDate, (int)-11);
                endDate = DateUtils.getMaxDateBeforeSomeMonth((Date)accrualDate, (int)0);
                break;
            }
        }
        if (!(needCheckSkssqq.booleanValue() || Objects.equals(this.getModel().getValue("skssqq"), startDate) && Objects.equals(this.getModel().getValue("skssqz"), endDate))) {
            this.getPageCache().put("is_same_periodchange", "is_same_periodchange");
        }
        this.getModel().setValue("skssqq", (Object)startDate);
        this.getModel().setValue("skssqz", (Object)endDate);
    }

    private void loadData() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (taxOrg == null || skssqq == null || skssqz == null) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Long orgId = taxOrg.getLong("id");
        boolean isNotPass = OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgId), (String)"itp", (String)this.getTaxCardTaxName(), (String)this.getAccrualDraftType());
        if (isNotPass) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{orgId}), (Long)AccrualListEnum.getBaseTaxIdByCategory((String)this.getAccrualDraftType()), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz")).getData();
        if (dynamicObjectCollection.size() == 0 || ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.enable").equals("0")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AccrualDraftFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
            return;
        }
        DynamicObject accrual = this.getModel().getDataEntity(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"recal", "save"});
        this.showWhileEdit(accrual);
        DynamicObject accrualDraftObject = AccrualServiceHelper.queryAccrual(taxOrg.getLong("id"), this.getAccrualDraftType(), skssqq, skssqz);
        this.setBtnStatus(accrualDraftObject, this.getAccrualDraftType());
        if (accrualDraftObject != null) {
            Long pkId = accrualDraftObject.getLong("id");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("org", accrualDraftObject.getDynamicObject("org").get("id"));
            customParams.put("accrualdate", this.getModel().getValue("accrualdate"));
            customParams.put("skssqq", skssqq);
            customParams.put("skssqz", skssqz);
            customParams.put("drafttype", this.getAccrualDraftType());
            PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), (Object)pkId, (IFormView)this.getView(), customParams, (OperationStatus)OperationStatus.EDIT);
        } else {
            this.doCalcAccrualDetails();
        }
    }

    private String getTaxCardTaxName() {
        String accrualDraftType = this.getAccrualDraftType();
        if ("fcs".equals(accrualDraftType) || "cztdsys".equals(accrualDraftType)) {
            return "fcscztdsys";
        }
        if ("ccs".equals(accrualDraftType)) {
            return null;
        }
        return accrualDraftType;
    }

    protected void showWhileEdit(DynamicObject accrual) {
        if ("B".equals(accrual.getString("billstatus")) && this.getPageCache().get("refresh") == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"recal", "save"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u4fee\u6539", (String)"AccrualDraftFormPlugin_9", (String)"taxc-tcret", (Object[])new Object[0]));
        }
        if ("C".equals(accrual.getString("billstatus")) && this.getPageCache().get("refresh") == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"recal", "save"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u5df2\u5ba1\u6838\uff0c\u4e0d\u53ef\u4fee\u6539", (String)"AccrualDraftFormPlugin_10", (String)"taxc-tcret", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue("org");
        switch (operateKey) {
            case "recal": {
                Long orgId = taxorg.getLong("id");
                boolean isNotPass = OrgCheckUtil.check((IFormView)this.getView(), (String)String.valueOf(orgId), (String)"itp", (String)this.getTaxCardTaxName(), (String)this.getAccrualDraftType());
                if (isNotPass) {
                    return;
                }
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange((List)Lists.newArrayList((Object[])new Long[]{orgId}), (Long)AccrualListEnum.getBaseTaxIdByCategory((String)this.getAccrualDraftType()), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz")).getData();
                if (dynamicObjectCollection.size() == 0 || ((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.enable").equals("0")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u8ba1\u63d0\u65b9\u6848\u3002", (String)"AccrualDraftFormPlugin_4", (String)"taxc-tcret", (Object[])new Object[0]));
                    this.getModel().setValue("skssqq", null);
                    this.getModel().setValue("skssqz", null);
                    DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
                    entryentity.clear();
                    this.getView().updateView();
                    return;
                }
                this.getModel().setValue("accrualplan", ((DynamicObject)dynamicObjectCollection.get(0)).get("ruleentity.rule"));
                if (!this.checkPeriod(((DynamicObject)dynamicObjectCollection.get(0)).getString("ruleentity.rule.cycle")).booleanValue()) break;
                this.doCalcAccrualDetails();
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.releaseMutex();
                this.summit(operateKey, this.getModel().getDataEntity());
                this.addMutex();
                DynamicObject object = AccrualServiceHelper.queryAccrualById(this.getModel().getDataEntity().getLong("id"));
                this.setBtnStatus(object, this.getAccrualDraftType());
                break;
            }
            case "save": 
            case "newjtd": 
            case "deletejtd": {
                this.setBtnStatus(AccrualServiceHelper.queryAccrualById(this.getModel().getDataEntity().getLong("id")), this.getAccrualDraftType());
                break;
            }
            case "checkjtd": {
                this.openProvistonBillPage(taxorg.getString("id"), this.getModel().getDataEntity().getString("taxsystem.id"), this.getModel().getDataEntity().getString("billno"));
            }
        }
    }

    private void doAccrualDateChanged() {
        Boolean result;
        if (Objects.equals(this.getPageCache().get("is_same_periodchange"), "is_same_periodchange")) {
            this.getPageCache().remove("is_same_periodchange");
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        DynamicObject plan = (DynamicObject)this.getModel().getValue("accrualplan");
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        if (plan != null && taxOrg != null && (result = this.checkPeriod(plan.getString("cycle"))).booleanValue()) {
            this.showBill();
        }
    }

    private void showBill() {
        DynamicObject taxOrg = (DynamicObject)this.getModel().getValue("org");
        Date skssqq = (Date)this.getModel().getValue("skssqq");
        Date skssqz = (Date)this.getModel().getValue("skssqz");
        if (taxOrg == null || skssqq == null || skssqz == null) {
            return;
        }
        DynamicObject accrualDraftObject = AccrualServiceHelper.queryAccrual(taxOrg.getLong("id"), this.getAccrualDraftType(), skssqq, skssqz);
        Long pkId = null;
        OperationStatus operationStatus = OperationStatus.ADDNEW;
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        if (accrualDraftObject != null) {
            pkId = accrualDraftObject.getLong("id");
            operationStatus = OperationStatus.EDIT;
        }
        customParams.put("org", taxOrg.getLong("id"));
        customParams.put("accrualdate", this.getModel().getValue("accrualdate"));
        customParams.put("skssqq", skssqq);
        customParams.put("skssqz", skssqz);
        customParams.put("drafttype", this.getAccrualDraftType());
        this.releaseMutex();
        PageShowCommon.showBill((ShowType)ShowType.InCurrentForm, (String)this.getEntityName(), (Object)pkId, (IFormView)this.getView(), customParams, (OperationStatus)operationStatus);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isSubmit;
        boolean bl = isSubmit = args.getSource() instanceof Donothing && "submit".equals(((Donothing)args.getSource()).getOperateKey());
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit || isSubmit) {
            DynamicObject org;
            for (int i = 0; i < this.getModel().getEntryEntity("entryentity").size(); ++i) {
                this.getModel().setValue("updaco", (Object)"1", i);
            }
            DynamicObject plan = (DynamicObject)this.getModel().getValue("accrualplan");
            if (plan != null && !this.checkPeriod(plan.getString("cycle")).booleanValue()) {
                args.setCancel(true);
            }
            if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8ba1\u63d0\u660e\u7ec6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccrualDraftFormPlugin_11", (String)"taxc-tcret", (Object[])new Object[0]));
            }
            if ((org = (DynamicObject)this.getModel().getValue("org")) != null && !TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)org.getLong("id")).isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"AccrualDraftFormPlugin_12", (String)"taxc-tcret", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!"tcret_fcs_accrual_draft".equals(formId) && ("save".equals(key) || "bar_close".equals(key))) {
            this.releaseMutex();
        }
    }

    private void releaseMutex() {
        MutexServiceImpl.releaseMutexLocks((String)String.valueOf(this.getModel().getValue("id")), (String)"modify", (Long)RequestContext.get().getCurrUserId());
    }

    private void doTaxOrgChanged(PropertyChangedArgs e) {
        this.doSetAccountOrg();
        this.doSetAccrualItem();
        this.showBill();
    }

    protected String getEntityName() {
        return this.getView().getEntityId();
    }

    protected String getAccrualDraftType() {
        return this.getCustomParam("drafttype");
    }

    protected String getCustomParam(String field) {
        return (String)this.getView().getFormShowParameter().getCustomParam(field);
    }

    protected Boolean checkPeriod(String taxLimit) {
        Date endDate;
        Date startDate = (Date)this.getModel().getValue("skssqq");
        boolean result = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)(endDate = (Date)this.getModel().getValue("skssqz")));
        if (!result) {
            switch (taxLimit) {
                case "month": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u6574\u6708\u5ea6", (String)"AccrualDraftFormPlugin_13", (String)"taxc-tcret", (Object[])new Object[0]));
                    break;
                }
                case "season": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u6574\u5b63\u5ea6", (String)"AccrualDraftFormPlugin_14", (String)"taxc-tcret", (Object[])new Object[0]));
                    break;
                }
                case "year": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u6574\u5e74\u5ea6", (String)"AccrualDraftFormPlugin_15", (String)"taxc-tcret", (Object[])new Object[0]));
                }
            }
        }
        return result;
    }

    private static boolean isInPeriodParamWithinSeason(Date date) {
        int monthOfDate = DateUtils.getMonthOfDate((Date)date);
        return Arrays.asList(3, 6, 9, 12).contains(monthOfDate);
    }

    private static boolean isInPeriodParamWithinYear(Date date) {
        return 12 == DateUtils.getMonthOfDate((Date)date);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void summit(String itemKey, DynamicObject object) {
        if (object != null && this.attachKey.contains(this.getAccrualDraftType())) {
            OperationResult result;
            if (itemKey.equals("submit")) {
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getModel().getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, (OperateOption)OperateOption.create());
                if (!saveResult.isSuccess()) {
                    this.getView().showOperationResult(saveResult);
                    return;
                }
                result = OperationServiceHelper.executeOperate((String)"submit", (String)"tcret_fcs_accrual_draft", (Object[])new Object[]{object.get("id")}, (OperateOption)OperateOption.create());
            } else {
                result = OperationServiceHelper.executeOperate((String)itemKey, (String)"tcret_fcs_accrual_draft", (Object[])new Object[]{object.get("id")}, (OperateOption)OperateOption.create());
            }
            boolean isSuccess = result.isSuccess();
            boolean isAuditSuccess = true;
            boolean isSubmitandaudit = Optional.ofNullable(ParameterReader.getBillParameter((String)"tcret_fcs_accrual_draft")).map(e -> e.getBoolean("submitandaudit")).orElse(false);
            if (itemKey.equals("submit")) {
                if (isSuccess && isSubmitandaudit) {
                    result = OperationServiceHelper.executeOperate((String)"audit", (String)"tcret_fcs_accrual_draft", (Object[])new Object[]{object.get("id")}, (OperateOption)OperateOption.create());
                    isAuditSuccess = result.isSuccess();
                }
                if (isSuccess && isAuditSuccess) {
                    String msg = isSubmitandaudit ? ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"AccrualDraftFormPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"AccrualDraftFormPlugin_17", (String)"taxc-tcret", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(msg);
                }
                if (!isSuccess || !isAuditSuccess) {
                    this.getView().showOperationResult(result);
                }
            } else if (!isSuccess) {
                this.getView().showOperationResult(result);
            } else {
                String msg = itemKey.equals("audit") ? ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"AccrualDraftFormPlugin_16", (String)"taxc-tcret", (Object[])new Object[0]) : (itemKey.equals("unaudit") ? ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"AccrualDraftFormPlugin_18", (String)"taxc-tcret", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"AccrualDraftFormPlugin_19", (String)"taxc-tcret", (Object[])new Object[0]));
                this.getView().showSuccessNotification(msg);
            }
            this.getPageCache().put("refresh", "1");
            this.getView().invokeOperation("refresh");
        }
    }

    private void setBtnStatus(DynamicObject dynamicObject, String draftType) {
        if (dynamicObject != null) {
            String billstatus = dynamicObject.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "save", "recal"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "newjtd"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unsubmit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
                if (dynamicObject.getLong("id") == 0L) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                }
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_audit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"save", "recal", "newjtd"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit", "bar_unaudit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unsubmit", "bar_audit"});
            }
            if ("C".equals(billstatus)) {
                if (dynamicObject.containsProperty("generatebusinessdoc") && dynamicObject.getString("generatebusinessdoc").equals("false")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd", "bar_audit"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"save", "recal"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"newjtd", "bar_unaudit"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"checkjtd", "deletejtd", "bar_audit"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"newjtd"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                    this.getView().setEnable(Boolean.TRUE, new String[]{"checkjtd", "deletejtd"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"newjtd"});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"newjtd", "bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unsubmit"});
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("taxtype.number", "007,008,009,011,018,022");
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

